/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * @fileoverview Constant declarations for common key values.
 */

goog.provide('goog.events.Keys');


/**
 * Key values for common characters.
 *
 * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key
 * @enum {string}
 */
goog.events.Keys = {
  ALT: 'Meta',
  ALTGRAPH: 'AltGraph',
  BACKSPACE: 'Backspace',
  CTRL: 'Control',
  DELETE: 'Delete',
  DOWN: 'ArrowDown',
  END: 'End',
  ENTER: 'Enter',
  ESCAPE: 'Escape',
  HOME: 'Home',
  INSERT: 'Insert',
  LEFT: 'ArrowLeft',
  PAGE_DOWN: 'PageDown',
  PAGE_UP: 'PageUp',
  RIGHT: 'ArrowRight',
  SHIFT: 'Shift',
  SPACE: ' ',
  TAB: 'Tab',
  UP: 'ArrowUp',
};
