/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */

// AUTOGENERATED. DO NOT EDIT.
// clang-format off

goog.module('goog.html.javascriptUrlTestVectors');
goog.setTestOnly('goog.html.javascriptUrlTestVectors');

/** @typedef {{input: string, expected: string, safe: boolean }} */
let TestVector;

/** @const {!Array<!TestVector>} */
const BASE_VECTORS = [
      {input: '', expected: '', safe: true},
      {input: 'http://example.com/', expected: 'http://example.com/', safe: true},
      {input: 'https://example.com', expected: 'https://example.com', safe: true},
      {input: 'mailto:foo@example.com', expected: 'mailto:foo@example.com', safe: true},
      {input: 'ftp://example.com', expected: 'ftp://example.com', safe: true},
      {input: 'ftp://username@example.com', expected: 'ftp://username@example.com', safe: true},
      {input: 'ftp://username:password@example.com', expected: 'ftp://username:password@example.com', safe: true},
      {input: 'HTtp://example.com/', expected: 'HTtp://example.com/', safe: true},
      {input: 'https://example.com/path?foo\u003Dbar#baz', expected: 'https://example.com/path?foo\u003Dbar#baz', safe: true},
      {input: 'https://example.com:123/path?foo\u003Dbar\u0026abc\u003Ddef#baz', expected: 'https://example.com:123/path?foo\u003Dbar\u0026abc\u003Ddef#baz', safe: true},
      {input: '//example.com/path', expected: '//example.com/path', safe: true},
      {input: '/path', expected: '/path', safe: true},
      {input: '/path?foo\u003Dbar#baz', expected: '/path?foo\u003Dbar#baz', safe: true},
      {input: 'path', expected: 'path', safe: true},
      {input: 'path?foo\u003Dbar#baz', expected: 'path?foo\u003Dbar#baz', safe: true},
      {input: 'p//ath', expected: 'p//ath', safe: true},
      {input: 'p//ath?foo\u003Dbar#baz', expected: 'p//ath?foo\u003Dbar#baz', safe: true},
      {input: '#baz', expected: '#baz', safe: true},
      {input: '?:', expected: '?:', safe: true},
      {input: 'not-data:image/png;base64,z\u003D', expected: 'not-data:image/png;base64,z\u003D', safe: true},
      {input: 'data:image/png;base64,z\u003D', expected: 'data:image/png;base64,z\u003D', safe: true},
      {input: 'tel:+1234567890', expected: 'tel:+1234567890', safe: true},
      {input: 'sms:+1234567890', expected: 'sms:+1234567890', safe: true},
      {input: 'callto:+1234567890', expected: 'callto:+1234567890', safe: true},
      {input: 'wtai://wp/mc;+1234567890', expected: 'wtai://wp/mc;+1234567890', safe: true},
      {input: 'rtsp://example.org/', expected: 'rtsp://example.org/', safe: true},
      {input: 'market://details?id\u003Dapp', expected: 'market://details?id\u003Dapp', safe: true},
      {input: 'itms://itunes.apple.com/us', expected: 'itms://itunes.apple.com/us', safe: true},
      {input: 'javascript:evil(1);', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'javascript:evil(2);//\u000Ahttp://good.com/', expected: 'about:invalid#zClosurez', safe: false},
      {input: ' javascript:evil(3);', expected: 'about:invalid#zClosurez', safe: false},
      {input: '\u0009javascript:evil(4);', expected: 'about:invalid#zClosurez', safe: false},
      {input: '\u000Bjavascript:evil(5);', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'JaVasCriPT:evil(6);', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'javascript:evil(8);', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'javascript:evil(9);', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'javasc\u0009ript:evil(10);', expected: 'about:invalid#zClosurez', safe: false},
      {input: 'javasc\u0009ript:evil(11);', expected: 'about:invalid#zClosurez', safe: false}
];

/** @const {!Array<!TestVector>} */
const TEL_VECTORS = [
];

/** @const {!Array<!TestVector>} */
const SMS_VECTORS = [
];

/** @const {!Array<!TestVector>} */
const SSH_VECTORS = [
];

exports = {BASE_VECTORS, TEL_VECTORS, SMS_VECTORS, SSH_VECTORS};
