(ns pretty-spec.core
  (:require [clojure.spec.alpha :as s]
            [fipp.engine :refer [pprint-document]]
            [fipp.clojure :as fipp-clojure]
            [fipp.edn :as fipp-edn]
            [fipp.visit :as fipp-visit :refer [visit]]
            [pretty-spec.printer :as printer]
            [clojure.string :as str])) 


(defn- build-arg-pairs [p [f & args]]
  [:group "("
   [:align (visit p f) :line
    (->> (partition 2 args)
         (map (fn [[p1 p2]]
                [:span (visit p p1) " " (visit p p2)]))
         (interpose :line))
    ")"]])

(defn- build-one-arg-and-opts [p [f & args]]
  [:group "("
   [:align (visit p f) :line (visit p (first args))
    (when (next args) :line)
    (->> (partition 2 (rest args))
         (map (fn [[optk optv]]
                [:span (visit p optk) " " (visit p optv)]))
         (interpose :line))
    ")"]])

(defn- build-two-arg-and-opts [p [f kp vp & args]]
  [:group "("
   [:align (visit p f) :line (visit p kp) :line (visit p vp)
    (when (next args) :line)
    (->> (partition 2 args)
         (map (fn [[optk optv]]
                [:span (visit p optk) " " (visit p optv)]))
         (interpose :line))
    ")"]])

(defn- build-args [p [f & args]]
  [:group "("
   [:align (visit p f) :line 
    (->> args
         (map (partial visit p))
         (interpose :line))
    ")"]])

(defn- build-keys-vec [p ks]
  [:group "["
   [:align (->> ks
                (map (partial visit p))
                (interpose :line))]
   "]"])

(defn- build-keys [p [f & args]]
  [:group "("
   [:align (visit p f) :line 
    (->> (partition 2 args)
         (map (fn [[k v]]
                [:span (visit p k) " " (build-keys-vec p v)]))
         (interpose :line))
    ")"]])

(defn- build-one-arg [p [f & args]]
  [:group "("
   [:align (visit p f) " " (visit p (first args)) ")"]])


(defn build-symbol-map [dispatch]
  (into {} (for [[pretty-fn syms] dispatch
                 sym syms
                 sym (cons sym [(symbol "clojure.spec.alpha" (name sym))
                                (symbol "cljs.spec.alpha" (name sym))])]
             [sym pretty-fn])))

(def default-symbols
  (build-symbol-map
   {build-arg-pairs        '[fspec or cat alt]
    build-one-arg-and-opts '[coll-of map-of]
    build-two-arg-and-opts '[map-of]
    build-args             '[and merge conformer tuple]
    build-keys             '[keys]
    build-one-arg          '[? + * nilable]}))

(defn spec-printer [options]
  (printer/map->EdnPrinter (merge {:symbols (merge default-symbols
                                                   fipp-clojure/default-symbols)}
                                  options)))

(def ^:dynamic *print-document* false)

(defn pprint
  "Pretty prints a spec form as returned by (clojure.spec/form ...)
  Options are the same as in https://github.com/brandonbloom/fipp plus 
  :ns-aliases, a map of strings to string with ns replacements."
  ([form] (pprint form {}))
  ([form options]
   (pprint form options (spec-printer options)))
  ([form options printer]
   (let [doc (fipp-visit/visit printer form)]
     (when *print-document*
       (prn "------------ Fipp doc ----------")
       (fipp-edn/pprint doc)
       (prn "------------ End Fipp doc ----------"))
     (pprint-document doc options))))

(defn ranged-rand
  "Returns random int in range start <= rand <= end"
  [start end]
  (+ start (long (rand (- end start)))))

(defn other [a b])

(s/def ::ranged-rand-args (s/and #(< (:start %) (:end %))))
(s/def ::other-args (s/and #(< (:start %1) (:end %2))))

(defn ranged-rand
  "Returns random int in range start <= rand <= end"
  [start end]
  (+ start (long (rand (- end start)))))

(s/fdef ranged-rand
        :args (s/and (s/cat :start int? :end int?)
                     #(< (:start %) (:end %)))
        :ret int?
        :fn (s/and #(>= (:ret %) (-> % :args :start))
                   #(< (:ret %) (-> % :args :end))))
(s/fdef other
        :args (s/and #(< (:start %1) (:end %2))))


(s/form (s/get-spec 'pretty-spec.core/other))
(s/form ::other-args)
(s/form ::ranged-rand-args)
(s/form (s/get-spec 'pretty-spec.core/ranged-rand))


(clojure.spec.alpha/and (fn* [p1__21994#] (clojure.core/< (:start p1__21994#) (:end p1__21994#))))
(clojure.spec.alpha/and (clojure.core/fn [%] (clojure.core/< (:start %) (:end %))))

(s/def ::example-one-args (s/and #(< (:start %) (:end %))))
(s/form ::example-one-args)
;; => (clojure.spec.alpha/and (clojure.core/fn [%] (clojure.core/< (:start %) (:end %))))

(s/fdef example-one
        :args (s/and #(< (:start %) (:end %))))
(s/form 'pretty-spec.core/example-one)
;; => (clojure.spec.alpha/fspec :args (clojure.spec.alpha/and (fn* [p1__22097#] (clojure.core/< (:start p1__22097#) (:end p1__22097#)))))

;; just removing the s/and shows fn with % instead of special symbol fn*
(s/fdef example-two
        :args #(< (:start %) (:end %)))
(s/form 'pretty-spec.core/example-two)
;; => (clojure.spec.alpha/fspec :args (clojure.core/fn [%] (clojure.core/< (:start %) (:end %))))

(let [a 10])
(comment

  (let [input "29917128875332952564321392569634257121244516819997569284938677239676779378822158323549832814412597817651244117851771257438674567254146559419528411463781241159837576747416543451994579655175322397355255587935456185669334559882554936642122347526466965746273596321419312386992922582836979771421518356285534285825212798113159911272923448284681544657616654285632235958355867722479252256292311384799669645293812691169936746744856227797779513997329663235176153745581296191298956836998758194274865327383988992499115472925731787228592624911829221985925935268785757854569131538763133427434848767475989173579655375125972435359317237712667658828722623837448758528395981635746922144957695238318954845799697142491972626942976788997427135797297649149849739186827185775786254552866371729489943881272817466129271912247236569141713377483469323737384967871876982476485658337183881519295728697121462266226452265259877781881868585356333494916519693683238733823362353424927852348119426673294798416314637799636344448941782774113142925315947664869341363354235389597893211532745789957591898692253157726576488811769461354938575527273474399545366389515353657644736458182565245181653996192644851687269744491856672563885457872883368415631469696994757636288575816146927747179133188841148212825453859269643736199836818121559198563122442483528316837885842696283932779475955796132242682934853291737434482287486978566652161245555856779844813283979453489221189332412315117573259531352875384444264457373153263878999332444178577127433891164266387721116357278222665798584824336957648454426665495982221179382794158366894875864761266695773155813823291684611617853255857774422185987921219618596814446229556938354417164971795294741898631698578989231245376826359179266783767935932788845143542293569863998773276365886375624694329228686284863341465994571635379257258559894197638117333711626435669415976255967412994139131385751822134927578932521461677534945328228131973291962134523589491173343648964449149716696761218423314765168285342711137126239639867897341514131244859826663281981251614843274762372382114258543828157464392"]
    (->> input
         cycle
         (take (inc (count input)))
         (partition 2 1)
         (keep (fn [[a b]] (when (= a b) (- (int a) 48))))
         (reduce +)))

  (def input [[1640	590	93	958	73	1263	1405	1363	737	712	1501	390	68	1554	959	79]
              [4209	128	131	2379	2568	2784	2133	145	3618	1274	3875	158	1506	3455	1621	3799]
              [206	1951	2502	2697	2997	74	76	78	1534	81	2775	2059	3026	77	2600	3067]
              [373	1661	94	102	2219	1967	1856	417	1594	75	100	2251	2200	1825	1291	1021]
              [57	72	51	1101	1303	60	1227	421	970	1058	138	333	1320	1302	402	1210]
              [4833	5427	179	3934	4533	5124	4832	2088	94	200	199	1114	4151	1795	208	3036]
              [759	876	110	79	1656	1691	185	544	616	312	757	1712	92	97	1513	1683]
              [1250	1186	284	107	1190	1233	573	1181	1041	655	132	547	395	146	119	515]
              [505	1726	79	180	86	1941	1597	1785	1608	1692	968	1177	94	184	91	31]
              [1366	2053	1820	1570	70	506	53	415	717	1263	82	366	74	1255	2020	1985]
              [2365	5585	2285	4424	5560	3188	3764	187	88	223	1544	5023	4013	5236	214	196]
              [1487	1305	1359	1615	6579	2623	4591	150	5030	188	146	4458	5724	5828	1960	221]
              [3114	688	3110	334	1921	153	4083	131	2234	3556	3573	3764	127	919	3293	104]
              [1008	78	1196	607	135	1409	296	475	915	157	1419	1304	153	423	163	704]
              [235	4935	4249	3316	1202	221	1835	380	249	1108	1922	5607	4255	238	211	3973]
              [1738	207	179	137	226	907	1468	1341	1582	1430	851	213	393	1727	1389	632]])

  (let [input input
        row-check (fn [r]
                    (- (apply max r)
                       (apply min r)))]
    (->> (map row-check input)
         (reduce +)))
  (require '[clojure.string :as str])

  (let [phrases (str/split-lines (slurp "/home/jmonetta/Downloads/input.txt"))
        valid? (fn [phr]
                 (let [words (str/split phr #" ")]
                   (= (count words) (count (set words)))))]
    (count (filter valid? phrases)))


  
  (loop [program #_[0 3  0  1  -3] (into [] (map #(Integer/parseInt %) (str/split-lines (slurp "/home/jmonetta/Downloads/input.txt"))))
         c 0
         ip 0]
    (if (get program ip)
      (recur (update program ip inc)
             (inc c)
             (+ ip (get program ip)))
      c))

  (ns geometry-project.core
    (:require [clojure.spec.alpha :as s]))

  (s/def :shapes/triangle (s/cat :base int? :height int?))

  (meta (s/get-spec :shapes/triangle)) ;; => nil
  )
