/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.config.ConditionalOnPropertyNotEmpty;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

public class ConditionalOnPropertyNotEmptyCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(ConditionalOnPropertyNotEmpty.class.getName()));
        if (attributes == null) {
            return ConditionOutcome.noMatch((String)"@ConditionalOnPropertyNotEmpty annotation not found");
        }
        String propertyName = this.getPropertyName(attributes);
        String propertyValue = context.getEnvironment().getProperty(propertyName);
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnPropertyNotEmpty.class, (Object[])new Object[0]);
        if (!StringUtils.hasText((String)propertyValue)) {
            return ConditionOutcome.noMatch((ConditionMessage)message.because("property '" + propertyName + "' is empty or not set"));
        }
        return ConditionOutcome.match((ConditionMessage)message.because("property '" + propertyName + "' has value: " + propertyValue));
    }

    private String getPropertyName(AnnotationAttributes attributes) {
        Object propertyName;
        String prefix = attributes.getString("prefix");
        String name = attributes.getString("name");
        String value = attributes.getString("value");
        Object object = propertyName = StringUtils.hasText((String)name) ? name : value;
        if (StringUtils.hasText((String)prefix)) {
            propertyName = prefix + "." + (String)propertyName;
        }
        return propertyName;
    }
}

