/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.LocaleResolver;

@Component
public class CustomAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private final UserJdbcService userJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final LocaleResolver localeResolver;

    public CustomAuthenticationSuccessHandler(UserJdbcService userJdbcService, UserSettingsJdbcService userSettingsJdbcService, LocaleResolver localeResolver) {
        this.userJdbcService = userJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.localeResolver = localeResolver;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        String username = authentication.getName();
        Optional userOptional = this.userJdbcService.findByUsername(username);
        if (userOptional.isPresent()) {
            User user = (User)userOptional.get();
            UserSettings userSettings = this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId());
            Locale userLocale = userSettings.getSelectedLanguage().getLocale();
            this.localeResolver.setLocale(request, response, userLocale);
        }
        response.sendRedirect("/");
    }
}

