/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.model.security.ExternalUser;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.service.AvatarService;
import com.dedicatedcode.reitti.service.UserService;
import java.net.URI;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CustomOidcUserService
extends OidcUserService {
    private static final Logger log = LogManager.getLogger(CustomOidcUserService.class);
    private final UserJdbcService userJdbcService;
    private final UserService userService;
    private final AvatarService avatarService;
    private final boolean registrationEnabled;
    private final boolean localLoginDisabled;
    private final RestTemplate restTemplate;

    public CustomOidcUserService(UserJdbcService userJdbcService, UserService userService, AvatarService avatarService, RestTemplate restTemplate, @Value(value="${reitti.security.oidc.registration.enabled}") boolean registrationEnabled, @Value(value="${reitti.security.local-login.disable:false}") boolean localLoginDisabled) {
        this.userJdbcService = userJdbcService;
        this.userService = userService;
        this.avatarService = avatarService;
        this.restTemplate = restTemplate;
        this.registrationEnabled = registrationEnabled;
        this.localLoginDisabled = localLoginDisabled;
    }

    @Transactional
    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        User user;
        Optional<Object> existingUser;
        OidcUser oidcUser = this.getDefaultUser(userRequest);
        Object preferredUsername = userRequest.getIdToken().getPreferredUsername();
        if (preferredUsername == null) {
            preferredUsername = oidcUser.getPreferredUsername();
        }
        if (preferredUsername == null && oidcUser.getUserInfo() != null) {
            preferredUsername = oidcUser.getUserInfo().getPreferredUsername();
        }
        if (preferredUsername == null) {
            preferredUsername = oidcUser.getEmail();
        }
        if (preferredUsername == null) {
            preferredUsername = oidcUser.getGivenName().toLowerCase() + "." + oidcUser.getFamilyName().toLowerCase();
        }
        String oidcUserId = userRequest.getIdToken().getIssuer().toString() + ":" + userRequest.getIdToken().getSubject();
        String displayName = CustomOidcUserService.getDisplayName((OidcUser)oidcUser, (String)preferredUsername);
        String avatarUrl = oidcUser.getPicture();
        String profileUrl = oidcUser.getProfile();
        Optional byOidcUserId = this.userJdbcService.findByExternalId(oidcUserId);
        if (byOidcUserId.isPresent()) {
            existingUser = byOidcUserId;
        } else {
            log.info("Oidc User not found for oidc id: [{}]. Will try to find it by preferred username [{}]", (Object)oidcUserId, preferredUsername);
            Optional byPreferredUserName = this.userJdbcService.findByUsername((String)preferredUsername);
            if (byPreferredUserName.isPresent()) {
                log.info("found user by preferred username: [{}], will update username to [{}]", preferredUsername, (Object)oidcUserId);
                existingUser = Optional.of(((User)byPreferredUserName.get()).withUsername((String)preferredUsername).withExternalId(oidcUserId));
            } else {
                log.info("No user found for [{}] or [{}]", (Object)oidcUserId, preferredUsername);
                existingUser = Optional.empty();
            }
        }
        if (existingUser.isPresent()) {
            user = (User)existingUser.get();
            if (this.localLoginDisabled && !user.getUsername().equals(preferredUsername)) {
                log.info("Updating username for user with id [{}] from [{}] to [{}]", (Object)user.getId(), (Object)user.getUsername(), preferredUsername);
                user = user.withUsername((String)preferredUsername);
            }
            if (this.localLoginDisabled && !user.getPassword().isEmpty()) {
                log.info("Reset password for user with id [{}]. Disabling local login.", (Object)user.getId());
                user = user.withPassword("");
            }
            user = user.withDisplayName(displayName).withProfileUrl(profileUrl).withExternalId(oidcUserId);
            User updatedUser = this.userJdbcService.updateUser(user);
            if (avatarUrl != null && !avatarUrl.trim().isEmpty()) {
                this.downloadAndSaveAvatar(user.getId(), avatarUrl);
            }
            return new ExternalUser(updatedUser, oidcUser);
        }
        if (this.registrationEnabled) {
            user = this.userService.createNewUser((String)preferredUsername, displayName, oidcUserId, profileUrl);
            if (avatarUrl != null && !avatarUrl.trim().isEmpty()) {
                this.downloadAndSaveAvatar(user.getId(), avatarUrl);
            }
            return new ExternalUser(user, oidcUser);
        }
        throw new UsernameNotFoundException("No internal user found for username: " + (String)preferredUsername);
    }

    OidcUser getDefaultUser(OidcUserRequest userRequest) {
        return super.loadUser(userRequest);
    }

    private static String getDisplayName(OidcUser oidcUser, String preferredUsername) {
        Object displayName = oidcUser.getFullName();
        if (displayName == null || ((String)displayName).trim().isEmpty()) {
            displayName = oidcUser.getGivenName() + " " + oidcUser.getFamilyName();
        }
        if (((String)displayName).trim().isEmpty()) {
            displayName = preferredUsername;
        }
        return displayName;
    }

    private void downloadAndSaveAvatar(Long userId, String avatarUrl) {
        try {
            log.info("Downloading avatar from URL: {} for user ID: {}", (Object)avatarUrl, (Object)userId);
            byte[] avatarData = (byte[])this.restTemplate.getForObject(URI.create(avatarUrl), byte[].class);
            if (avatarData != null && avatarData.length > 0) {
                String contentType = this.determineContentType(avatarUrl);
                this.avatarService.updateAvatar(userId, contentType, avatarData);
                log.info("Successfully saved avatar for user ID: {}", (Object)userId);
            } else {
                log.warn("No avatar data received from URL: {}", (Object)avatarUrl);
            }
        }
        catch (Exception e) {
            log.warn("Failed to download avatar from URL: {} for user ID: {}. {}", (Object)avatarUrl, (Object)userId, (Object)e.getMessage());
        }
    }

    private String determineContentType(String avatarUrl) {
        String url = avatarUrl.toLowerCase();
        if (url.contains(".png")) {
            return "image/png";
        }
        if (url.contains(".gif")) {
            return "image/gif";
        }
        if (url.contains(".webp")) {
            return "image/webp";
        }
        return "image/jpeg";
    }
}

