/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class FilePropertySourceInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        HashMap properties = new HashMap();
        applicationContext.getEnvironment().getPropertySources().forEach(source -> {
            if (source instanceof MapPropertySource) {
                MapPropertySource cps = (MapPropertySource)source;
                Arrays.stream(cps.getPropertyNames()).forEach(name -> {
                    if (name.endsWith("_FILE")) {
                        String filePath = Objects.requireNonNull(cps.getProperty(name)).toString();
                        try {
                            String content = new String(Files.readAllBytes(Paths.get(filePath, new String[0]))).trim();
                            String baseName = name.substring(0, name.length() - 5);
                            properties.put(baseName, content);
                        }
                        catch (Exception e) {
                            System.err.println("Error reading file for property " + name + ": " + e.getMessage());
                        }
                    }
                });
            }
        });
        if (!properties.isEmpty()) {
            MapPropertySource propertySource = new MapPropertySource("fileProperties", properties);
            applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)propertySource);
        }
    }
}

