/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.config.MagicLinkAuthenticationToken;
import com.dedicatedcode.reitti.model.security.MagicLinkResourceType;
import com.dedicatedcode.reitti.model.security.MagicLinkToken;
import com.dedicatedcode.reitti.model.security.TokenUser;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.MagicLinkJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class MagicLinkAuthenticationFilter
extends OncePerRequestFilter {
    private final MagicLinkJdbcService magicLinkJdbcService;
    private final UserJdbcService userJdbcService;

    public MagicLinkAuthenticationFilter(MagicLinkJdbcService magicLinkJdbcService, UserJdbcService userJdbcService) {
        this.magicLinkJdbcService = magicLinkJdbcService;
        this.userJdbcService = userJdbcService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (request.getParameter("mt") == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean isMemoryRequest = request.getRequestURI().startsWith("/memories/");
        if (!"/access".equals(request.getRequestURI()) && !isMemoryRequest) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = request.getParameter("mt");
        try {
            Optional user;
            Optional magicLinkToken = this.magicLinkJdbcService.findByRawToken(token);
            if (magicLinkToken.isEmpty()) {
                response.sendRedirect("/error/magic-link?error=invalid");
                return;
            }
            MagicLinkToken linkToken = (MagicLinkToken)magicLinkToken.get();
            if (linkToken.getExpiryDate() != null && linkToken.getExpiryDate().isBefore(Instant.now())) {
                response.sendRedirect("/error/magic-link?error=expired");
                return;
            }
            Long resourceId = null;
            if (isMemoryRequest) {
                try {
                    resourceId = Long.parseLong(request.getRequestURI().substring("/memories/".length()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (linkToken.getResourceType() != MagicLinkResourceType.MEMORY || resourceId == null || resourceId.longValue() != linkToken.getResourceId().longValue()) {
                    response.sendRedirect("/error/magic-link?error=invalid");
                    return;
                }
            }
            if ((user = this.magicLinkJdbcService.findUserIdByToken(linkToken.getId()).flatMap(arg_0 -> ((UserJdbcService)this.userJdbcService).findById(arg_0))).isEmpty()) {
                response.sendRedirect("/error/magic-link?error=user-not-found");
                return;
            }
            this.magicLinkJdbcService.updateLastUsed(linkToken.getId());
            String specialRole = "ROLE_MAGIC_LINK_" + linkToken.getAccessLevel().name();
            MagicLinkAuthenticationToken authentication = new MagicLinkAuthenticationToken((Object)new TokenUser((User)user.get(), linkToken.getResourceType(), resourceId, List.of(specialRole)), null, Collections.singletonList(new SimpleGrantedAuthority(specialRole)), Long.valueOf(linkToken.getId()));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
            if (linkToken.getResourceType() != MagicLinkResourceType.MEMORY) {
                response.sendRedirect("/");
            } else {
                response.sendRedirect("/memories/" + linkToken.getResourceId());
            }
            return;
        }
        catch (Exception e) {
            response.sendRedirect("/error/magic-link?error=processing");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
    }
}

