/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.config.MagicLinkAuthenticationToken;
import com.dedicatedcode.reitti.model.security.MagicLinkToken;
import com.dedicatedcode.reitti.repository.MagicLinkJdbcService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class MagicLinkSessionValidationFilter
extends OncePerRequestFilter {
    private final MagicLinkJdbcService magicLinkJdbcService;

    public MagicLinkSessionValidationFilter(MagicLinkJdbcService magicLinkJdbcService) {
        this.magicLinkJdbcService = magicLinkJdbcService;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        MagicLinkAuthenticationToken magicLinkAuth;
        Optional token;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth instanceof MagicLinkAuthenticationToken && ((token = this.magicLinkJdbcService.findById((magicLinkAuth = (MagicLinkAuthenticationToken)auth).getMagicLinkTokenId().longValue())).isEmpty() || ((MagicLinkToken)token.get()).getExpiryDate() != null && ((MagicLinkToken)token.get()).getExpiryDate().isBefore(Instant.now()))) {
            SecurityContextHolder.clearContext();
            request.getSession().invalidate();
            response.sendRedirect("/error/magic-link?error=invalid");
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

