/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.config.CustomAuthenticationSuccessHandler;
import com.dedicatedcode.reitti.config.CustomOidcUserService;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesMapper;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@ConditionalOnProperty(name={"reitti.security.oidc.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={OAuth2ClientProperties.class})
public class OidcSecurityConfiguration {
    @Bean
    InMemoryClientRegistrationRepository clientRegistrationRepository(OAuth2ClientProperties properties) {
        ArrayList registrations = new ArrayList(new OAuth2ClientPropertiesMapper(properties).asClientRegistrations().values());
        return new InMemoryClientRegistrationRepository(registrations);
    }

    @Bean
    public OAuth2LoginConfigurer<HttpSecurity> oauth2LoginConfigurer(CustomAuthenticationSuccessHandler customAuthenticationSuccessHandler, CustomOidcUserService customOidcUserService) {
        return (OAuth2LoginConfigurer)new OAuth2LoginConfigurer().loginPage("/login").userInfoEndpoint(userInfo -> userInfo.oidcUserService((OAuth2UserService)customOidcUserService)).successHandler((AuthenticationSuccessHandler)customAuthenticationSuccessHandler);
    }

    @Bean
    public LogoutSuccessHandler oidcLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        OidcClientInitiatedLogoutSuccessHandler oidcLogoutSuccessHandler = new OidcClientInitiatedLogoutSuccessHandler(clientRegistrationRepository);
        oidcLogoutSuccessHandler.setPostLogoutRedirectUri("{baseUrl}/login?logout");
        return oidcLogoutSuccessHandler;
    }
}

