/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMQConfig {
    public static final String EXCHANGE_NAME = "reitti-exchange";
    public static final String SIGNIFICANT_PLACE_QUEUE = "reitti.place.created.v2";
    public static final String SIGNIFICANT_PLACE_ROUTING_KEY = "reitti.place.created.v2";
    public static final String RECALCULATE_TRIP_QUEUE = "reitti.trip.recalculate.v2";
    public static final String DETECT_TRIP_RECALCULATION_ROUTING_KEY = "reitti.trip.recalculate.v2";
    public static final String TRIGGER_PROCESSING_PIPELINE_QUEUE = "reitti.processing.v2";
    public static final String TRIGGER_PROCESSING_PIPELINE_ROUTING_KEY = "reitti.processing.start.v2";
    public static final String USER_EVENT_QUEUE = "reitti.user.events.v2";
    public static final String USER_EVENT_ROUTING_KEY = "reitti.user.events.updated.v2";
    public static final String DLX_NAME = "reitti.dlx.exchange";
    public static final String DLQ_NAME = "reitti.dql.v2";

    @Bean
    public TopicExchange exchange() {
        return new TopicExchange(EXCHANGE_NAME);
    }

    @Bean
    TopicExchange deadLetterExchange() {
        return new TopicExchange(DLX_NAME);
    }

    @Bean
    public Queue recaluclateTripQueue() {
        return QueueBuilder.durable((String)"reitti.trip.recalculate.v2").withArgument("x-dead-letter-exchange", (Object)DLX_NAME).withArgument("x-dead-letter-routing-key", (Object)DLQ_NAME).build();
    }

    @Bean
    public Queue significantPlaceQueue() {
        return QueueBuilder.durable((String)"reitti.place.created.v2").withArgument("x-dead-letter-exchange", (Object)DLX_NAME).withArgument("x-dead-letter-routing-key", (Object)DLQ_NAME).build();
    }

    @Bean
    public Queue triggerProcessingQueue() {
        return QueueBuilder.nonDurable((String)TRIGGER_PROCESSING_PIPELINE_QUEUE).withArgument("x-dead-letter-exchange", (Object)DLX_NAME).withArgument("x-dead-letter-routing-key", (Object)DLQ_NAME).build();
    }

    @Bean
    public Queue userEventQueue() {
        return QueueBuilder.nonDurable((String)USER_EVENT_QUEUE).withArgument("x-dead-letter-exchange", (Object)DLX_NAME).withArgument("x-dead-letter-routing-key", (Object)DLQ_NAME).build();
    }

    @Bean
    public Binding significantPlaceBinding(Queue significantPlaceQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)significantPlaceQueue).to(exchange).with("reitti.place.created.v2");
    }

    @Bean
    public Binding recalculateTripBinding(Queue recaluclateTripQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)recaluclateTripQueue).to(exchange).with("reitti.trip.recalculate.v2");
    }

    @Bean
    public Binding triggerProcessingBinding(Queue triggerProcessingQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)triggerProcessingQueue).to(exchange).with(TRIGGER_PROCESSING_PIPELINE_ROUTING_KEY);
    }

    @Bean
    public Binding userEventBinding(Queue userEventQueue, TopicExchange exchange) {
        return BindingBuilder.bind((Queue)userEventQueue).to(exchange).with(USER_EVENT_ROUTING_KEY);
    }

    @Bean
    Queue deadLetterQueue() {
        return new Queue(DLQ_NAME);
    }

    @Bean
    Binding dlqBinding(Queue deadLetterQueue, TopicExchange deadLetterExchange) {
        return BindingBuilder.bind((Queue)deadLetterQueue).to(deadLetterExchange).with(DLQ_NAME);
    }

    @Bean
    public Jackson2JsonMessageConverter messageConverter() {
        return new Jackson2JsonMessageConverter();
    }

    @Bean
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory, Jackson2JsonMessageConverter messageConverter) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)messageConverter);
        return rabbitTemplate;
    }
}

