/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.config.CustomAuthenticationSuccessHandler;
import com.dedicatedcode.reitti.config.HtmxAuthenticationEntryPoint;
import com.dedicatedcode.reitti.config.MagicLinkAuthenticationFilter;
import com.dedicatedcode.reitti.config.MagicLinkSessionValidationFilter;
import com.dedicatedcode.reitti.config.SetupFilter;
import com.dedicatedcode.reitti.config.TokenAuthenticationFilter;
import com.dedicatedcode.reitti.config.UrlTokenAuthenticationFilter;
import com.dedicatedcode.reitti.model.Role;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    @Autowired
    private TokenAuthenticationFilter bearerTokenAuthFilter;
    @Autowired
    private UrlTokenAuthenticationFilter urlTokenAuthenticationFilter;
    @Autowired
    private MagicLinkAuthenticationFilter magicLinkAuthenticationFilter;
    @Autowired
    private MagicLinkSessionValidationFilter magicLinkSessionValidationFilter;
    @Autowired
    private CustomAuthenticationSuccessHandler customAuthenticationSuccessHandler;
    @Autowired
    private SetupFilter setupFilter;
    @Autowired
    private HtmxAuthenticationEntryPoint authenticationEntryPoint;
    @Autowired(required=false)
    private LogoutSuccessHandler oidcLogoutSuccessHandler;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{"/login", "/access", "/error"})).permitAll().requestMatchers(new String[]{"/settings/integrations/reitti.properties"})).hasAnyRole(new String[]{Role.ADMIN.name(), Role.API_ACCESS.name(), Role.USER.name()}).requestMatchers(new String[]{"/settings/logging", "/settings/logging/**"})).hasRole(Role.ADMIN.name()).requestMatchers(new String[]{"/settings/**"})).hasAnyRole(new String[]{Role.ADMIN.name(), Role.USER.name()}).requestMatchers(new String[]{"/api/v1/photos/**"})).hasAnyRole(new String[]{Role.ADMIN.name(), Role.USER.name(), "MAGIC_LINK_FULL_ACCESS", "MAGIC_LINK_ONLY_LIVE_WITH_PHOTOS", "MAGIC_LINK_MEMORY_VIEW_ONLY", "MAGIC_LINK_MEMORY_EDIT_ACCESS"}).requestMatchers(new String[]{"/memories/*/**"})).hasAnyRole(new String[]{Role.ADMIN.name(), Role.USER.name(), "MAGIC_LINK_MEMORY_VIEW_ONLY", "MAGIC_LINK_MEMORY_EDIT_ACCESS"}).requestMatchers(new String[]{"/memories"})).hasAnyRole(new String[]{Role.ADMIN.name(), Role.USER.name()}).requestMatchers(new String[]{"/css/**", "/js/**", "/images/**", "/img/**", "/error/magic-link/**", "/setup/**"})).permitAll().requestMatchers(new String[]{"/actuator/health"})).permitAll().requestMatchers(new String[]{"/api/v1/reitti-integration/notify/**"})).permitAll().anyRequest()).authenticated()).addFilterBefore((Filter)this.magicLinkSessionValidationFilter, AuthorizationFilter.class).addFilterBefore((Filter)this.magicLinkAuthenticationFilter, MagicLinkSessionValidationFilter.class).addFilterBefore((Filter)this.bearerTokenAuthFilter, MagicLinkAuthenticationFilter.class).addFilterBefore((Filter)this.urlTokenAuthenticationFilter, TokenAuthenticationFilter.class).addFilterBefore((Filter)this.setupFilter, MagicLinkSessionValidationFilter.class).csrf(AbstractHttpConfigurer::disable).formLogin(form -> form.loginPage("/login").successHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler)).rememberMe(rememberMe -> rememberMe.key("uniqueAndSecretKey").tokenValiditySeconds(2592000).rememberMeParameter("remember-me").useSecureCookie(false)).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint)).logout(logout -> {
            if (this.oidcLogoutSuccessHandler != null) {
                logout.logoutSuccessHandler(this.oidcLogoutSuccessHandler);
            }
            logout.deleteCookies(new String[]{"JSESSIONID", "remember-me"}).permitAll();
        });
        if (this.oidcLogoutSuccessHandler != null) {
            http.oauth2Login(oauth2 -> oauth2.loginPage("/login").successHandler((AuthenticationSuccessHandler)this.customAuthenticationSuccessHandler)).oauth2Client(Customizer.withDefaults()).oidcLogout(logout -> logout.backChannel(Customizer.withDefaults()));
        }
        return (SecurityFilterChain)http.build();
    }
}

