/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SetupFilter
implements Filter {
    private final UserJdbcService userService;
    private final boolean localLoginDisabled;

    public SetupFilter(UserJdbcService userService, @Value(value="${reitti.security.local-login.disable:false}") boolean localLoginDisabled) {
        this.userService = userService;
        this.localLoginDisabled = localLoginDisabled;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.localLoginDisabled) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestURI = httpRequest.getRequestURI();
        if (requestURI.startsWith("/setup") || requestURI.startsWith("/css") || requestURI.startsWith("/js") || requestURI.startsWith("/images") || requestURI.startsWith("/img") || requestURI.equals("/actuator/health")) {
            chain.doFilter(request, response);
            return;
        }
        if (this.hasAdminWithEmptyPassword()) {
            httpResponse.sendRedirect("/setup");
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean hasAdminWithEmptyPassword() {
        return this.userService.getAllUsers().stream().filter(user -> user.getRole() == Role.ADMIN).anyMatch(admin -> {
            String password = admin.getPassword();
            return password == null || password.isEmpty();
        });
    }
}

