/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.config;

import com.dedicatedcode.reitti.config.BaseTokenAuthenticationFilter;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.ApiTokenService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class UrlTokenAuthenticationFilter
extends BaseTokenAuthenticationFilter {
    public UrlTokenAuthenticationFilter(ApiTokenService apiTokenService) {
        super(apiTokenService);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token = request.getParameter("token");
        if (token != null && !token.isEmpty()) {
            Optional user = this.apiTokenService.getUserByToken(token);
            if (user.isPresent()) {
                User authenticatedUser = ((User)user.get()).withRole(Role.API_ACCESS);
                UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)authenticatedUser, null, authenticatedUser.getAuthorities());
                this.trackApiTokenUsage(request, token);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
            } else {
                response.setStatus(401);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

