/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.service.AvatarService;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/avatars"})
public class AvatarController {
    private final AvatarService avatarService;

    public AvatarController(AvatarService avatarService) {
        this.avatarService = avatarService;
    }

    @GetMapping(value={"/{userId}"})
    public ResponseEntity<byte[]> getAvatar(@PathVariable Long userId) {
        Optional avatarData = this.avatarService.getAvatarByUserId(userId);
        if (avatarData.isEmpty()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Avatar not found");
        }
        AvatarService.AvatarData avatar = (AvatarService.AvatarData)avatarData.get();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)avatar.mimeType()));
        headers.setContentLength((long)avatar.imageData().length);
        headers.setCacheControl(CacheControl.maxAge((long)30L, (TimeUnit)TimeUnit.DAYS));
        return new ResponseEntity((Object)avatar.imageData(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }
}

