/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.controller.error.PageNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class CustomErrorController
implements ErrorController {
    private static final Logger log = LoggerFactory.getLogger(CustomErrorController.class);
    private static final List<String> IGNORED_PATHS = List.of("/favicon.ico", "/js/", "/img/");
    private static final List<Integer> SILENT_CODES = List.of(Integer.valueOf(400), Integer.valueOf(401), Integer.valueOf(403), Integer.valueOf(404));

    @RequestMapping(value={"/error"})
    public Object handleError(HttpServletRequest request, Model model) {
        Object status = request.getAttribute("jakarta.servlet.error.status_code");
        Object errorMessage = request.getAttribute("jakarta.servlet.error.message");
        Object exception = request.getAttribute("jakarta.servlet.error.exception");
        String requestUri = (String)request.getAttribute("jakarta.servlet.error.request_uri");
        if (IGNORED_PATHS.stream().anyMatch(requestUri::startsWith)) {
            return null;
        }
        if (requestUri.startsWith("/api")) {
            return this.handleApiError(status, errorMessage, exception, requestUri);
        }
        return this.handleWebError(status, errorMessage, exception, requestUri, request, model);
    }

    private ResponseEntity<Map<String, Object>> handleApiError(Object status, Object errorMessage, Object exception, String requestUri) {
        Integer statusCode = status != null ? Integer.valueOf(status.toString()) : 500;
        String message = errorMessage != null ? errorMessage.toString() : "An error occurred";
        log.error("API Error {} occurred for request URI: {}, message: {}", new Object[]{statusCode, requestUri, errorMessage, (Throwable)exception});
        HashMap<String, Object> errorResponse = new HashMap<String, Object>();
        errorResponse.put("success", false);
        errorResponse.put("error", message);
        errorResponse.put("status", statusCode);
        switch (statusCode) {
            case 404: {
                errorResponse.put("error", "The requested resource could not be found.");
                break;
            }
            case 403: {
                errorResponse.put("error", "You don't have permission to access this resource.");
                break;
            }
            case 401: {
                errorResponse.put("error", "Authentication required.");
                break;
            }
            case 405: {
                errorResponse.put("error", "Method not allowed.");
                break;
            }
            case 415: {
                errorResponse.put("error", "Unsupported media type.");
                break;
            }
            case 500: {
                errorResponse.put("error", "An internal server error occurred.");
            }
        }
        return ResponseEntity.status((int)statusCode).body(errorResponse);
    }

    private String handleWebError(Object status, Object errorMessage, Object exception, String requestUri, HttpServletRequest request, Model model) {
        if (status != null) {
            Integer statusCode = Integer.valueOf(status.toString());
            model.addAttribute("status", (Object)statusCode);
            HttpStatus httpStatus = HttpStatus.valueOf((int)statusCode);
            model.addAttribute("error", (Object)httpStatus.getReasonPhrase());
            if (!SILENT_CODES.contains(statusCode)) {
                log.error("Error {} occurred for request URI: {}, message: {}", new Object[]{statusCode, requestUri, errorMessage, (Throwable)exception});
            }
            switch (statusCode) {
                case 404: {
                    model.addAttribute("message", (Object)"The page you are looking for could not be found.");
                    break;
                }
                case 403: {
                    model.addAttribute("message", (Object)"You don't have permission to access this resource.");
                    break;
                }
                case 500: {
                    model.addAttribute("message", (Object)"An internal server error occurred. Please try again later.");
                    break;
                }
                default: {
                    model.addAttribute("message", (Object)"An unexpected error occurred.");
                    break;
                }
            }
        } else {
            model.addAttribute("status", (Object)500);
            model.addAttribute("error", (Object)"Internal Server Error");
            model.addAttribute("message", (Object)"An unexpected error occurred. Please try again later.");
            log.error("Unknown error occurred for request URI: {}", (Object)requestUri, (Object)((Throwable)exception));
        }
        if (exception != null && request.getServerName().contains("localhost")) {
            model.addAttribute("trace", (Object)this.getStackTrace((Throwable)exception));
        }
        return "error";
    }

    private String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(throwable.getClass().getName()).append(": ").append(throwable.getMessage()).append("\n");
        for (StackTraceElement element : throwable.getStackTrace()) {
            sb.append("\tat ").append(element.toString()).append("\n");
        }
        if (throwable.getCause() != null) {
            sb.append("Caused by: ").append(this.getStackTrace(throwable.getCause()));
        }
        return sb.toString();
    }

    @ExceptionHandler(value={PageNotFoundException.class})
    public String handlePageNotFound(HttpServletRequest request, Model model) {
        String requestUri = (String)request.getAttribute("jakarta.servlet.error.request_uri");
        model.addAttribute("status", (Object)404);
        model.addAttribute("error", (Object)"Not Found");
        model.addAttribute("message", (Object)"The page you are looking for could not be found.");
        return "error";
    }
}

