/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.controller.MemoryBlockController;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.integration.ImmichIntegration;
import com.dedicatedcode.reitti.model.memory.BlockType;
import com.dedicatedcode.reitti.model.memory.Memory;
import com.dedicatedcode.reitti.model.memory.MemoryBlock;
import com.dedicatedcode.reitti.model.memory.MemoryBlockImageGallery;
import com.dedicatedcode.reitti.model.memory.MemoryBlockPart;
import com.dedicatedcode.reitti.model.memory.MemoryBlockText;
import com.dedicatedcode.reitti.model.memory.MemoryClusterBlock;
import com.dedicatedcode.reitti.model.memory.MemoryTrip;
import com.dedicatedcode.reitti.model.memory.MemoryVisit;
import com.dedicatedcode.reitti.model.security.MagicLinkAccessLevel;
import com.dedicatedcode.reitti.model.security.MagicLinkResourceType;
import com.dedicatedcode.reitti.model.security.TokenUser;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.MemoryTripJdbcService;
import com.dedicatedcode.reitti.repository.MemoryVisitJdbcService;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.service.MemoryService;
import com.dedicatedcode.reitti.service.StorageService;
import com.dedicatedcode.reitti.service.integration.ImmichIntegrationService;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/memories/{memoryId}/blocks"})
public class MemoryBlockController {
    private final MemoryService memoryService;
    private final ImmichIntegrationService immichIntegrationService;
    private final TripJdbcService tripJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final MemoryVisitJdbcService memoryVisitJdbcService;
    private final MemoryTripJdbcService memoryTripJdbcService;
    private final StorageService storageService;

    public MemoryBlockController(MemoryService memoryService, ImmichIntegrationService immichIntegrationService, TripJdbcService tripJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, MemoryVisitJdbcService memoryVisitJdbcService, MemoryTripJdbcService memoryTripJdbcService, StorageService storageService) {
        this.memoryService = memoryService;
        this.immichIntegrationService = immichIntegrationService;
        this.tripJdbcService = tripJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.memoryVisitJdbcService = memoryVisitJdbcService;
        this.memoryTripJdbcService = memoryTripJdbcService;
        this.storageService = storageService;
    }

    @DeleteMapping(value={"/{blockId}"})
    public String deleteBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @PathVariable Long blockId, @RequestHeader(value="HX-Request", required=false) String hxRequest) {
        this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        this.memoryService.deleteBlock(blockId);
        if (hxRequest != null) {
            return "memories/fragments :: empty";
        }
        return "redirect:/memories/" + memoryId;
    }

    @GetMapping(value={"/{blockId}/edit"})
    public String editBlockForm(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @PathVariable Long blockId, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        MemoryBlock block = (MemoryBlock)this.memoryService.getBlockById(user, blockId).orElseThrow(() -> new IllegalArgumentException("Block not found"));
        model.addAttribute("memoryId", (Object)memoryId);
        model.addAttribute("block", (Object)block);
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        switch (1.$SwitchMap$com$dedicatedcode$reitti$model$memory$BlockType[block.getBlockType().ordinal()]) {
            case 1: {
                boolean immichEnabled = this.immichIntegrationService.getIntegrationForUser(user).map(ImmichIntegration::isEnabled).orElse(false);
                model.addAttribute("immichEnabled", (Object)immichEnabled);
                model.addAttribute("imageBlock", this.memoryService.getBlock(user, timezone, memoryId.longValue(), blockId.longValue()).orElseThrow(() -> new IllegalArgumentException("Block not found")));
                return "memories/blocks/edit :: edit-image-gallery-block";
            }
            case 2: {
                this.memoryService.getBlock(user, timezone, memoryId.longValue(), blockId.longValue()).ifPresent(text -> model.addAttribute("textBlock", text));
                return "memories/blocks/edit :: edit-text-block";
            }
            case 3: {
                this.memoryService.getBlock(user, timezone, memoryId.longValue(), blockId.longValue()).ifPresent(b -> model.addAttribute("clusterVisitBlock", b));
                List storedVisits = this.processedVisitJdbcService.findByUserAndTimeOverlap(user, memory.getStartDate(), memory.getEndDate());
                List currentMemoryVisits = this.memoryVisitJdbcService.findByMemoryBlockId(blockId);
                ArrayList availableVisits = new ArrayList();
                currentMemoryVisits.stream().map(v -> new MemoryVisitDto(v.getId().longValue(), v, true, true)).forEach(availableVisits::add);
                storedVisits.stream().filter(v -> currentMemoryVisits.stream().noneMatch(mv -> mv.getStartTime().equals(v.getStartTime()))).forEach(v -> availableVisits.add(new MemoryVisitDto(v.getId().longValue(), MemoryVisit.create((ProcessedVisit)v), false, false)));
                model.addAttribute("availableVisits", availableVisits.stream().sorted(Comparator.comparing(memoryVisitDto -> memoryVisitDto.visit.getStartTime())).toList());
                return "memories/blocks/edit :: edit-cluster-visit-block";
            }
            case 4: {
                List storedTrips = this.tripJdbcService.findByUserAndTimeOverlap(user, memory.getStartDate(), memory.getEndDate());
                List currentMemoryTrips = this.memoryTripJdbcService.findByMemoryBlockId(blockId);
                ArrayList availableTrips = new ArrayList();
                currentMemoryTrips.stream().map(v -> new MemoryTripDto(v.getId().longValue(), v, true, true)).forEach(availableTrips::add);
                storedTrips.stream().filter(v -> currentMemoryTrips.stream().noneMatch(mv -> mv.getStartTime().equals(v.getStartTime()))).forEach(t -> {
                    MemoryVisit startVisit = MemoryVisit.create((ProcessedVisit)t.getStartVisit());
                    MemoryVisit endVisit = MemoryVisit.create((ProcessedVisit)t.getEndVisit());
                    availableTrips.add(new MemoryTripDto(t.getId().longValue(), MemoryTrip.create((Trip)t, (MemoryVisit)startVisit, (MemoryVisit)endVisit), false, false));
                });
                this.memoryService.getBlock(user, timezone, memoryId.longValue(), blockId.longValue()).ifPresent(b -> model.addAttribute("clusterTripBlock", b));
                model.addAttribute("availableTrips", availableTrips.stream().sorted(Comparator.comparing(memoryTripDto -> memoryTripDto.trip.getStartTime())).toList());
                return "memories/blocks/edit :: edit-cluster-trip-block";
            }
        }
        return "memories/blocks/edit";
    }

    @GetMapping(value={"/{blockId}/view"})
    public String viewBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @PathVariable Long blockId, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("blocks", List.of((MemoryBlockPart)this.memoryService.getBlock(user, timezone, memoryId.longValue(), blockId.longValue()).orElseThrow(() -> new IllegalArgumentException("Block not found"))));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        return "memories/view :: view-block";
    }

    @PostMapping(value={"/{blockId}/cluster"})
    public String updateClusterBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @PathVariable Long blockId, @RequestParam(name="selectedParts") List<String> selectedParts, @RequestParam(required=false) String title, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        MemoryClusterBlock block = (MemoryClusterBlock)this.memoryService.getClusterBlock(user, blockId).orElseThrow(() -> new IllegalArgumentException("Cluster block not found"));
        ArrayList<Long> partIds = new ArrayList<Long>();
        if (block.getType() == BlockType.CLUSTER_TRIP) {
            List persistedTrips = this.memoryTripJdbcService.findByMemoryBlockId(blockId);
            block16: for (String selectedPart : selectedParts) {
                String type = selectedPart.substring(0, selectedPart.lastIndexOf("-"));
                long partId = Long.parseLong(selectedPart.substring(selectedPart.lastIndexOf("-") + 4));
                switch (type) {
                    case "m": {
                        MemoryTrip knownMemoryTrip = persistedTrips.stream().filter(p -> p.getId() == partId).findFirst().orElseThrow(() -> new IllegalArgumentException("MemoryTrip not found"));
                        partIds.add(knownMemoryTrip.getId());
                        persistedTrips.remove(knownMemoryTrip);
                        continue block16;
                    }
                    case "t": {
                        Trip trip = (Trip)this.tripJdbcService.findById(Long.valueOf(partId)).orElseThrow(() -> new IllegalArgumentException("Trip not found"));
                        MemoryVisit startVisit = this.memoryVisitJdbcService.save(user, MemoryVisit.create((ProcessedVisit)trip.getStartVisit()), block.getBlockId(), trip.getStartVisit().getId());
                        MemoryVisit endVisit = this.memoryVisitJdbcService.save(user, MemoryVisit.create((ProcessedVisit)trip.getEndVisit()), block.getBlockId(), trip.getEndVisit().getId());
                        MemoryTrip persistedMemoryTrip = this.memoryTripJdbcService.save(user, MemoryTrip.create((Trip)trip, (MemoryVisit)startVisit, (MemoryVisit)endVisit), block.getBlockId(), trip.getId());
                        partIds.add(persistedMemoryTrip.getId());
                        continue block16;
                    }
                }
                throw new IllegalArgumentException("Invalid part id [" + selectedPart + "] detected");
            }
            persistedTrips.forEach(mt -> this.memoryTripJdbcService.deleteById(mt.getId()));
        } else if (block.getType() == BlockType.CLUSTER_VISIT) {
            List persistedVisits = this.memoryVisitJdbcService.findByMemoryBlockId(blockId);
            block17: for (String selectedPart : selectedParts) {
                String type = selectedPart.substring(0, selectedPart.lastIndexOf("-"));
                long partId = Long.parseLong(selectedPart.substring(selectedPart.lastIndexOf("-") + 4));
                switch (type) {
                    case "m": {
                        MemoryVisit knownMemoryVisit = persistedVisits.stream().filter(p -> p.getId() == partId).findFirst().orElseThrow(() -> new IllegalArgumentException("MemoryVisit not found"));
                        partIds.add(knownMemoryVisit.getId());
                        persistedVisits.remove(knownMemoryVisit);
                        continue block17;
                    }
                    case "v": {
                        ProcessedVisit visit = (ProcessedVisit)this.processedVisitJdbcService.findById(Long.valueOf(partId)).orElseThrow(() -> new IllegalArgumentException("ProcessedVisit not found"));
                        MemoryVisit persistedMemoryVisit = this.memoryVisitJdbcService.save(user, MemoryVisit.create((ProcessedVisit)visit), block.getBlockId(), visit.getId());
                        partIds.add(persistedMemoryVisit.getId());
                        continue block17;
                    }
                }
                throw new IllegalArgumentException("Invalid part id [" + selectedPart + "] detected");
            }
            persistedVisits.forEach(mt -> this.memoryVisitJdbcService.deleteById(mt.getId()));
        } else {
            throw new IllegalArgumentException("Invalid block type [" + String.valueOf(block.getType()) + "] detected");
        }
        MemoryClusterBlock updated = block.withPartIds(partIds).withTitle(title);
        this.memoryService.updateClusterBlock(user, updated);
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("blocks", List.of((MemoryBlockPart)this.memoryService.getBlock(user, timezone, memoryId.longValue(), blockId.longValue()).orElseThrow(() -> new IllegalArgumentException("Block not found"))));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        return "memories/view :: view-block";
    }

    @PostMapping(value={"/cluster"})
    public String createClusterBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @RequestParam(required=false, defaultValue="-1") int position, @RequestParam(name="selectedParts") List<Long> selectedParts, @RequestParam BlockType type, @RequestParam(required=false) String title, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        MemoryClusterBlock clusterBlock = this.memoryService.createClusterBlock(user, memory, title, position, type, selectedParts);
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("blocks", List.of((MemoryBlockPart)this.memoryService.getBlock(user, timezone, memoryId.longValue(), clusterBlock.getBlockId().longValue()).orElseThrow(() -> new IllegalArgumentException("Block not found"))));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        return "memories/view :: view-block";
    }

    @PostMapping(value={"/reorder"})
    public String reorderBlocks(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @RequestParam List<Long> blockIds) {
        this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        this.memoryService.reorderBlocks(user, memoryId, blockIds);
        return "redirect:/memories/" + memoryId;
    }

    @PostMapping(value={"/text"})
    public String createTextBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @RequestParam(required=false, defaultValue="-1") int position, @RequestParam(required=false) String headline, @RequestParam(required=false) String content, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        MemoryBlock block = this.memoryService.addBlock(user, memoryId, position, BlockType.TEXT);
        this.memoryService.addTextBlock(block.getId(), headline, content);
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("blocks", List.of((MemoryBlockPart)this.memoryService.getBlock(user, timezone, memoryId.longValue(), block.getId().longValue()).orElseThrow(() -> new IllegalArgumentException("Block not found"))));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        return "memories/view :: view-block";
    }

    @PostMapping(value={"/{blockId}/text"})
    public String updateTextBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @PathVariable Long blockId, @RequestParam String headline, @RequestParam String content, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        MemoryBlockText textBlock = (MemoryBlockText)this.memoryService.getTextBlock(blockId).orElseThrow(() -> new IllegalArgumentException("Text block not found"));
        MemoryBlockText updated = textBlock.withHeadline(headline).withContent(content);
        this.memoryService.updateTextBlock(user, updated);
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("blocks", List.of(updated));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        return "memories/view :: view-block";
    }

    @PostMapping(value={"/image-gallery"})
    public String createImageGalleryBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @RequestParam(required=false, defaultValue="-1") int position, @RequestParam(required=false) List<String> uploadedUrls, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        MemoryBlock block = this.memoryService.addBlock(user, memoryId, position, BlockType.IMAGE_GALLERY);
        ArrayList<MemoryBlockImageGallery.GalleryImage> imageBlocks = new ArrayList<MemoryBlockImageGallery.GalleryImage>();
        if (uploadedUrls != null) {
            for (String url : uploadedUrls) {
                imageBlocks.add(new MemoryBlockImageGallery.GalleryImage(url, null, "upload", null));
            }
        }
        if (imageBlocks.isEmpty()) {
            throw new IllegalArgumentException("No images selected");
        }
        this.memoryService.addImageGalleryBlock(block.getId(), imageBlocks);
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("blocks", List.of((MemoryBlockPart)this.memoryService.getBlock(user, timezone, memoryId.longValue(), block.getId().longValue()).orElseThrow(() -> new IllegalArgumentException("Block not found"))));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        return "memories/view :: view-block";
    }

    @PostMapping(value={"/{blockId}/image-gallery"})
    public String updateImageGalleryBlock(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @PathVariable Long blockId, @RequestParam(required=false) List<String> uploadedUrls, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        MemoryBlockImageGallery imageBlock = this.memoryService.getImagesForBlock(blockId);
        ArrayList<MemoryBlockImageGallery.GalleryImage> imageBlocks = new ArrayList<MemoryBlockImageGallery.GalleryImage>();
        if (uploadedUrls != null) {
            for (String url : uploadedUrls) {
                imageBlocks.add(new MemoryBlockImageGallery.GalleryImage(url, null, "upload", null));
            }
        }
        if (imageBlocks.isEmpty()) {
            throw new IllegalArgumentException("No images selected");
        }
        this.memoryService.updateImageBlock(user, imageBlock.withImages(imageBlocks));
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("blocks", List.of((MemoryBlockPart)this.memoryService.getBlock(user, timezone, memoryId.longValue(), blockId.longValue()).orElseThrow(() -> new IllegalArgumentException("Block not found"))));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        return "memories/view :: view-block";
    }

    @PostMapping(value={"/upload-image"})
    public String uploadImage(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @RequestParam(value="files") List<MultipartFile> files, Model model) {
        this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        ArrayList<CallSite> urls = new ArrayList<CallSite>();
        for (MultipartFile file : files) {
            if (file.isEmpty()) continue;
            try {
                String originalFilename = file.getOriginalFilename();
                String extension = "";
                if (originalFilename != null && originalFilename.contains(".")) {
                    extension = originalFilename.substring(originalFilename.lastIndexOf("."));
                }
                String filename = String.valueOf(UUID.randomUUID()) + extension;
                this.storageService.store("memories/" + memoryId + "/" + filename, file.getInputStream(), file.getSize(), file.getContentType());
                String fileUrl = "/api/v1/photos/reitti/memories/" + memoryId + "/" + filename;
                urls.add((CallSite)((Object)fileUrl));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to upload file", e);
            }
        }
        model.addAttribute("urls", urls);
        return "memories/fragments :: uploaded-photos";
    }

    @PostMapping(value={"/fetch-immich-photo"})
    public String fetchImmichPhoto(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @RequestParam String assetId, Model model) {
        String imageUrl;
        this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        if (this.storageService.exists("memories/" + memoryId + "/" + assetId)) {
            imageUrl = "/api/v1/photos/reitti/memories/" + memoryId + "/" + assetId;
        } else {
            String filename = this.immichIntegrationService.downloadImage(user, assetId, "memories/" + memoryId);
            imageUrl = "/api/v1/photos/reitti/memories/" + memoryId + "/" + filename;
        }
        model.addAttribute("urls", List.of(imageUrl));
        return "memories/fragments :: uploaded-photos";
    }

    @GetMapping(value={"/immich-photos"})
    public String getImmichPhotos(@AuthenticationPrincipal User user, @PathVariable Long memoryId, @RequestParam(defaultValue="0") int page, @RequestParam(required=false, defaultValue="UTC") String timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, memoryId).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        ZoneId zoneId = ZoneId.of(timezone);
        LocalDate startDate = memory.getStartDate().atZone(zoneId).toLocalDate();
        LocalDate endDate = memory.getEndDate().atZone(zoneId).toLocalDate();
        List allPhotos = this.immichIntegrationService.searchPhotosForRange(user, startDate, endDate, timezone);
        int pageSize = 12;
        int totalPages = (int)Math.ceil((double)allPhotos.size() / (double)pageSize);
        int startIndex = page * pageSize;
        int endIndex = Math.min(startIndex + pageSize, allPhotos.size());
        List pagePhotos = allPhotos.subList(startIndex, endIndex);
        model.addAttribute("photos", pagePhotos);
        model.addAttribute("currentPage", (Object)page);
        model.addAttribute("totalPages", (Object)totalPages);
        model.addAttribute("memoryId", (Object)memoryId);
        return "memories/fragments :: immich-photos-grid";
    }

    private boolean isOwner(Memory memory, User user) {
        if (user.getAuthorities().contains(Role.ADMIN.asAuthority()) || user.getAuthorities().contains(Role.USER.asAuthority())) {
            return this.memoryService.getOwnerId(memory) == user.getId().longValue();
        }
        return false;
    }

    private boolean canEdit(Memory memory, User user) {
        if (user.getAuthorities().contains(Role.ADMIN.asAuthority()) || user.getAuthorities().contains(Role.USER.asAuthority())) {
            return this.memoryService.getOwnerId(memory) == user.getId().longValue();
        }
        TokenUser tokenUser = (TokenUser)user;
        return user.getAuthorities().contains(MagicLinkAccessLevel.MEMORY_EDIT_ACCESS.asAuthority()) && tokenUser.grantsAccessTo(MagicLinkResourceType.MEMORY, memory.getId());
    }
}

