/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.controller.error.ForbiddenException;
import com.dedicatedcode.reitti.controller.error.PageNotFoundException;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.integration.ImmichIntegration;
import com.dedicatedcode.reitti.model.memory.HeaderType;
import com.dedicatedcode.reitti.model.memory.Memory;
import com.dedicatedcode.reitti.model.memory.MemoryDTO;
import com.dedicatedcode.reitti.model.memory.MemoryOverviewDTO;
import com.dedicatedcode.reitti.model.security.MagicLinkAccessLevel;
import com.dedicatedcode.reitti.model.security.MagicLinkResourceType;
import com.dedicatedcode.reitti.model.security.TokenUser;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.MagicLinkTokenService;
import com.dedicatedcode.reitti.service.MemoryService;
import com.dedicatedcode.reitti.service.RequestHelper;
import com.dedicatedcode.reitti.service.integration.ImmichIntegrationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/memories"})
public class MemoryController {
    private static final Logger log = LoggerFactory.getLogger(MemoryController.class);
    private final MemoryService memoryService;
    private final TripJdbcService tripJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final ImmichIntegrationService immichIntegrationService;
    private final MagicLinkTokenService magicLinkTokenService;
    private final I18nService i18n;

    public MemoryController(MemoryService memoryService, TripJdbcService tripJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, ImmichIntegrationService immichIntegrationService, MagicLinkTokenService magicLinkTokenService, I18nService i18n) {
        this.memoryService = memoryService;
        this.tripJdbcService = tripJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.immichIntegrationService = immichIntegrationService;
        this.magicLinkTokenService = magicLinkTokenService;
        this.i18n = i18n;
    }

    @GetMapping
    public String get() {
        return "memories/list";
    }

    @GetMapping(value={"/years-navigation"})
    public String listMemories(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("years", (Object)this.memoryService.getAvailableYears(user));
        return "memories/fragments :: years-navigation";
    }

    @GetMapping(value={"/all"})
    public String getAll(@AuthenticationPrincipal User user, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, @RequestParam(defaultValue="startDate") String sortBy, @RequestParam(defaultValue="desc") String sortOrder, Model model) {
        model.addAttribute("memories", this.memoryService.getMemoriesForUser(user, sortBy, sortOrder).stream().map(m -> {
            String startDateLocal = m.getStartDate().atZone(timezone).toLocalDate().toString();
            String endDateLocal = m.getEndDate().atZone(timezone).toLocalDate().toString();
            String rawLocationUrl = "/api/v1/raw-location-points?startDate=" + startDateLocal + "&endDate=" + endDateLocal;
            return new MemoryOverviewDTO(new MemoryDTO(m, timezone), rawLocationUrl);
        }).toList());
        model.addAttribute("year", (Object)"all");
        model.addAttribute("sortBy", (Object)sortBy);
        model.addAttribute("sortOrder", (Object)sortOrder);
        return "memories/fragments :: memories-list";
    }

    @GetMapping(value={"/year/{year}"})
    public String getYear(@AuthenticationPrincipal User user, @PathVariable int year, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, @RequestParam(defaultValue="startDate") String sortBy, @RequestParam(defaultValue="desc") String sortOrder, Model model) {
        model.addAttribute("memories", this.memoryService.getMemoriesForUserAndYear(user, year, sortBy, sortOrder).stream().map(m -> {
            String startDateLocal = m.getStartDate().atZone(timezone).toLocalDate().toString();
            String endDateLocal = m.getEndDate().atZone(timezone).toLocalDate().toString();
            String rawLocationUrl = "/api/v1/raw-location-points?startDate=" + startDateLocal + "&endDate=" + endDateLocal;
            return new MemoryOverviewDTO(new MemoryDTO(m, timezone), rawLocationUrl);
        }).toList());
        model.addAttribute("year", (Object)year);
        model.addAttribute("sortBy", (Object)sortBy);
        model.addAttribute("sortOrder", (Object)sortOrder);
        return "memories/fragments :: memories-list";
    }

    @GetMapping(value={"/{id}"})
    public String viewMemory(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new PageNotFoundException("Memory not found"));
        model.addAttribute("memory", (Object)new MemoryDTO(memory, timezone));
        List blocks = this.memoryService.getBlockPartsForMemory(user, id, timezone);
        model.addAttribute("blocks", (Object)blocks);
        String startDateLocal = memory.getStartDate().atZone(timezone).toLocalDate().toString();
        String endDateLocal = memory.getEndDate().atZone(timezone).toLocalDate().toString();
        String rawLocationUrl = "/api/v1/raw-location-points?startDate=" + startDateLocal + "&endDate=" + endDateLocal;
        model.addAttribute("rawLocationUrl", (Object)rawLocationUrl);
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        return "memories/view";
    }

    @GetMapping(value={"/new"})
    public String newMemoryForm(@AuthenticationPrincipal User user, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam(required=false) String year, Model model) {
        model.addAttribute("startDate", (Object)startDate);
        model.addAttribute("endDate", (Object)endDate);
        model.addAttribute("year", (Object)year);
        return "memories/new :: new-memory";
    }

    @PostMapping
    public String createMemory(@AuthenticationPrincipal User user, @RequestParam String title, @RequestParam(required=false) String description, @RequestParam LocalDate startDate, @RequestParam LocalDate endDate, @RequestParam(required=false) String year, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, @RequestParam(required=false, defaultValue="MAP") HeaderType headerType, @RequestParam(required=false) String headerImageUrl, Model model, HttpServletResponse response) {
        if (title == null || title.trim().isEmpty()) {
            model.addAttribute("error", (Object)this.i18n.translate("memory.validation.title.required"));
            model.addAttribute("title", (Object)title);
            model.addAttribute("description", (Object)description);
            model.addAttribute("startDate", (Object)startDate);
            model.addAttribute("endDate", (Object)endDate);
            return "memories/new :: new-memory";
        }
        try {
            Instant start = ZonedDateTime.of(startDate.atStartOfDay(), timezone).toInstant();
            Instant end = ZonedDateTime.of(endDate.plusDays(1L).atStartOfDay().minus(1L, ChronoUnit.MILLIS), timezone).toInstant();
            Instant today = Instant.now();
            if (start.isAfter(today) || end.isAfter(today)) {
                model.addAttribute("error", (Object)this.i18n.translate("memory.validation.date.future"));
                model.addAttribute("title", (Object)title);
                model.addAttribute("description", (Object)description);
                model.addAttribute("startDate", (Object)startDate);
                model.addAttribute("endDate", (Object)endDate);
                model.addAttribute("year", (Object)year);
                return "memories/new :: new-memory";
            }
            if (end.isBefore(start)) {
                model.addAttribute("error", (Object)this.i18n.translate("memory.validation.end.date.before.start"));
                model.addAttribute("title", (Object)title);
                model.addAttribute("description", (Object)description);
                model.addAttribute("startDate", (Object)startDate);
                model.addAttribute("endDate", (Object)endDate);
                model.addAttribute("year", (Object)year);
                return "memories/new :: new-memory";
            }
            Memory memory = new Memory(title.trim(), description != null ? description.trim() : null, start, end, headerType, headerImageUrl);
            Memory created = this.memoryService.createMemory(user, memory);
            this.memoryService.recalculateMemory(user, created.getId(), timezone);
            response.setHeader("HX-Redirect", "/memories/" + created.getId() + "?timezone=" + timezone.getId());
            return "memories/fragments :: empty";
        }
        catch (Exception e) {
            log.error("Error creating memory", (Throwable)e);
            model.addAttribute("error", (Object)this.i18n.translate("memory.creation.error", new Object[]{e.getMessage()}));
            model.addAttribute("title", (Object)title);
            model.addAttribute("description", (Object)description);
            model.addAttribute("startDate", (Object)startDate);
            model.addAttribute("endDate", (Object)endDate);
            model.addAttribute("year", (Object)year);
            return "memories/new :: new-memory";
        }
    }

    @GetMapping(value={"/{id}/edit"})
    public String editMemoryForm(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        if (!this.canEdit(memory, user)) {
            throw new ForbiddenException("You are not allowed to edit this memory");
        }
        model.addAttribute("memory", (Object)new MemoryDTO(memory, timezone));
        model.addAttribute("startDate", (Object)memory.getStartDate().atZone(timezone).toLocalDate());
        model.addAttribute("endDate", (Object)memory.getEndDate().atZone(timezone).toLocalDate());
        return "memories/edit :: edit-memory";
    }

    @PostMapping(value={"/{id}"})
    public String updateMemory(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam String title, @RequestParam(required=false) String description, @RequestParam LocalDate startDate, @RequestParam LocalDate endDate, @RequestParam Long version, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, @RequestParam(required=false, defaultValue="MAP") HeaderType headerType, @RequestParam(required=false) String headerImageUrl, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        if (!this.canEdit(memory, user)) {
            throw new ForbiddenException("You are not allowed to edit this memory");
        }
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        if (title == null || title.trim().isEmpty()) {
            model.addAttribute("error", (Object)this.i18n.translate("memory.validation.title.required"));
            model.addAttribute("memory", (Object)new MemoryDTO(memory, timezone));
            model.addAttribute("cancelEndpoint", (Object)("/memories/" + id));
            model.addAttribute("cancelTarget", (Object)".memory-header");
            model.addAttribute("formTarget", (Object)".memory-header");
            return "memories/edit :: edit-memory";
        }
        try {
            Instant start = ZonedDateTime.of(startDate.atStartOfDay(), timezone).toInstant();
            Instant end = ZonedDateTime.of(endDate.plusDays(1L).atStartOfDay().minusSeconds(1L), timezone).toInstant();
            Instant today = Instant.now();
            if (start.isAfter(today) || end.isAfter(today)) {
                model.addAttribute("error", (Object)this.i18n.translate("memory.validation.date.future"));
                model.addAttribute("memory", (Object)new MemoryDTO(memory, timezone));
                model.addAttribute("cancelEndpoint", (Object)("/memories/" + id));
                model.addAttribute("cancelTarget", (Object)".memory-header");
                model.addAttribute("formTarget", (Object)".memory-header");
                return "memories/edit :: edit-memory";
            }
            if (end.isBefore(start)) {
                model.addAttribute("error", (Object)this.i18n.translate("memory.validation.end.date.before.start"));
                model.addAttribute("memory", (Object)new MemoryDTO(memory, timezone));
                model.addAttribute("cancelEndpoint", (Object)("/memories/" + id));
                model.addAttribute("cancelTarget", (Object)".memory-header");
                model.addAttribute("formTarget", (Object)".memory-header");
                return "memories/edit :: edit-memory";
            }
            Memory updated = memory.withTitle(title.trim()).withDescription(description != null ? description.trim() : null).withStartDate(start).withEndDate(end).withHeaderType(headerType).withHeaderImageUrl(headerImageUrl).withVersion(version);
            Memory savedMemory = this.memoryService.updateMemory(user, updated);
            model.addAttribute("memory", (Object)new MemoryDTO(savedMemory, timezone));
            return "memories/view :: memory-header";
        }
        catch (Exception e) {
            model.addAttribute("error", (Object)this.i18n.translate("memory.validation.start.date.required"));
            model.addAttribute("memory", (Object)new MemoryDTO(memory, timezone));
            model.addAttribute("cancelEndpoint", (Object)("/memories/" + id));
            model.addAttribute("cancelTarget", (Object)".memory-header");
            model.addAttribute("formTarget", (Object)".memory-header");
            return "memories/edit :: edit-memory";
        }
    }

    @DeleteMapping(value={"/{id}"})
    public String deleteMemory(@AuthenticationPrincipal User user, @PathVariable Long id, HttpServletResponse response) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        if (!this.isOwner(memory, user)) {
            throw new ForbiddenException("You are not allowed to delete this memory");
        }
        this.memoryService.deleteMemory(user, id);
        response.setHeader("HX-Redirect", "/memories");
        return "";
    }

    @GetMapping(value={"/{id}/blocks/select-type"})
    public String selectBlockType(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam(defaultValue="-1") int position, Model model) {
        model.addAttribute("memoryId", (Object)id);
        model.addAttribute("position", (Object)position);
        return "memories/fragments :: block-type-selection";
    }

    @GetMapping(value={"/fragments/empty"})
    public String emptyFragment() {
        return "memories/fragments :: empty";
    }

    @PostMapping(value={"/{id}/recalculate"})
    @ResponseBody
    public String recalculateMemory(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, HttpServletResponse httpResponse) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        if (!this.isOwner(memory, user)) {
            throw new ForbiddenException("You are not allowed execute this action. Only the owner of the memory can do this.");
        }
        this.memoryService.recalculateMemory(user, id, timezone);
        httpResponse.setHeader("HX-Redirect", "/memories/" + id + "?timezone=" + timezone.getId());
        return "Ok";
    }

    @GetMapping(value={"/{id}/blocks/new"})
    public String newBlockForm(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam String type, @RequestParam(defaultValue="-1") int position, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        model.addAttribute("memoryId", (Object)id);
        model.addAttribute("position", (Object)position);
        model.addAttribute("blockType", (Object)type);
        model.addAttribute("isOwner", (Object)this.isOwner(memory, user));
        model.addAttribute("canEdit", (Object)this.canEdit(memory, user));
        switch (type) {
            case "TEXT": {
                return "memories/fragments :: text-block-form";
            }
            case "TRIP_CLUSTER": {
                model.addAttribute("availableTrips", (Object)this.tripJdbcService.findByUserAndTimeOverlap(user, memory.getStartDate(), memory.getEndDate()));
                return "memories/fragments :: trip-block-form";
            }
            case "VISIT_CLUSTER": {
                model.addAttribute("availableVisits", (Object)this.processedVisitJdbcService.findByUserAndTimeOverlap(user, memory.getStartDate(), memory.getEndDate()));
                return "memories/fragments :: visit-block-form";
            }
            case "IMAGE_GALLERY": {
                boolean immichEnabled = this.immichIntegrationService.getIntegrationForUser(user).map(ImmichIntegration::isEnabled).orElse(false);
                model.addAttribute("immichEnabled", (Object)immichEnabled);
                return "memories/fragments :: image-gallery-block-form";
            }
        }
        throw new IllegalArgumentException("Unknown block type: " + type);
    }

    @GetMapping(value={"/{id}/share"})
    public String shareMemoryOverlay(@AuthenticationPrincipal User user, @PathVariable Long id, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        model.addAttribute("memory", (Object)memory);
        return "memories/fragments :: share-overlay";
    }

    @GetMapping(value={"/{id}/share/form"})
    public String shareMemoryForm(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam MagicLinkAccessLevel accessLevel, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("accessLevel", (Object)accessLevel);
        return "memories/fragments :: share-form";
    }

    @PostMapping(value={"/{id}/share"})
    public String createShareLink(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam MagicLinkAccessLevel accessLevel, @RequestParam(defaultValue="30") int validDays, HttpServletRequest request, Model model) {
        Memory memory = (Memory)this.memoryService.getMemoryById(user, id).orElseThrow(() -> new IllegalArgumentException("Memory not found"));
        String token = this.magicLinkTokenService.createMemoryShareToken(user, id, accessLevel, validDays);
        String baseUrl = RequestHelper.getBaseUrl((HttpServletRequest)request);
        String shareUrl = baseUrl + "/memories/" + id + "?mt=" + token;
        model.addAttribute("shareUrl", (Object)shareUrl);
        model.addAttribute("memory", (Object)memory);
        model.addAttribute("accessLevel", (Object)accessLevel);
        return "memories/fragments :: share-result";
    }

    private boolean isOwner(Memory memory, User user) {
        if (user.getAuthorities().contains(Role.ADMIN.asAuthority()) || user.getAuthorities().contains(Role.USER.asAuthority())) {
            return this.memoryService.getOwnerId(memory) == user.getId().longValue();
        }
        return false;
    }

    private boolean canEdit(Memory memory, User user) {
        if (user.getAuthorities().contains(Role.ADMIN.asAuthority()) || user.getAuthorities().contains(Role.USER.asAuthority())) {
            return this.memoryService.getOwnerId(memory) == user.getId().longValue();
        }
        TokenUser tokenUser = (TokenUser)user;
        return user.getAuthorities().contains(MagicLinkAccessLevel.MEMORY_EDIT_ACCESS.asAuthority()) && tokenUser.grantsAccessTo(MagicLinkResourceType.MEMORY, memory.getId());
    }
}

