/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.integration.ReittiIntegrationService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reitti-integration"})
public class ReittiIntegrationController {
    private final ReittiIntegrationService reittiIntegrationService;

    public ReittiIntegrationController(ReittiIntegrationService reittiIntegrationService) {
        this.reittiIntegrationService = reittiIntegrationService;
    }

    @GetMapping(value={"/avatar/{integrationId}"})
    public ResponseEntity<byte[]> getAvatar(@AuthenticationPrincipal User user, @PathVariable Long integrationId) {
        return this.reittiIntegrationService.getAvatar(user, integrationId).map(avatarData -> {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)avatarData.mimeType()));
            headers.setContentLength((long)avatarData.imageData().length);
            headers.setCacheControl(CacheControl.maxAge((long)30L, (TimeUnit)TimeUnit.DAYS));
            return new ResponseEntity((Object)avatarData.imageData(), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }).orElse(ResponseEntity.notFound().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.HOURS)).build());
    }

    @GetMapping(value={"/raw-location-points/{integrationId}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> getRawLocationPoints(@AuthenticationPrincipal User user, @PathVariable Long integrationId, @RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false, defaultValue="UTC") String timezone, @RequestParam(required=false) Integer zoom) {
        return ResponseEntity.ok(Map.of("segments", this.reittiIntegrationService.getRawLocationData(user, integrationId, startDate, endDate, zoom, timezone)));
    }

    @GetMapping(value={"/visits/{integrationId}"}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<?> getVisits(@AuthenticationPrincipal User user, @PathVariable Long integrationId, @RequestParam String startDate, @RequestParam String endDate, @RequestParam(required=false, defaultValue="UTC") String timezone, @RequestParam(required=false) Integer zoom) {
        return ResponseEntity.ok((Object)this.reittiIntegrationService.getVisits(user, integrationId, startDate, endDate, zoom, timezone));
    }
}

