/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import java.util.Optional;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class SetupController {
    private final UserJdbcService userService;
    private final PasswordEncoder passwordEncoder;

    public SetupController(UserJdbcService userService, PasswordEncoder passwordEncoder) {
        this.userService = userService;
        this.passwordEncoder = passwordEncoder;
    }

    @GetMapping(value={"/setup"})
    public String setupPage(Model model) {
        User adminUser = this.getAdminUserWithEmptyPassword();
        if (adminUser == null) {
            return "redirect:/login";
        }
        model.addAttribute("user", (Object)adminUser);
        return "setup";
    }

    @PostMapping(value={"/setup"})
    public String updateAdminPassword(@RequestParam String username, @RequestParam String password, @RequestParam String displayName, RedirectAttributes redirectAttributes) {
        Optional adminUser = this.userService.findByUsername(username);
        if (adminUser.isEmpty()) {
            return "redirect:/login";
        }
        if (!((User)adminUser.get()).getUsername().equals(username)) {
            throw new IllegalArgumentException("Wrong username or password");
        }
        try {
            User updatedAdmin = new User(((User)adminUser.get()).getId(), ((User)adminUser.get()).getUsername(), this.passwordEncoder.encode((CharSequence)password), displayName, ((User)adminUser.get()).getProfileUrl(), ((User)adminUser.get()).getExternalId(), Role.ADMIN, ((User)adminUser.get()).getVersion());
            this.userService.updateUser(updatedAdmin);
            redirectAttributes.addFlashAttribute("message", (Object)"Admin password set successfully!");
            return "redirect:/login";
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("error", (Object)("Failed to set admin password: " + e.getMessage()));
            return "redirect:/setup";
        }
    }

    private User getAdminUserWithEmptyPassword() {
        return this.userService.getAllUsers().stream().filter(user -> user.getRole() == Role.ADMIN).filter(admin -> {
            String password = admin.getPassword();
            return password == null || password.isEmpty();
        }).findFirst().orElse(null);
    }
}

