/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.StatisticsService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/statistics"})
public class StatisticsController {
    private final StatisticsService statisticsService;
    private final ObjectMapper objectMapper;
    private final I18nService i18nService;

    public StatisticsController(StatisticsService statisticsService, ObjectMapper objectMapper, I18nService i18nService) {
        this.statisticsService = statisticsService;
        this.objectMapper = objectMapper;
        this.i18nService = i18nService;
    }

    @GetMapping
    public String statistics(Model model) {
        return "statistics";
    }

    @GetMapping(value={"/years-navigation"})
    public String yearsNavigation(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("years", (Object)this.statisticsService.getAvailableYears(user));
        return "fragments/statistics :: years-navigation";
    }

    @GetMapping(value={"/overall"})
    public String overallStatistics(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("statisticsType", (Object)"overall");
        model.addAttribute("title", (Object)this.i18nService.translate("statistics.title.overall"));
        model.addAttribute("topVisits", (Object)this.statisticsService.getOverallTopVisits(user));
        try {
            String transportStatsJson = this.objectMapper.writeValueAsString((Object)this.statisticsService.getOverallTransportStatistics(user));
            model.addAttribute("transportStats", (Object)transportStatsJson);
        }
        catch (JsonProcessingException e) {
            model.addAttribute("transportStats", (Object)"[]");
        }
        return "fragments/statistics :: statistics-content";
    }

    @GetMapping(value={"/{year}"})
    public String yearStatistics(@PathVariable Integer year, @AuthenticationPrincipal User user, Model model) {
        model.addAttribute("statisticsType", (Object)"year");
        model.addAttribute("year", (Object)year);
        model.addAttribute("title", (Object)this.i18nService.translate("statistics.title.year", new Object[]{"" + year}));
        model.addAttribute("topVisits", (Object)this.statisticsService.getYearTopVisits(user, year.intValue()));
        try {
            String transportStatsJson = this.objectMapper.writeValueAsString((Object)this.statisticsService.getYearTransportStatistics(user, year.intValue()));
            model.addAttribute("transportStats", (Object)transportStatsJson);
            String breakdownTransportJson = this.objectMapper.writeValueAsString((Object)this.statisticsService.getMonthlyTransportBreakdown(user, year.intValue()));
            model.addAttribute("breakdownTransportData", (Object)breakdownTransportJson);
        }
        catch (JsonProcessingException e) {
            model.addAttribute("transportStats", (Object)"[]");
            model.addAttribute("breakdownTransportData", (Object)"[]");
        }
        List<Integer> months = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
        model.addAttribute("months", months);
        return "fragments/statistics :: statistics-content";
    }

    @GetMapping(value={"/{year}/{month}"})
    public String monthStatistics(@PathVariable Integer year, @PathVariable Integer month, @AuthenticationPrincipal User user, Model model) {
        model.addAttribute("statisticsType", (Object)"month");
        model.addAttribute("year", (Object)year);
        model.addAttribute("month", (Object)month);
        model.addAttribute("title", (Object)this.i18nService.translate("statistics.title.month-year", new Object[]{this.i18nService.translate("month." + month), "" + year}));
        model.addAttribute("topVisits", (Object)this.statisticsService.getMonthTopVisits(user, year.intValue(), month.intValue()));
        try {
            List monthTransportStatistics = this.statisticsService.getMonthTransportStatistics(user, year.intValue(), month.intValue());
            List dailyTransportBreakdown = this.statisticsService.getDailyTransportBreakdown(user, year.intValue(), month.intValue());
            model.addAttribute("dataAvailable", (Object)(!monthTransportStatistics.isEmpty() || dailyTransportBreakdown.stream().noneMatch(dt -> dt.getTransportStats().isEmpty()) ? 1 : 0));
            model.addAttribute("transportStats", (Object)this.objectMapper.writeValueAsString((Object)monthTransportStatistics));
            model.addAttribute("breakdownTransportData", (Object)this.objectMapper.writeValueAsString((Object)dailyTransportBreakdown));
        }
        catch (JsonProcessingException e) {
            model.addAttribute("transportStats", (Object)"[]");
            model.addAttribute("breakdownTransportData", (Object)"[]");
        }
        return "fragments/statistics :: month-content";
    }
}

