/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.dto.TimelineData;
import com.dedicatedcode.reitti.dto.UserTimelineData;
import com.dedicatedcode.reitti.model.geo.TransportMode;
import com.dedicatedcode.reitti.model.geo.Trip;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.repository.UserSharingJdbcService;
import com.dedicatedcode.reitti.service.AvatarService;
import com.dedicatedcode.reitti.service.TimelineService;
import com.dedicatedcode.reitti.service.integration.ReittiIntegrationService;
import com.dedicatedcode.reitti.service.processing.TransportModeService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/timeline"})
public class TimelineController {
    private final UserJdbcService userJdbcService;
    private final AvatarService avatarService;
    private final ReittiIntegrationService reittiIntegrationService;
    private final UserSharingJdbcService userSharingJdbcService;
    private final TimelineService timelineService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final TransportModeService transportModeService;
    private final TripJdbcService tripJdbcService;

    @Autowired
    public TimelineController(UserJdbcService userJdbcService, AvatarService avatarService, ReittiIntegrationService reittiIntegrationService, UserSharingJdbcService userSharingJdbcService, TimelineService timelineService, UserSettingsJdbcService userSettingsJdbcService, TransportModeService transportModeService, TripJdbcService tripJdbcService) {
        this.userJdbcService = userJdbcService;
        this.avatarService = avatarService;
        this.reittiIntegrationService = reittiIntegrationService;
        this.userSharingJdbcService = userSharingJdbcService;
        this.timelineService = timelineService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.transportModeService = transportModeService;
        this.tripJdbcService = tripJdbcService;
    }

    @GetMapping(value={"/content/range"})
    public String getTimelineContentRange(@RequestParam LocalDate startDate, @RequestParam LocalDate endDate, @RequestParam(required=false, defaultValue="UTC") String timezone, Authentication principal, Model model) {
        List<String> authorities = principal.getAuthorities().stream().map(GrantedAuthority::getAuthority).toList();
        ZoneId userTimezone = ZoneId.of(timezone);
        LocalDate now = LocalDate.now(userTimezone);
        if (!(startDate.isEqual(now) && endDate.isEqual(now) || authorities.contains("ROLE_USER") || authorities.contains("ROLE_ADMIN") || authorities.contains("ROLE_MAGIC_LINK_FULL_ACCESS"))) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        User user = (User)this.userJdbcService.findByUsername(principal.getName()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "User not found"));
        UserSettings userSettings = this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId());
        Instant startOfRange = startDate.atStartOfDay(userTimezone).toInstant();
        Instant endOfRange = endDate.plusDays(1L).atStartOfDay(userTimezone).toInstant().minusMillis(1L);
        ArrayList<UserTimelineData> allUsersData = new ArrayList<UserTimelineData>();
        List currentUserEntries = authorities.contains("ROLE_USER") || authorities.contains("ROLE_ADMIN") || authorities.contains("ROLE_MAGIC_LINK_FULL_ACCESS") ? this.timelineService.buildTimelineEntries(user, userTimezone, startDate, startOfRange, endOfRange) : Collections.emptyList();
        String currentUserRawLocationPointsUrl = String.format("/api/v1/raw-location-points/%d?startDate=%s&endDate=%s&timezone=%s", user.getId(), startDate, endDate, timezone);
        String currentUserProcessedVisitsUrl = String.format("/api/v1/visits/%d?startDate=%s&endDate=%s&timezone=%s", user.getId(), startDate, endDate, timezone);
        String currentUserAvatarUrl = this.avatarService.getInfo(user.getId()).map(avatarInfo -> String.format("/avatars/%d?ts=%s", user.getId(), avatarInfo.updatedAt())).orElse(String.format("/avatars/%d", user.getId()));
        String currentUserInitials = this.avatarService.generateInitials(user.getDisplayName());
        allUsersData.add(new UserTimelineData("" + user.getId(), user.getDisplayName(), currentUserInitials, currentUserAvatarUrl, userSettings.getColor(), currentUserEntries, currentUserRawLocationPointsUrl, currentUserProcessedVisitsUrl));
        if (authorities.contains("ROLE_USER") || authorities.contains("ROLE_ADMIN")) {
            allUsersData.addAll(this.reittiIntegrationService.getTimelineDataRange(user, startDate, endDate, userTimezone));
            allUsersData.addAll(this.handleSharedUserDataRange(user, startDate, endDate, userTimezone));
        }
        TimelineData timelineData = new TimelineData(allUsersData.stream().filter(Objects::nonNull).toList());
        model.addAttribute("timelineData", (Object)timelineData);
        model.addAttribute("startDate", (Object)startDate);
        model.addAttribute("endDate", (Object)endDate);
        model.addAttribute("timezone", (Object)timezone);
        model.addAttribute("isRange", (Object)true);
        model.addAttribute("timeDisplayMode", (Object)this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId()).getTimeDisplayMode());
        return "fragments/timeline :: timeline-content";
    }

    @GetMapping(value={"/trips/edit-form/{id}"})
    public String getTripEditForm(@PathVariable Long id, Model model) {
        Trip trip = (Trip)this.tripJdbcService.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        model.addAttribute("tripId", (Object)id);
        model.addAttribute("transportMode", (Object)trip.getTransportModeInferred());
        model.addAttribute("availableTransportModes", Arrays.stream(TransportMode.values()).filter(t -> t != TransportMode.UNKNOWN).toList());
        return "fragments/trip-edit :: edit-form";
    }

    @PutMapping(value={"/trips/{id}/transport-mode"})
    public String updateTripTransportMode(@PathVariable Long id, @RequestParam String transportMode, Authentication principal, Model model) {
        User user = (User)this.userJdbcService.findByUsername(principal.getName()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "User not found"));
        Trip trip = (Trip)this.tripJdbcService.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        try {
            TransportMode mode = TransportMode.valueOf((String)transportMode);
            this.tripJdbcService.update(trip.withTransportMode(mode));
            this.transportModeService.overrideTransportMode(user, mode, trip);
            model.addAttribute("tripId", (Object)id);
            model.addAttribute("transportMode", (Object)mode);
            return "fragments/trip-edit :: view-mode";
        }
        catch (IllegalArgumentException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid transport mode");
        }
    }

    @GetMapping(value={"/trips/view/{id}"})
    public String getTripView(@PathVariable Long id, Model model) {
        Trip trip = (Trip)this.tripJdbcService.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        model.addAttribute("tripId", (Object)id);
        model.addAttribute("transportMode", (Object)trip.getTransportModeInferred());
        model.addAttribute("availableTransportModes", Arrays.stream(TransportMode.values()).filter(t -> t != TransportMode.UNKNOWN).toList());
        return "fragments/trip-edit :: view-mode";
    }

    private List<UserTimelineData> handleSharedUserDataRange(User user, LocalDate startDate, LocalDate endDate, ZoneId userTimezone) {
        return this.userSharingJdbcService.findBySharedWithUser(user.getId()).stream().map(u -> {
            Optional sharedWithUserOpt = this.userJdbcService.findById(u.getSharingUserId());
            return sharedWithUserOpt.map(sharedWithUser -> {
                Instant startOfRange = startDate.atStartOfDay(userTimezone).toInstant();
                Instant endOfRange = endDate.plusDays(1L).atStartOfDay(userTimezone).toInstant().minusMillis(1L);
                List userTimelineEntries = this.timelineService.buildTimelineEntries(sharedWithUser, userTimezone, startDate, startOfRange, endOfRange);
                String currentUserRawLocationPointsUrl = String.format("/api/v1/raw-location-points/%d?startDate=%s&endDate=%s&timezone=%s", sharedWithUser.getId(), startDate, endDate, userTimezone.getId());
                String currentUserProcessedVisitsUrl = String.format("/api/v1/visits/%d?startDate=%s&endDate=%s&timezone=%s", sharedWithUser.getId(), startDate, endDate, userTimezone.getId());
                String currentUserAvatarUrl = this.avatarService.getInfo(sharedWithUser.getId()).map(avatarInfo -> String.format("/avatars/%d?ts=%s", sharedWithUser.getId(), avatarInfo.updatedAt())).orElse(String.format("/avatars/%d", sharedWithUser.getId()));
                String currentUserInitials = this.avatarService.generateInitials(sharedWithUser.getDisplayName());
                return new UserTimelineData("" + sharedWithUser.getId(), sharedWithUser.getDisplayName(), currentUserInitials, currentUserAvatarUrl, u.getColor(), userTimelineEntries, currentUserRawLocationPointsUrl, currentUserProcessedVisitsUrl);
            });
        }).filter(Optional::isPresent).map(Optional::get).sorted(Comparator.comparing(UserTimelineData::displayName)).toList();
    }
}

