/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
public class UserCssController {
    private final UserSettingsJdbcService userSettingsJdbcService;

    public UserCssController(UserSettingsJdbcService userSettingsJdbcService) {
        this.userSettingsJdbcService = userSettingsJdbcService;
    }

    @GetMapping(value={"/user-css/{userId}"})
    public ResponseEntity<String> getUserCss(@PathVariable Long userId) {
        UserSettings userSettings = this.userSettingsJdbcService.findByUserId(userId).orElse(null);
        if (userSettings == null || !StringUtils.hasText((String)userSettings.getCustomCss())) {
            return ResponseEntity.notFound().build();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.valueOf((String)"text/css"));
        headers.setCacheControl("public, max-age=3600");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)userSettings.getCustomCss());
    }
}

