/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.dto.UserSettingsDTO;
import com.dedicatedcode.reitti.model.Language;
import com.dedicatedcode.reitti.model.TimeDisplayMode;
import com.dedicatedcode.reitti.model.UnitSystem;
import com.dedicatedcode.reitti.model.geo.RawLocationPoint;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.service.TilesCustomizationProvider;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class UserSettingsControllerAdvice {
    public static final double DEFAULT_HOME_LATITUDE = 60.1699;
    public static final double DEFAULT_HOME_LONGITUDE = 24.9384;
    private final UserJdbcService userJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final TilesCustomizationProvider tilesCustomizationProvider;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;

    public UserSettingsControllerAdvice(UserJdbcService userJdbcService, UserSettingsJdbcService userSettingsJdbcService, TilesCustomizationProvider tilesCustomizationProvider, RawLocationPointJdbcService rawLocationPointJdbcService) {
        this.userJdbcService = userJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.tilesCustomizationProvider = tilesCustomizationProvider;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
    }

    @ModelAttribute(value="userSettings")
    public UserSettingsDTO getCurrentUserSettings() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated() || "anonymousUser".equals(authentication.getPrincipal())) {
            return new UserSettingsDTO(false, Language.EN, Instant.now(), UnitSystem.METRIC, Double.valueOf(60.1699), Double.valueOf(24.9384), this.tilesCustomizationProvider.getTilesConfiguration(), UserSettingsDTO.UIMode.FULL, UserSettingsDTO.PhotoMode.DISABLED, TimeDisplayMode.DEFAULT, null, null);
        }
        String username = authentication.getName();
        Optional userOptional = this.userJdbcService.findByUsername(username);
        UserSettingsDTO.UIMode uiMode = this.mapUserToUiMode(authentication);
        UserSettingsDTO.PhotoMode photoMode = this.mapUserToPhotoMode(authentication);
        if (userOptional.isPresent()) {
            User user = (User)userOptional.get();
            UserSettings dbSettings = this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId());
            Instant latestData = dbSettings.getLatestData();
            if (latestData == null) {
                latestData = this.rawLocationPointJdbcService.findLatest(user).map(RawLocationPoint::getTimestamp).orElse(null);
            }
            return new UserSettingsDTO(dbSettings.isPreferColoredMap(), dbSettings.getSelectedLanguage(), latestData, dbSettings.getUnitSystem(), dbSettings.getHomeLatitude(), dbSettings.getHomeLongitude(), this.tilesCustomizationProvider.getTilesConfiguration(), uiMode, photoMode, dbSettings.getTimeDisplayMode(), dbSettings.getTimeZoneOverride(), dbSettings.getCustomCss() != null ? "/user-css/" + user.getId() : null);
        }
        return new UserSettingsDTO(false, Language.EN, Instant.now(), UnitSystem.METRIC, Double.valueOf(60.1699), Double.valueOf(24.9384), this.tilesCustomizationProvider.getTilesConfiguration(), uiMode, photoMode, TimeDisplayMode.DEFAULT, null, null);
    }

    private UserSettingsDTO.UIMode mapUserToUiMode(Authentication authentication) {
        List<String> grantedRoles = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).toList();
        if (grantedRoles.contains("ROLE_ADMIN") || grantedRoles.contains("ROLE_USER") || grantedRoles.contains("ROLE_API_ACCESS")) {
            return UserSettingsDTO.UIMode.FULL;
        }
        if (grantedRoles.contains("ROLE_MAGIC_LINK_FULL_ACCESS")) {
            return UserSettingsDTO.UIMode.SHARED_FULL;
        }
        if (grantedRoles.contains("ROLE_MAGIC_LINK_ONLY_LIVE") || grantedRoles.contains("ROLE_MAGIC_LINK_ONLY_LIVE_WITH_PHOTOS") || grantedRoles.contains("ROLE_MAGIC_LINK_ONLY_LAST_LOCATION")) {
            return UserSettingsDTO.UIMode.SHARED_LIVE_MODE_ONLY;
        }
        if (grantedRoles.contains("ROLE_MAGIC_LINK_MEMORY_VIEW_ONLY") || grantedRoles.contains("ROLE_MAGIC_LINK_MEMORY_EDIT_ACCESS")) {
            return UserSettingsDTO.UIMode.VIEW_MEMORIES;
        }
        throw new IllegalStateException("Invalid user authentication mode detected [" + String.valueOf(grantedRoles) + "]");
    }

    private UserSettingsDTO.PhotoMode mapUserToPhotoMode(Authentication authentication) {
        List<String> grantedRoles = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).toList();
        if (grantedRoles.contains("ROLE_ADMIN") || grantedRoles.contains("ROLE_USER") || grantedRoles.contains("MAGIC_LINK_MEMORY_VIEW_ONLY") || grantedRoles.contains("MAGIC_LINK_MEMORY_EDIT_ACCESS") || grantedRoles.contains("ROLE_MAGIC_LINK_ONLY_LIVE_WITH_PHOTOS")) {
            return UserSettingsDTO.PhotoMode.ENABLED;
        }
        return UserSettingsDTO.PhotoMode.DISABLED;
    }
}

