/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller;

import com.dedicatedcode.reitti.controller.IllegalConfigurationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class WebViewController {
    private final boolean dataManagementEnabled;
    private final boolean oidcEnabled;
    private final boolean localLoginEnabled;

    public WebViewController(@Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled, @Value(value="${reitti.security.oidc.enabled:false}") boolean oidcEnabled, @Value(value="${reitti.security.local-login.disable:false}") boolean localLoginDisabled) {
        this.dataManagementEnabled = dataManagementEnabled;
        this.oidcEnabled = oidcEnabled;
        boolean bl = this.localLoginEnabled = !localLoginDisabled;
        if (!oidcEnabled && localLoginDisabled) {
            throw new IllegalConfigurationException("No login possible.", new String[]{"enable and configured OIDC support", "Enable local-login via 'reitti.security.local-login.disable:false' or 'DISABLE_LOCAL_LOGIN=false'"});
        }
    }

    @GetMapping(value={"/"})
    public String index(Authentication authentication, Model model) {
        if (authentication != null) {
            model.addAttribute("username", (Object)authentication.getName());
        }
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        return "index";
    }

    @GetMapping(value={"/login"})
    public String login(Model model) {
        model.addAttribute("oidcEnabled", (Object)this.oidcEnabled);
        model.addAttribute("localLoginEnabled", (Object)this.localLoginEnabled);
        return "login";
    }
}

