/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.api;

import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.GpxExportService;
import com.dedicatedcode.reitti.service.importer.GpxImporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RestController
@RequestMapping(value={"/api/v1/gpx"})
public class GpxApiController {
    private final GpxExportService gpxExportService;
    private final GpxImporter gpxImporter;

    public GpxApiController(GpxExportService gpxExportService, GpxImporter gpxImporter) {
        this.gpxExportService = gpxExportService;
        this.gpxImporter = gpxImporter;
    }

    @GetMapping(value={"/export"})
    public ResponseEntity<StreamingResponseBody> exportGpx(@AuthenticationPrincipal User user, @RequestParam LocalDate start, @RequestParam LocalDate end) {
        try {
            StreamingResponseBody stream = outputStream -> {
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    this.gpxExportService.generateGpxContentStreaming(user, ZonedDateTime.of(start.atStartOfDay(), ZoneId.of("UTC")).toInstant(), ZonedDateTime.of(end.atStartOfDay(), ZoneId.of("UTC")).toInstant(), (Writer)writer, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error generating GPX file", e);
                }
            };
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_XML).body((Object)stream);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body(outputStream -> {
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    writer.write("Error generating GPX file: " + e.getMessage());
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            });
        }
    }

    @PostMapping(value={"/import"})
    public ResponseEntity<Map<String, Object>> importGpx(@AuthenticationPrincipal User user, @RequestParam(value="file") MultipartFile file) {
        ResponseEntity responseEntity;
        block13: {
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (file.isEmpty() || file.getOriginalFilename() == null) {
                response.put("success", false);
                response.put("error", "File is empty");
                return ResponseEntity.badRequest().body(response);
            }
            if (!file.getOriginalFilename().endsWith(".gpx")) {
                response.put("success", false);
                response.put("error", "Only GPX files are supported");
                return ResponseEntity.badRequest().body(response);
            }
            InputStream inputStream = file.getInputStream();
            try {
                Map result = this.gpxImporter.importGpx(inputStream, user);
                if (((Boolean)result.get("success")).booleanValue()) {
                    response.put("success", true);
                    response.put("pointsScheduled", result.get("pointsReceived"));
                    response.put("message", "Successfully imported GPX file with " + String.valueOf(result.get("pointsReceived")) + " location points");
                } else {
                    response.put("success", false);
                    response.put("error", result.get("error"));
                }
                responseEntity = ResponseEntity.ok(response);
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    response.put("success", false);
                    response.put("error", "Error processing file: " + e.getMessage());
                    return ResponseEntity.status((int)500).body(response);
                }
                catch (Exception e) {
                    response.put("success", false);
                    response.put("error", "Unexpected error: " + e.getMessage());
                    return ResponseEntity.status((int)500).body(response);
                }
            }
            inputStream.close();
        }
        return responseEntity;
    }
}

