/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.api;

import com.dedicatedcode.reitti.dto.PhotoResponse;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.integration.ImmichIntegrationService;
import java.time.LocalDate;
import java.util.List;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/photos/immich"})
public class ImmichPhotoApiController {
    private final ImmichIntegrationService immichIntegrationService;

    public ImmichPhotoApiController(ImmichIntegrationService immichIntegrationService) {
        this.immichIntegrationService = immichIntegrationService;
    }

    @GetMapping(value={"/range"})
    public ResponseEntity<List<PhotoResponse>> getPhotosForRange(@RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate, @RequestParam(required=false, defaultValue="UTC") String timezone, @AuthenticationPrincipal User user) {
        List photos = this.immichIntegrationService.searchPhotosForRange(user, startDate, endDate, timezone);
        return ResponseEntity.ok((Object)photos);
    }

    @GetMapping(value={"/proxy/{assetId}/thumbnail"})
    public ResponseEntity<byte[]> getPhotoThumbnail(@PathVariable String assetId, @AuthenticationPrincipal User user) {
        return this.immichIntegrationService.proxyImageRequest(user, assetId, "thumbnail");
    }

    @GetMapping(value={"/proxy/{assetId}/original"})
    public ResponseEntity<byte[]> getPhotoOriginal(@PathVariable String assetId, @AuthenticationPrincipal User user) {
        return this.immichIntegrationService.proxyImageRequest(user, assetId, "fullsize");
    }
}

