/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.api;

import com.dedicatedcode.reitti.dto.TimelineEntry;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.TimelineService;
import com.dedicatedcode.reitti.service.VisitDetectionPreviewService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/preview"})
public class PreviewApiController {
    private final TimelineService timelineService;
    private final VisitDetectionPreviewService visitDetectionPreviewService;

    public PreviewApiController(TimelineService timelineService, VisitDetectionPreviewService visitDetectionPreviewService) {
        this.timelineService = timelineService;
        this.visitDetectionPreviewService = visitDetectionPreviewService;
    }

    @GetMapping(value={"/{previewId}/status"})
    public ResponseEntity<Map<String, Object>> getPreviewStatus(@PathVariable String previewId) {
        boolean ready = this.visitDetectionPreviewService.isPreviewReady(previewId);
        return ResponseEntity.ok(Map.of("ready", ready, "previewId", previewId));
    }

    @GetMapping(value={"/{previewId}/timeline"})
    public List<TimelineEntry> getPreviewTimeline(@AuthenticationPrincipal User user, @PathVariable String previewId, @RequestParam String date, @RequestParam(required=false, defaultValue="UTC") String timezone) {
        LocalDate selectedDate = LocalDate.parse(date);
        ZoneId userTimezone = ZoneId.of(timezone);
        Instant startOfDay = selectedDate.atStartOfDay(userTimezone).toInstant();
        Instant endOfDay = selectedDate.plusDays(1L).atStartOfDay(userTimezone).toInstant().minusMillis(1L);
        return this.timelineService.buildTimelineEntries(user, previewId, userTimezone, selectedDate, startOfDay, endOfDay);
    }
}

