/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.api;

import com.dedicatedcode.reitti.dto.PlaceInfo;
import com.dedicatedcode.reitti.dto.ProcessedVisitResponse;
import com.dedicatedcode.reitti.model.geo.ProcessedVisit;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.MagicLinkAccessLevel;
import com.dedicatedcode.reitti.model.security.TokenUser;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class ProcessedVisitApiController {
    private static final Logger logger = LoggerFactory.getLogger(ProcessedVisitApiController.class);
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final UserJdbcService userJdbcService;

    @Autowired
    public ProcessedVisitApiController(ProcessedVisitJdbcService processedVisitJdbcService, UserJdbcService userJdbcService) {
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.userJdbcService = userJdbcService;
    }

    @GetMapping(value={"/visits"})
    public ResponseEntity<?> getProcessedVisitsForCurrentUser(@AuthenticationPrincipal User user, @RequestParam(required=false) String date, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam(required=false, defaultValue="UTC") String timezone) {
        return this.getProcessedVisits(user, user.getId(), date, startDate, endDate, timezone);
    }

    @GetMapping(value={"/visits/{userId}"})
    public ResponseEntity<?> getProcessedVisits(@AuthenticationPrincipal User user, @PathVariable Long userId, @RequestParam(required=false) String date, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam(required=false, defaultValue="UTC") String timezone) {
        try {
            ZoneId userTimezone = ZoneId.of(timezone);
            Instant startOfRange = null;
            Instant endOfRange = null;
            if (startDate != null && endDate != null) {
                try {
                    LocalDateTime startTimestamp = LocalDateTime.parse(startDate);
                    LocalDateTime endTimestamp = LocalDateTime.parse(endDate);
                    startOfRange = startTimestamp.atZone(userTimezone).toInstant();
                    endOfRange = endTimestamp.atZone(userTimezone).toInstant();
                }
                catch (DateTimeParseException startTimestamp) {
                    // empty catch block
                }
                if (startOfRange == null && endOfRange == null) {
                    LocalDate selectedStartDate = LocalDate.parse(startDate);
                    LocalDate selectedEndDate = LocalDate.parse(endDate);
                    startOfRange = selectedStartDate.atStartOfDay(userTimezone).toInstant();
                    endOfRange = selectedEndDate.plusDays(1L).atStartOfDay(userTimezone).toInstant().minusMillis(1L);
                }
            } else if (date != null) {
                LocalDate selectedDate = LocalDate.parse(date);
                startOfRange = selectedDate.atStartOfDay(userTimezone).toInstant();
                endOfRange = selectedDate.plusDays(1L).atStartOfDay(userTimezone).toInstant().minusMillis(1L);
            } else {
                return ResponseEntity.badRequest().body(Map.of("error", "Either 'date' or both 'startDate' and 'endDate' must be provided"));
            }
            boolean hasAccess = true;
            if (user instanceof TokenUser) {
                if (!Objects.equals(user.getId(), userId)) {
                    throw new IllegalAccessException("User not allowed to fetch processed visits for other users");
                }
                hasAccess = user.getAuthorities().stream().anyMatch(a -> a.equals((Object)MagicLinkAccessLevel.FULL_ACCESS.asAuthority()) || a.equals((Object)MagicLinkAccessLevel.ONLY_LIVE.asAuthority()) || a.equals((Object)MagicLinkAccessLevel.ONLY_LIVE_WITH_PHOTOS.asAuthority()));
            }
            if (!hasAccess) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Insufficient permissions to access processed visits"));
            }
            User userToFetchDataFrom = (User)this.userJdbcService.findById(userId).orElseThrow(() -> new RuntimeException("User not found"));
            List visits = this.processedVisitJdbcService.findByUserAndTimeOverlap(userToFetchDataFrom, startOfRange, endOfRange);
            Map<SignificantPlace, List<ProcessedVisit>> visitsByPlace = visits.stream().collect(Collectors.groupingBy(ProcessedVisit::getPlace));
            List placeSummaries = visitsByPlace.entrySet().stream().map(entry -> {
                SignificantPlace place = (SignificantPlace)entry.getKey();
                List placeVisits = (List)entry.getValue();
                PlaceInfo placeInfo = new PlaceInfo(place.getId(), place.getName(), place.getAddress(), place.getCity(), place.getCountryCode(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), place.getType(), place.getPolygon());
                List visitDetails = placeVisits.stream().map(visit -> new ProcessedVisitResponse.VisitDetail(visit.getId(), visit.getStartTime().toString(), visit.getEndTime().toString(), visit.getDurationSeconds().longValue())).collect(Collectors.toList());
                long totalDurationMs = placeVisits.stream().mapToLong(ProcessedVisit::getDurationSeconds).sum() * 1000L;
                String color = this.generateColorForPlace(place);
                return new ProcessedVisitResponse.PlaceVisitSummary(placeInfo, visitDetails, totalDurationMs, placeVisits.size(), color);
            }).sorted((a, b) -> Long.compare(b.getTotalDurationMs(), a.getTotalDurationMs())).collect(Collectors.toList());
            return ResponseEntity.ok((Object)new ProcessedVisitResponse(placeSummaries));
        }
        catch (DateTimeParseException e) {
            return ResponseEntity.badRequest().body(Map.of("error", "Invalid date format. Expected format: YYYY-MM-DD or YYYY-MM-DDTHH:MM:SS"));
        }
        catch (Exception e) {
            logger.error("Error fetching processed visits", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Error fetching processed visits: " + e.getMessage()));
        }
    }

    private boolean isPlaceInBox(SignificantPlace place, Double minLat, Double maxLat, Double minLng, Double maxLng) {
        if (place == null || place.getLatitudeCentroid() == null || place.getLongitudeCentroid() == null) {
            return false;
        }
        return place.getLatitudeCentroid() >= minLat && place.getLatitudeCentroid() <= maxLat && place.getLongitudeCentroid() >= minLng && place.getLongitudeCentroid() <= maxLng;
    }

    private String generateColorForPlace(SignificantPlace place) {
        if (place.getId() == null) {
            return "#3388ff";
        }
        int hash = place.getId().hashCode();
        int r = (hash & 0xFF0000) >> 16;
        int g = (hash & 0xFF00) >> 8;
        int b = hash & 0xFF;
        r = Math.max(r, 100);
        g = Math.max(g, 100);
        b = Math.max(b, 100);
        return String.format("#%02x%02x%02x", r, g, b);
    }
}

