/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.api;

import com.dedicatedcode.reitti.config.ConditionalOnPropertyNotEmpty;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/tiles"})
@ConditionalOnPropertyNotEmpty(value="reitti.ui.tiles.cache.url")
public class TileProxyController {
    private static final Logger log = LoggerFactory.getLogger(TileProxyController.class);
    private final HttpClient httpClient;
    private final String tileCacheUrl;

    public TileProxyController(@Value(value="${reitti.ui.tiles.cache.url}") String tileCacheUrl) {
        this.tileCacheUrl = tileCacheUrl;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    }

    @GetMapping(value={"/{z}/{x}/{y}.png"})
    public ResponseEntity<byte[]> getTile(@PathVariable int z, @PathVariable int x, @PathVariable int y, HttpServletRequest request) {
        String tileUrl = String.format("%s/%d/%d/%d.png", this.tileCacheUrl, z, x, y);
        try {
            HttpRequest httpRequest;
            HttpResponse<byte[]> response;
            log.trace("Fetching tile: {}/{}/{}", new Object[]{z, x, y});
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(tileUrl)).timeout(Duration.ofSeconds(30L)).GET();
            String referer = request.getHeader("Referer");
            if (referer != null) {
                requestBuilder.header("Referer", referer);
            }
            if ((response = this.httpClient.send(httpRequest = requestBuilder.build(), HttpResponse.BodyHandlers.ofByteArray())).statusCode() == 200) {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.IMAGE_PNG);
                headers.setCacheControl(CacheControl.maxAge((long)30L, (TimeUnit)TimeUnit.DAYS).cachePublic());
                headers.add("Access-Control-Allow-Origin", "*");
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)response.body());
            }
            log.warn("Failed to fetch tile {}/{}/{}: HTTP {}", new Object[]{z, x, y, response.statusCode()});
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            log.warn("Failed to fetch tile {}/{}/{}: {}", new Object[]{z, x, y, e.getMessage()});
            return ResponseEntity.notFound().build();
        }
    }
}

