/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.api.ingestion.owntracks;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Base64;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OwntracksFriendResponse {
    @JsonProperty(value="_type")
    private final String type;
    @JsonProperty(value="tid")
    private final String tid;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="lat")
    private final Double lat;
    @JsonProperty(value="lon")
    private final Double lon;
    @JsonProperty(value="tst")
    private final Long tst;
    @JsonProperty(value="face")
    private final String face;

    public OwntracksFriendResponse(String tid, String name, byte[] avatarData, String mimeType) {
        this.type = "card";
        this.tid = tid;
        this.name = name;
        this.lat = null;
        this.lon = null;
        this.tst = null;
        this.face = avatarData != null ? this.createFaceData(avatarData, mimeType) : null;
    }

    public OwntracksFriendResponse(String tid, String name, double lat, double lon, long tst) {
        this.type = "location";
        this.tid = tid;
        this.name = name;
        this.lat = lat;
        this.lon = lon;
        this.tst = tst;
        this.face = null;
    }

    private String createFaceData(byte[] avatarData, String mimeType) {
        if (avatarData == null || mimeType == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(avatarData);
    }

    public String getType() {
        return this.type;
    }

    public String getTid() {
        return this.tid;
    }

    public String getName() {
        return this.name;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public Long getTst() {
        return this.tst;
    }

    public String getFace() {
        return this.face;
    }
}

