/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.api.ingestion.owntracks;

import com.dedicatedcode.reitti.controller.api.ingestion.owntracks.OwntracksFriendResponse;
import com.dedicatedcode.reitti.dto.LocationPoint;
import com.dedicatedcode.reitti.dto.OwntracksLocationRequest;
import com.dedicatedcode.reitti.dto.ReittiRemoteInfo;
import com.dedicatedcode.reitti.model.integration.ReittiIntegration;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSharing;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSharingJdbcService;
import com.dedicatedcode.reitti.service.AvatarService;
import com.dedicatedcode.reitti.service.LocationBatchingService;
import com.dedicatedcode.reitti.service.RequestFailedException;
import com.dedicatedcode.reitti.service.RequestTemporaryFailedException;
import com.dedicatedcode.reitti.service.integration.ReittiIntegrationService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/ingest"})
public class OwntracksIngestionApiController {
    private static final Logger logger = LoggerFactory.getLogger(OwntracksIngestionApiController.class);
    private final UserJdbcService userJdbcService;
    private final LocationBatchingService locationBatchingService;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final AvatarService avatarService;
    private final UserSharingJdbcService userSharingJdbcService;
    private final ReittiIntegrationService reittiIntegrationService;

    public OwntracksIngestionApiController(UserJdbcService userJdbcService, LocationBatchingService locationBatchingService, RawLocationPointJdbcService rawLocationPointJdbcService, AvatarService avatarService, UserSharingJdbcService userSharingJdbcService, ReittiIntegrationService reittiIntegrationService) {
        this.userJdbcService = userJdbcService;
        this.locationBatchingService = locationBatchingService;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.avatarService = avatarService;
        this.userSharingJdbcService = userSharingJdbcService;
        this.reittiIntegrationService = reittiIntegrationService;
    }

    @PostMapping(value={"/owntracks"})
    public ResponseEntity<?> receiveOwntracksData(@RequestBody OwntracksLocationRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserDetails userDetails = (UserDetails)authentication.getPrincipal();
        User user = (User)this.userJdbcService.findByUsername(userDetails.getUsername()).orElseThrow(() -> new UsernameNotFoundException(userDetails.getUsername()));
        try {
            if (!request.isLocationUpdate()) {
                logger.debug("Ignoring non-location Owntracks message of type: {}", (Object)request.getType());
                return ResponseEntity.ok(new ArrayList());
            }
            LocationPoint locationPoint = request.toLocationPoint();
            if (locationPoint.getTimestamp() == null) {
                logger.warn("Ignoring location point [{}] because timestamp is null", (Object)locationPoint);
                return ResponseEntity.ok(new ArrayList());
            }
            this.locationBatchingService.addLocationPoint(user, locationPoint);
            logger.debug("Successfully received and queued Owntracks location point for user {}", (Object)user.getUsername());
            List friendsData = this.buildFriendsData(user);
            return ResponseEntity.ok((Object)friendsData);
        }
        catch (Exception e) {
            logger.error("Error processing Owntracks data", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Error processing Owntracks data: " + e.getMessage()));
        }
    }

    private List<OwntracksFriendResponse> buildFriendsData(User user) {
        ArrayList<OwntracksFriendResponse> friendsData = new ArrayList<OwntracksFriendResponse>();
        List sharedUsers = this.userSharingJdbcService.findBySharedWithUser(user.getId());
        for (UserSharing sharing : sharedUsers) {
            Optional sharedUserOpt = this.userJdbcService.findById(sharing.getSharingUserId());
            sharedUserOpt.ifPresent(sharedUser -> {
                String tid = this.generateTid(sharedUser.getUsername());
                Optional avatarThumbnail = this.avatarService.getAvatarThumbnail(sharedUser.getId(), 192, 192);
                friendsData.add(new OwntracksFriendResponse(tid, sharedUser.getDisplayName(), (byte[])avatarThumbnail.orElse(null), "image/jpeg"));
                Optional latestLocation = this.rawLocationPointJdbcService.findLatest(sharedUser);
                latestLocation.ifPresent(location -> friendsData.add(new OwntracksFriendResponse(tid, sharedUser.getDisplayName(), location.getLatitude().doubleValue(), location.getLongitude().doubleValue(), location.getTimestamp().getEpochSecond())));
            });
        }
        List integrations = this.reittiIntegrationService.getActiveIntegrationsForUser(user);
        for (ReittiIntegration integration : integrations) {
            try {
                ReittiRemoteInfo info = this.reittiIntegrationService.getInfo(integration);
                String tid = this.generateTid(info.userInfo().username());
                OwntracksFriendResponse owntracksFriendResponse = this.reittiIntegrationService.getAvatar(user, integration.getId()).map(avatarData -> new OwntracksFriendResponse(tid, info.userInfo().displayName(), avatarData.imageData(), avatarData.mimeType())).orElse(new OwntracksFriendResponse(tid, info.userInfo().displayName(), null, null));
                friendsData.add(owntracksFriendResponse);
                Optional latestLocation = this.reittiIntegrationService.findLatest(user, integration.getId());
                latestLocation.ifPresent(location -> friendsData.add(new OwntracksFriendResponse(tid, info.userInfo().displayName(), location.getLatitude().doubleValue(), location.getLongitude().doubleValue(), Instant.parse(location.getTimestamp()).getEpochSecond())));
            }
            catch (RequestFailedException | RequestTemporaryFailedException e) {
                logger.warn("Couldn't fetch info for integration {}", (Object)integration.getId(), (Object)e);
            }
        }
        return friendsData;
    }

    private String generateTid(String username) {
        return username != null && username.length() >= 2 ? username.substring(0, 2).toUpperCase() : "UN";
    }
}

