/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.VersionService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/settings"})
public class AboutController {
    private final VersionService versionService;
    private final boolean dataManagementEnabled;
    private final ObjectMapper objectMapper;

    public AboutController(VersionService versionService, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled, ObjectMapper objectMapper) {
        this.versionService = versionService;
        this.dataManagementEnabled = dataManagementEnabled;
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/about"})
    public String getPage(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("activeSection", (Object)"about");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("buildVersion", (Object)this.versionService.getVersion());
        model.addAttribute("gitCommitDetails", (Object)this.versionService.getCommitDetails());
        model.addAttribute("buildTime", (Object)this.versionService.getBuildTime());
        try {
            model.addAttribute("contributors", (Object)this.loadContributors());
            model.addAttribute("projects", (Object)this.loadProjects());
        }
        catch (IOException e) {
            model.addAttribute("contributors", List.of());
            model.addAttribute("projects", List.of());
        }
        return "settings/about";
    }

    private List<Map<String, Object>> loadContributors() throws IOException {
        ClassPathResource resource = new ClassPathResource("contributors.json");
        Map data = (Map)this.objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return (List)data.get("contributors");
    }

    private List<Map<String, Object>> loadProjects() throws IOException {
        ClassPathResource resource = new ClassPathResource("projects.json");
        Map data = (Map)this.objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return (List)data.get("projects");
    }
}

