/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.controller.settings.ApiTokenSettingsController;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.ApiTokenService;
import com.dedicatedcode.reitti.service.TimeUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/settings/api-tokens"})
public class ApiTokenSettingsController {
    private final ApiTokenService apiTokenService;
    private final MessageSource messageSource;
    private final boolean dataManagementEnabled;

    public ApiTokenSettingsController(ApiTokenService apiTokenService, MessageSource messageSource, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.apiTokenService = apiTokenService;
        this.messageSource = messageSource;
        this.dataManagementEnabled = dataManagementEnabled;
    }

    @GetMapping
    public String getPage(@AuthenticationPrincipal User user, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        model.addAttribute("activeSection", (Object)"api-tokens");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("tokens", this.apiTokenService.getTokensForUser(user).stream().map(t -> new ApiTokeDTO(t.getId(), t.getToken(), t.getName(), TimeUtil.adjustInstant((Instant)t.getCreatedAt(), (ZoneId)timezone), TimeUtil.adjustInstant((Instant)t.getLastUsedAt(), (ZoneId)timezone))).toList());
        return "settings/api-tokens";
    }

    @GetMapping(value={"/usages"})
    public String getTokenUsages(@AuthenticationPrincipal User user, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, Model model) {
        model.addAttribute("recentUsages", this.apiTokenService.getRecentUsagesForUser(user, 10).stream().map(t -> new ApiTokenUsageDTO(t.token(), t.name(), TimeUtil.adjustInstant((Instant)t.at(), (ZoneId)timezone), t.endpoint(), t.ip())).toList());
        model.addAttribute("maxUsagesToShow", (Object)10);
        return "settings/api-tokens :: api-token-usages";
    }

    @PostMapping
    public String createToken(@AuthenticationPrincipal User user, @RequestParam String name, Model model) {
        try {
            this.apiTokenService.createToken(user, name);
            model.addAttribute("successMessage", (Object)this.getMessage("message.success.token.created", new Object[0]));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("message.error.token.creation", new Object[]{e.getMessage()}));
        }
        List tokens = this.apiTokenService.getTokensForUser(user);
        model.addAttribute("tokens", (Object)tokens);
        model.addAttribute("recentUsages", (Object)this.apiTokenService.getRecentUsagesForUser(user, 10));
        model.addAttribute("maxUsagesToShow", (Object)10);
        return "settings/api-tokens :: api-tokens-content";
    }

    @PostMapping(value={"/{tokenId}/delete"})
    public String deleteToken(@PathVariable Long tokenId, @AuthenticationPrincipal User user, Model model) {
        try {
            this.apiTokenService.deleteToken(tokenId);
            model.addAttribute("successMessage", (Object)this.getMessage("message.success.token.deleted", new Object[0]));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("message.error.token.deletion", new Object[]{e.getMessage()}));
        }
        List tokens = this.apiTokenService.getTokensForUser(user);
        model.addAttribute("tokens", (Object)tokens);
        model.addAttribute("recentUsages", (Object)this.apiTokenService.getRecentUsagesForUser(user, 10));
        model.addAttribute("maxUsagesToShow", (Object)10);
        return "settings/api-tokens :: api-tokens-content";
    }

    private String getMessage(String key, Object ... args) {
        return this.messageSource.getMessage(key, args, LocaleContextHolder.getLocale());
    }
}

