/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.controller.settings.ExportDataController;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.service.GpxExportService;
import com.dedicatedcode.reitti.service.TimeUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Controller
@RequestMapping(value={"/settings/export-data"})
public class ExportDataController {
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final GpxExportService gpxExportService;
    private final boolean dataManagementEnabled;

    public ExportDataController(RawLocationPointJdbcService rawLocationPointJdbcService, GpxExportService gpxExportService, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.gpxExportService = gpxExportService;
        this.dataManagementEnabled = dataManagementEnabled;
    }

    @GetMapping
    public void getExportDataContent(@AuthenticationPrincipal User user, Model model) {
        LocalDate today = LocalDate.now();
        model.addAttribute("startDate", (Object)today);
        model.addAttribute("endDate", (Object)today);
        model.addAttribute("rawLocationPoints", Collections.emptyList());
        model.addAttribute("activeSection", (Object)"export-data");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
    }

    @GetMapping(value={"/data-content"})
    public String getExportDataContent(@AuthenticationPrincipal User user, @RequestParam(required=false) String startDate, @RequestParam(required=false) String endDate, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone, @RequestParam(required=false, defaultValue="0") int page, @RequestParam(required=false, defaultValue="100") int size, Model model) {
        LocalDate start = StringUtils.hasText((String)startDate) ? LocalDate.parse(startDate) : LocalDate.now();
        LocalDate end = StringUtils.hasText((String)endDate) ? LocalDate.parse(endDate) : LocalDate.now();
        ZonedDateTime startDateTime = start.atStartOfDay(timezone);
        ZonedDateTime endDateTime = end.plusDays(1L).atStartOfDay(timezone);
        model.addAttribute("startDate", (Object)start);
        model.addAttribute("endDate", (Object)end);
        List allPoints = this.rawLocationPointJdbcService.findByUserAndTimestampBetweenOrderByTimestampAsc(user, startDateTime.toInstant(), endDateTime.toInstant(), false, true, page, size);
        long totalElements = this.rawLocationPointJdbcService.countByUserAndTimestampBetweenOrderByTimestampAsc(user, startDateTime.toInstant(), endDateTime.toInstant(), false, true);
        int totalPages = (int)Math.ceil((double)totalElements / (double)size);
        List<DataLine> paginatedData = allPoints.stream().map(p -> new DataLine(TimeUtil.adjustInstant((Instant)p.getTimestamp(), (ZoneId)timezone), p.getLatitude().doubleValue(), p.getLongitude().doubleValue(), p.getAccuracyMeters().doubleValue(), p.isProcessed())).toList();
        model.addAttribute("rawLocationPoints", paginatedData);
        model.addAttribute("currentPage", (Object)page);
        model.addAttribute("pageSize", (Object)size);
        model.addAttribute("totalElements", (Object)totalElements);
        model.addAttribute("totalPages", (Object)totalPages);
        model.addAttribute("hasNext", (Object)(page < totalPages - 1 ? 1 : 0));
        model.addAttribute("hasPrevious", (Object)(page > 0 ? 1 : 0));
        return "settings/export-data :: data-content";
    }

    @GetMapping(value={"/gpx"})
    public ResponseEntity<StreamingResponseBody> exportGpx(@AuthenticationPrincipal User user, @RequestParam String startDate, @RequestParam String endDate, @RequestParam boolean relevantData, @RequestParam(required=false, defaultValue="UTC") ZoneId timezone) {
        try {
            LocalDate start = LocalDate.parse(startDate);
            LocalDate end = LocalDate.parse(endDate);
            ZonedDateTime startDateTime = start.atStartOfDay(timezone);
            ZonedDateTime endDateTime = end.plusDays(1L).atStartOfDay(timezone);
            String filename = String.format("location_data_%s_to_%s.gpx", start.format(DateTimeFormatter.ISO_LOCAL_DATE), end.format(DateTimeFormatter.ISO_LOCAL_DATE));
            StreamingResponseBody stream = outputStream -> {
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    this.gpxExportService.generateGpxContentStreaming(user, startDateTime.toInstant(), endDateTime.toInstant(), (Writer)writer, relevantData);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error generating GPX file", e);
                }
            };
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + filename + "\""})).contentType(MediaType.APPLICATION_XML).body((Object)stream);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body(outputStream -> {
                try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                    writer.write("Error generating GPX file: " + e.getMessage());
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            });
        }
    }
}

