/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.importer.GeoJsonImporter;
import com.dedicatedcode.reitti.service.importer.GoogleAndroidTimelineImporter;
import com.dedicatedcode.reitti.service.importer.GoogleIOSTimelineImporter;
import com.dedicatedcode.reitti.service.importer.GoogleRecordsImporter;
import com.dedicatedcode.reitti.service.importer.GpxImporter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/settings/import"})
public class FileImportController {
    private static final Logger logger = LoggerFactory.getLogger(FileImportController.class);
    private final GpxImporter gpxImporter;
    private final GoogleRecordsImporter googleRecordsImporter;
    private final GoogleAndroidTimelineImporter googleAndroidTimelineImporter;
    private final GoogleIOSTimelineImporter googleTimelineIOSImporter;
    private final GeoJsonImporter geoJsonImporter;
    private final boolean dataManagementEnabled;

    public FileImportController(GpxImporter gpxImporter, GoogleRecordsImporter googleRecordsImporter, GoogleAndroidTimelineImporter googleAndroidTimelineImporter, GoogleIOSTimelineImporter googleTimelineIOSImporter, GeoJsonImporter geoJsonImporter, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.gpxImporter = gpxImporter;
        this.googleRecordsImporter = googleRecordsImporter;
        this.googleAndroidTimelineImporter = googleAndroidTimelineImporter;
        this.googleTimelineIOSImporter = googleTimelineIOSImporter;
        this.geoJsonImporter = geoJsonImporter;
        this.dataManagementEnabled = dataManagementEnabled;
    }

    @GetMapping
    public String getFileUploadPage(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("activeSection", (Object)"file-upload");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        return "settings/import-data";
    }

    @PostMapping(value={"/gpx"})
    public String importGpx(@RequestParam(value="files") MultipartFile[] files, Authentication authentication, Model model) {
        User user = (User)authentication.getPrincipal();
        if (files.length == 0) {
            model.addAttribute("uploadErrorMessage", (Object)"No files selected");
            return "settings/import-data :: file-upload-content";
        }
        int totalProcessed = 0;
        int successCount = 0;
        StringBuilder errorMessages = new StringBuilder();
        for (MultipartFile file : files) {
            if (file.isEmpty() || file.getOriginalFilename() == null) {
                errorMessages.append("File ").append(file.getOriginalFilename()).append(" is empty. ");
                continue;
            }
            if (!file.getOriginalFilename().endsWith(".gpx")) {
                errorMessages.append("File ").append(file.getOriginalFilename()).append(" is not a GPX file. ");
                continue;
            }
            try (InputStream inputStream = file.getInputStream();){
                Map result = this.gpxImporter.importGpx(inputStream, user);
                if (((Boolean)result.get("success")).booleanValue()) {
                    totalProcessed += ((Integer)result.get("pointsReceived")).intValue();
                    ++successCount;
                    continue;
                }
                errorMessages.append("Error processing ").append(file.getOriginalFilename()).append(": ").append(result.get("error")).append(". ");
            }
            catch (IOException e) {
                errorMessages.append("Error processing ").append(file.getOriginalFilename()).append(": ").append(e.getMessage()).append(". ");
            }
        }
        if (successCount > 0) {
            String message = "Successfully processed " + successCount + " file(s) with " + totalProcessed + " location points";
            if (!errorMessages.isEmpty()) {
                message = message + ". Errors: " + String.valueOf(errorMessages);
            }
            model.addAttribute("uploadSuccessMessage", (Object)message);
        } else {
            model.addAttribute("uploadErrorMessage", (Object)("No files were processed successfully. " + String.valueOf(errorMessages)));
        }
        return "settings/import-data :: file-upload-content";
    }

    @PostMapping(value={"/google-records"})
    public String importGoogleRecords(@RequestParam(value="file") MultipartFile file, Authentication authentication, Model model) {
        String string;
        block12: {
            User user = (User)authentication.getPrincipal();
            if (file.isEmpty() || file.getOriginalFilename() == null) {
                model.addAttribute("uploadErrorMessage", (Object)"File is empty");
                return "settings/import-data :: file-upload-content";
            }
            if (!file.getOriginalFilename().endsWith(".json")) {
                model.addAttribute("uploadErrorMessage", (Object)"Only JSON files are supported");
                return "settings/import-data :: file-upload-content";
            }
            InputStream inputStream = file.getInputStream();
            try {
                Map result = this.googleRecordsImporter.importGoogleRecords(inputStream, user);
                if (((Boolean)result.get("success")).booleanValue()) {
                    model.addAttribute("uploadSuccessMessage", result.get("message"));
                } else {
                    model.addAttribute("uploadErrorMessage", result.get("error"));
                }
                string = "settings/import-data :: file-upload-content";
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    model.addAttribute("uploadErrorMessage", (Object)("Error processing file: " + e.getMessage()));
                    return "settings/import-data :: file-upload-content";
                }
            }
            inputStream.close();
        }
        return string;
    }

    @PostMapping(value={"/google-timeline-android"})
    public String importGoogleTimelineAndroid(@RequestParam(value="file") MultipartFile file, Authentication authentication, Model model) {
        String string;
        block12: {
            User user = (User)authentication.getPrincipal();
            if (file.isEmpty() || file.getOriginalFilename() == null) {
                model.addAttribute("uploadErrorMessage", (Object)"File is empty");
                return "settings/import-data :: file-upload-content";
            }
            if (!file.getOriginalFilename().endsWith(".json")) {
                model.addAttribute("uploadErrorMessage", (Object)"Only JSON files are supported");
                return "settings/import-data :: file-upload-content";
            }
            InputStream inputStream = file.getInputStream();
            try {
                Map result = this.googleAndroidTimelineImporter.importTimeline(inputStream, user);
                if (((Boolean)result.get("success")).booleanValue()) {
                    model.addAttribute("uploadSuccessMessage", result.get("message"));
                } else {
                    model.addAttribute("uploadErrorMessage", result.get("error"));
                }
                string = "settings/import-data :: file-upload-content";
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    model.addAttribute("uploadErrorMessage", (Object)("Error processing file: " + e.getMessage()));
                    return "settings/import-data :: file-upload-content";
                }
            }
            inputStream.close();
        }
        return string;
    }

    @PostMapping(value={"/google-timeline-ios"})
    public String importGoogleTimelineIOS(@RequestParam(value="file") MultipartFile file, Authentication authentication, Model model) {
        String string;
        block12: {
            User user = (User)authentication.getPrincipal();
            if (file.isEmpty() || file.getOriginalFilename() == null) {
                model.addAttribute("uploadErrorMessage", (Object)"File is empty");
                return "settings/import-data :: file-upload-content";
            }
            if (!file.getOriginalFilename().endsWith(".json")) {
                model.addAttribute("uploadErrorMessage", (Object)"Only JSON files are supported");
                return "settings/import-data :: file-upload-content";
            }
            InputStream inputStream = file.getInputStream();
            try {
                Map result = this.googleTimelineIOSImporter.importTimeline(inputStream, user);
                if (((Boolean)result.get("success")).booleanValue()) {
                    model.addAttribute("uploadSuccessMessage", result.get("message"));
                } else {
                    model.addAttribute("uploadErrorMessage", result.get("error"));
                }
                string = "settings/import-data :: file-upload-content";
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    model.addAttribute("uploadErrorMessage", (Object)("Error processing file: " + e.getMessage()));
                    return "settings/import-data :: file-upload-content";
                }
            }
            inputStream.close();
        }
        return string;
    }

    @PostMapping(value={"/geojson"})
    public String importGeoJson(@RequestParam(value="files") MultipartFile[] files, Authentication authentication, Model model) {
        User user = (User)authentication.getPrincipal();
        if (files.length == 0) {
            model.addAttribute("uploadErrorMessage", (Object)"No files selected");
            return "settings/import-data :: file-upload-content";
        }
        int totalProcessed = 0;
        int successCount = 0;
        StringBuilder errorMessages = new StringBuilder();
        for (MultipartFile file : files) {
            if (file.isEmpty()) {
                errorMessages.append("File ").append(file.getOriginalFilename()).append(" is empty. ");
                continue;
            }
            String filename = file.getOriginalFilename();
            if (filename == null || !filename.endsWith(".geojson") && !filename.endsWith(".json")) {
                errorMessages.append("File ").append(filename).append(" is not a GeoJSON file. ");
                continue;
            }
            try (InputStream inputStream = file.getInputStream();){
                Map result = this.geoJsonImporter.importGeoJson(inputStream, user);
                if (((Boolean)result.get("success")).booleanValue()) {
                    totalProcessed += ((Integer)result.get("pointsReceived")).intValue();
                    ++successCount;
                    continue;
                }
                errorMessages.append("Error processing ").append(filename).append(": ").append(result.get("error")).append(". ");
            }
            catch (IOException e) {
                errorMessages.append("Error processing ").append(filename).append(": ").append(e.getMessage()).append(". ");
            }
        }
        if (successCount > 0) {
            String message = "Successfully processed " + successCount + " file(s) with " + totalProcessed + " location points";
            if (!errorMessages.isEmpty()) {
                message = message + ". Errors: " + String.valueOf(errorMessages);
            }
            model.addAttribute("uploadSuccessMessage", (Object)message);
        } else {
            model.addAttribute("uploadErrorMessage", (Object)("No files were processed successfully. " + String.valueOf(errorMessages)));
        }
        return "settings/import-data :: file-upload-content";
    }
}

