/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.event.SignificantPlaceCreatedEvent;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.geocoding.RemoteGeocodeService;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.GeocodeServiceJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceOverrideJdbcService;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import java.util.List;
import java.util.UUID;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/settings/geocode-services"})
public class GeoCodingSettingsController {
    private final GeocodeServiceJdbcService geocodeServiceJdbcService;
    private final SignificantPlaceJdbcService placeJdbcService;
    private final SignificantPlaceOverrideJdbcService significantPlaceOverrideJdbcService;
    private final UserJdbcService userJdbcService;
    private final RabbitTemplate rabbitTemplate;
    private final MessageSource messageSource;
    private final boolean dataManagementEnabled;
    private final int maxErrors;

    public GeoCodingSettingsController(GeocodeServiceJdbcService geocodeServiceJdbcService, SignificantPlaceJdbcService placeJdbcService, SignificantPlaceOverrideJdbcService significantPlaceOverrideJdbcService, UserJdbcService userJdbcService, RabbitTemplate rabbitTemplate, MessageSource messageSource, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled, @Value(value="${reitti.geocoding.max-errors}") int maxErrors) {
        this.geocodeServiceJdbcService = geocodeServiceJdbcService;
        this.placeJdbcService = placeJdbcService;
        this.significantPlaceOverrideJdbcService = significantPlaceOverrideJdbcService;
        this.userJdbcService = userJdbcService;
        this.rabbitTemplate = rabbitTemplate;
        this.messageSource = messageSource;
        this.dataManagementEnabled = dataManagementEnabled;
        this.maxErrors = maxErrors;
    }

    @GetMapping
    public String getPage(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("activeSection", (Object)"geocode-services");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services";
    }

    @GetMapping(value={"/geocode-services-content"})
    public String getGeocodeServicesContent(Model model) {
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services :: geocode-services-content";
    }

    @PostMapping
    public String createGeocodeService(@RequestParam String name, @RequestParam String urlTemplate, Model model) {
        try {
            RemoteGeocodeService service = new RemoteGeocodeService(name, urlTemplate, true, 0, null, null);
            this.geocodeServiceJdbcService.save(service);
            model.addAttribute("successMessage", (Object)this.getMessage("message.success.geocode.created", new Object[0]));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("message.error.geocode.creation", new Object[]{e.getMessage()}));
        }
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services :: geocode-services-content";
    }

    @PostMapping(value={"/{id}/toggle"})
    public String toggleGeocodeService(@PathVariable Long id, Model model) {
        RemoteGeocodeService service;
        if ((service = service.withEnabled(!(service = (RemoteGeocodeService)this.geocodeServiceJdbcService.findById(id).orElseThrow()).isEnabled())).isEnabled()) {
            service = service.resetErrorCount();
        }
        this.geocodeServiceJdbcService.save(service);
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services :: geocode-services-content";
    }

    @PostMapping(value={"/{id}/delete"})
    public String deleteGeocodeService(@PathVariable Long id, Model model) {
        RemoteGeocodeService service = (RemoteGeocodeService)this.geocodeServiceJdbcService.findById(id).orElseThrow();
        this.geocodeServiceJdbcService.delete(service);
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services :: geocode-services-content";
    }

    @PostMapping(value={"/{id}/reset-errors"})
    public String resetGeocodeServiceErrors(@PathVariable Long id, Model model) {
        RemoteGeocodeService service = (RemoteGeocodeService)this.geocodeServiceJdbcService.findById(id).orElseThrow();
        this.geocodeServiceJdbcService.save(service.resetErrorCount().withEnabled(true));
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services :: geocode-services-content";
    }

    @PostMapping(value={"/run-geocoding"})
    public String runGeocoding(Authentication authentication, Model model) {
        try {
            String username = authentication.getName();
            User currentUser = (User)this.userJdbcService.findByUsername(username).orElseThrow(() -> new UsernameNotFoundException("User not found: " + username));
            List nonGeocodedPlaces = this.placeJdbcService.findNonGeocodedByUser(currentUser);
            if (nonGeocodedPlaces.isEmpty()) {
                model.addAttribute("successMessage", (Object)this.getMessage("geocoding.no.places", new Object[0]));
            } else {
                for (SignificantPlace place : nonGeocodedPlaces) {
                    SignificantPlaceCreatedEvent event = new SignificantPlaceCreatedEvent(username, null, place.getId(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), UUID.randomUUID().toString());
                    this.rabbitTemplate.convertAndSend("reitti-exchange", "reitti.place.created.v2", (Object)event);
                }
                model.addAttribute("successMessage", (Object)this.getMessage("geocoding.run.success", new Object[]{nonGeocodedPlaces.size()}));
            }
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("geocoding.run.error", new Object[]{e.getMessage()}));
        }
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services :: geocode-services-content";
    }

    @PostMapping(value={"/clear-and-rerun"})
    public String clearAndRerunGeocoding(Authentication authentication, Model model) {
        try {
            String username = authentication.getName();
            User currentUser = (User)this.userJdbcService.findByUsername(username).orElseThrow(() -> new UsernameNotFoundException("User not found: " + username));
            List allPlaces = this.placeJdbcService.findAllByUser(currentUser);
            if (allPlaces.isEmpty()) {
                model.addAttribute("successMessage", (Object)this.getMessage("geocoding.no.places", new Object[0]));
            } else {
                for (SignificantPlace place : allPlaces) {
                    SignificantPlace clearedPlace = place.withGeocoded(false).withAddress(null);
                    this.significantPlaceOverrideJdbcService.clear(currentUser, clearedPlace);
                    this.placeJdbcService.update(clearedPlace);
                }
                for (SignificantPlace place : allPlaces) {
                    SignificantPlaceCreatedEvent event = new SignificantPlaceCreatedEvent(username, null, place.getId(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), UUID.randomUUID().toString());
                    this.rabbitTemplate.convertAndSend("reitti-exchange", "reitti.place.created.v2", (Object)event);
                }
                model.addAttribute("successMessage", (Object)this.getMessage("geocoding.clear.success", new Object[]{allPlaces.size()}));
            }
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("geocoding.clear.error", new Object[]{e.getMessage()}));
        }
        model.addAttribute("geocodeServices", (Object)this.geocodeServiceJdbcService.findAllByOrderByNameAsc());
        model.addAttribute("maxErrors", (Object)this.maxErrors);
        return "settings/geocode-services :: geocode-services-content";
    }

    private String getMessage(String key, Object ... args) {
        return this.messageSource.getMessage(key, args, LocaleContextHolder.getLocale());
    }
}

