/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.controller.settings.IntegrationsSettingsController;
import com.dedicatedcode.reitti.model.IntegrationTestResult;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.geo.RawLocationPoint;
import com.dedicatedcode.reitti.model.integration.ImmichIntegration;
import com.dedicatedcode.reitti.model.integration.OwnTracksRecorderIntegration;
import com.dedicatedcode.reitti.model.security.ApiToken;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.service.ApiTokenService;
import com.dedicatedcode.reitti.service.integration.ImmichIntegrationService;
import com.dedicatedcode.reitti.service.integration.OwnTracksRecorderIntegrationService;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/settings/integrations"})
public class IntegrationsSettingsController {
    private final ApiTokenService apiTokenService;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final ImmichIntegrationService immichIntegrationService;
    private final OwnTracksRecorderIntegrationService ownTracksRecorderIntegrationService;
    private final MessageSource messageSource;
    private final boolean dataManagementEnabled;

    public IntegrationsSettingsController(ApiTokenService apiTokenService, RawLocationPointJdbcService rawLocationPointJdbcService, ImmichIntegrationService immichIntegrationService, OwnTracksRecorderIntegrationService ownTracksRecorderIntegrationService, MessageSource messageSource, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.apiTokenService = apiTokenService;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.immichIntegrationService = immichIntegrationService;
        this.ownTracksRecorderIntegrationService = ownTracksRecorderIntegrationService;
        this.messageSource = messageSource;
        this.dataManagementEnabled = dataManagementEnabled;
    }

    @GetMapping
    public String getPage(@AuthenticationPrincipal User user, @RequestParam(required=false) String openSection, HttpServletRequest request, Model model) {
        model.addAttribute("activeSection", (Object)"integrations");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        List tokens = this.apiTokenService.getTokensForUser(user);
        String selectedToken = null;
        if (!tokens.isEmpty()) {
            selectedToken = ((ApiToken)tokens.getFirst()).getToken();
            model.addAttribute("firstToken", (Object)selectedToken);
            model.addAttribute("hasToken", (Object)true);
        } else {
            model.addAttribute("hasToken", (Object)false);
        }
        model.addAttribute("selectedToken", (Object)selectedToken);
        model.addAttribute("tokens", (Object)tokens);
        Optional recorderIntegration = this.ownTracksRecorderIntegrationService.getIntegrationForUser(user);
        if (recorderIntegration.isPresent()) {
            model.addAttribute("ownTracksRecorderIntegration", recorderIntegration.get());
            model.addAttribute("hasRecorderIntegration", (Object)((OwnTracksRecorderIntegration)recorderIntegration.get()).isEnabled());
        } else {
            model.addAttribute("hasRecorderIntegration", (Object)false);
        }
        model.addAttribute("openSection", (Object)openSection);
        model.addAttribute("serverUrl", (Object)this.calculateServerUrl(request));
        return "settings/integrations";
    }

    @GetMapping(value={"/integrations-content"})
    public String getIntegrationsContent(@AuthenticationPrincipal User currentUser, @RequestParam(required=false) String selectedToken, HttpServletRequest request, Model model, @RequestParam(required=false) String openSection) {
        List tokens = this.apiTokenService.getTokensForUser(currentUser);
        String tokenToUse = null;
        if (selectedToken != null && tokens.stream().anyMatch(t -> t.getToken().equals(selectedToken))) {
            tokenToUse = selectedToken;
        } else if (!tokens.isEmpty()) {
            tokenToUse = ((ApiToken)tokens.getFirst()).getToken();
        }
        if (tokenToUse != null) {
            model.addAttribute("firstToken", (Object)tokenToUse);
            model.addAttribute("hasToken", (Object)true);
        } else {
            model.addAttribute("hasToken", (Object)false);
        }
        model.addAttribute("selectedToken", (Object)tokenToUse);
        model.addAttribute("tokens", (Object)tokens);
        Optional recorderIntegration = this.ownTracksRecorderIntegrationService.getIntegrationForUser(currentUser);
        if (recorderIntegration.isPresent()) {
            model.addAttribute("ownTracksRecorderIntegration", recorderIntegration.get());
            model.addAttribute("hasRecorderIntegration", (Object)((OwnTracksRecorderIntegration)recorderIntegration.get()).isEnabled());
        } else {
            model.addAttribute("hasRecorderIntegration", (Object)false);
        }
        model.addAttribute("openSection", (Object)openSection);
        model.addAttribute("serverUrl", (Object)this.calculateServerUrl(request));
        return "settings/integrations :: integrations-content";
    }

    private String calculateServerUrl(HttpServletRequest request) {
        String scheme = request.getScheme();
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        StringBuilder serverUrl = new StringBuilder();
        serverUrl.append(scheme).append("://").append(serverName);
        if (scheme.equals("http") && serverPort != 80 || scheme.equals("https") && serverPort != 443) {
            serverUrl.append(":").append(serverPort);
        }
        return serverUrl.toString();
    }

    @GetMapping(value={"/reitti.properties"})
    public ResponseEntity<String> getGpsLoggerProperties(@RequestParam String token, HttpServletRequest request) {
        String serverUrl = this.calculateServerUrl(request);
        String url = serverUrl + "/api/v1/ingest/owntracks?token=" + token;
        String properties = "log_customurl_url=" + url + "\nlog_customurl_method=POST\nlog_customurl_body={\"_type\" : \"location\",\"t\": \"u\",\"acc\": \"%ACC\",\"alt\": \"%ALT\",\"batt\": \"%BATT\",\"bs\": \"%ISCHARGING\",\"lat\": \"%LAT\",\"lon\": \"%LON\",\"tst\": \"%TIMESTAMP\",\"vel\": \"%SPD\"}\nlog_customurl_headers=Content-Type: application/json\nautosend_frequency_minutes=60\naccuracy_before_logging=25\ntime_before_logging=15\nautosend_enabled=true\n";
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"text/plain"})).body((Object)properties);
    }

    @GetMapping(value={"/photos-content"})
    public String getPhotosContent(@AuthenticationPrincipal User user, Model model) {
        Optional integration = this.immichIntegrationService.getIntegrationForUser(user);
        if (integration.isPresent()) {
            model.addAttribute("immichIntegration", integration.get());
            model.addAttribute("hasIntegration", (Object)true);
        } else {
            model.addAttribute("hasIntegration", (Object)false);
        }
        return "fragments/photos :: photos-content";
    }

    @PostMapping(value={"/immich-integration"})
    public String saveImmichIntegration(@RequestParam String serverUrl, @RequestParam String apiToken, @RequestParam(defaultValue="false") boolean enabled, @AuthenticationPrincipal User currentUser, Model model) {
        try {
            ImmichIntegration integration = this.immichIntegrationService.saveIntegration(currentUser, serverUrl, apiToken, enabled);
            model.addAttribute("immichIntegration", (Object)integration);
            model.addAttribute("hasIntegration", (Object)true);
            model.addAttribute("successMessage", (Object)this.getMessage("integrations.immich.config.saved", new Object[0]));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("integrations.immich.config.error", new Object[]{e.getMessage()}));
            ImmichIntegration tempIntegration = new ImmichIntegration(serverUrl, apiToken, enabled);
            model.addAttribute("immichIntegration", (Object)tempIntegration);
            model.addAttribute("hasIntegration", (Object)true);
        }
        return "fragments/photos :: photos-content";
    }

    @PostMapping(value={"/immich-integration/test"})
    @ResponseBody
    public Map<String, Object> testImmichConnection(@RequestParam String serverUrl, @RequestParam String apiToken) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            IntegrationTestResult result = this.immichIntegrationService.testConnection(serverUrl, apiToken);
            if (result.success()) {
                response.put("success", true);
                response.put("message", this.getMessage("integrations.immich.connection.success", new Object[0]));
            } else {
                response.put("success", false);
                response.put("message", this.getMessage("integrations.immich.connection.failed", new Object[]{result.message()}));
            }
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", this.getMessage("integrations.immich.connection.failed", new Object[]{e.getMessage()}));
        }
        return response;
    }

    @PostMapping(value={"/owntracks-recorder-integration"})
    public String saveOwnTracksRecorderIntegration(@RequestParam String baseUrl, @RequestParam String username, @RequestParam String deviceId, @RequestParam(defaultValue="false") boolean enabled, @RequestParam String authUsername, @RequestParam String authPassword, @AuthenticationPrincipal User currentUser, Model model) {
        List tokens = this.apiTokenService.getTokensForUser(currentUser);
        if (!tokens.isEmpty()) {
            model.addAttribute("firstToken", (Object)((ApiToken)tokens.getFirst()).getToken());
            model.addAttribute("hasToken", (Object)true);
        } else {
            model.addAttribute("hasToken", (Object)false);
        }
        model.addAttribute("tokens", (Object)tokens);
        try {
            OwnTracksRecorderIntegration integration = this.ownTracksRecorderIntegrationService.saveIntegration(currentUser, baseUrl, username, authUsername, authPassword, deviceId, enabled);
            model.addAttribute("successMessage", (Object)this.getMessage("integrations.owntracks.recorder.config.saved", new Object[0]));
            model.addAttribute("ownTracksRecorderIntegration", (Object)integration);
            model.addAttribute("hasRecorderIntegration", (Object)enabled);
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("integrations.owntracks.recorder.config.error", new Object[]{e.getMessage()}));
            OwnTracksRecorderIntegration tempIntegration = new OwnTracksRecorderIntegration(baseUrl, username, deviceId, enabled, authUsername, authPassword);
            model.addAttribute("ownTracksRecorderIntegration", (Object)tempIntegration);
            model.addAttribute("hasRecorderIntegration", (Object)enabled);
        }
        model.addAttribute("openSection", (Object)"external-data-stores");
        return "settings/integrations :: integrations-content";
    }

    @PostMapping(value={"/owntracks-recorder-integration/test"})
    @ResponseBody
    public Map<String, Object> testOwnTracksRecorderConnection(@RequestParam String baseUrl, @RequestParam String username, @RequestParam String deviceId, @RequestParam String authUsername, @RequestParam String authPassword) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            boolean connectionSuccessful = this.ownTracksRecorderIntegrationService.testConnection(baseUrl, username, authUsername, authPassword, deviceId);
            if (connectionSuccessful) {
                response.put("success", true);
                response.put("message", this.getMessage("integrations.owntracks.recorder.connection.success", new Object[0]));
            } else {
                response.put("success", false);
                response.put("message", this.getMessage("integrations.owntracks.recorder.connection.failed", new Object[]{"Invalid configuration"}));
            }
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", this.getMessage("integrations.owntracks.recorder.connection.failed", new Object[]{e.getMessage()}));
        }
        return response;
    }

    @PostMapping(value={"/owntracks-recorder-integration/delete"})
    public String deleteOwnTracksRecorderIntegration(@AuthenticationPrincipal User currentUser, Model model, HttpServletRequest request) {
        try {
            this.ownTracksRecorderIntegrationService.deleteIntegration(currentUser);
            model.addAttribute("successMessage", (Object)this.getMessage("integrations.owntracks.recorder.config.deleted", new Object[0]));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("integrations.owntracks.recorder.config.delete.error", new Object[]{e.getMessage()}));
        }
        List tokens = this.apiTokenService.getTokensForUser(currentUser);
        if (!tokens.isEmpty()) {
            model.addAttribute("firstToken", (Object)((ApiToken)tokens.getFirst()).getToken());
            model.addAttribute("hasToken", (Object)true);
        } else {
            model.addAttribute("hasToken", (Object)false);
        }
        model.addAttribute("tokens", (Object)tokens);
        model.addAttribute("serverUrl", (Object)this.calculateServerUrl(request));
        model.addAttribute("hasRecorderIntegration", (Object)false);
        return "settings/integrations :: integrations-content";
    }

    @PostMapping(value={"/owntracks-recorder-integration/load-historical"})
    public String loadOwnTracksRecorderHistoricalData(@AuthenticationPrincipal User currentUser, Model model, HttpServletRequest request) {
        try {
            this.ownTracksRecorderIntegrationService.loadHistoricalData(currentUser);
            model.addAttribute("successMessage", (Object)this.getMessage("integrations.owntracks.recorder.load.historical.success", new Object[0]));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("integrations.owntracks.recorder.load.historical.error", new Object[]{e.getMessage()}));
        }
        List tokens = this.apiTokenService.getTokensForUser(currentUser);
        if (!tokens.isEmpty()) {
            model.addAttribute("firstToken", (Object)((ApiToken)tokens.getFirst()).getToken());
            model.addAttribute("hasToken", (Object)true);
        } else {
            model.addAttribute("hasToken", (Object)false);
        }
        model.addAttribute("tokens", (Object)tokens);
        model.addAttribute("serverUrl", (Object)this.calculateServerUrl(request));
        Optional recorderIntegration = this.ownTracksRecorderIntegrationService.getIntegrationForUser(currentUser);
        if (recorderIntegration.isPresent()) {
            model.addAttribute("ownTracksRecorderIntegration", recorderIntegration.get());
            model.addAttribute("hasRecorderIntegration", (Object)((OwnTracksRecorderIntegration)recorderIntegration.get()).isEnabled());
        } else {
            model.addAttribute("hasRecorderIntegration", (Object)false);
        }
        model.addAttribute("openSection", (Object)"external-data-stores");
        return "settings/integrations :: integrations-content";
    }

    @GetMapping(value={"/data-quality-content"})
    public String getDataQualityContent(@AuthenticationPrincipal User user, Model model) {
        try {
            DataQualityReport dataQuality = this.generateDataQualityReport(user);
            model.addAttribute("dataQuality", (Object)dataQuality);
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.getMessage("integrations.data.quality.error", new Object[]{e.getMessage()}));
        }
        return "settings/integrations :: data-quality-content";
    }

    private DataQualityReport generateDataQualityReport(User user) {
        List<Double> accuracies;
        Instant now = Instant.now();
        Instant oneDayAgo = now.minus(24L, ChronoUnit.HOURS);
        Instant sevenDaysAgo = now.minus(7L, ChronoUnit.DAYS);
        List allPoints = this.rawLocationPointJdbcService.findByUserAndTimestampBetweenOrderByTimestampAsc(user, sevenDaysAgo, now);
        List<RawLocationPoint> last24hPoints = allPoints.stream().filter(point -> point.getTimestamp().isAfter(oneDayAgo)).toList();
        long totalPoints = this.rawLocationPointJdbcService.countByUser(user);
        int pointsLast24h = last24hPoints.size();
        int pointsLast7d = allPoints.size();
        int avgPointsPerDay = pointsLast7d > 0 ? pointsLast7d / 7 : 0;
        String latestPointTime = null;
        String timeSinceLastPoint = null;
        if (!allPoints.isEmpty()) {
            RawLocationPoint latestPoint = (RawLocationPoint)allPoints.getLast();
            latestPointTime = latestPoint.getTimestamp().toString();
            long minutesSince = Duration.between(latestPoint.getTimestamp(), now).toMinutes();
            timeSinceLastPoint = minutesSince < 60L ? minutesSince + " minutes ago" : (minutesSince < 1440L ? minutesSince / 60L + " hours ago" : minutesSince / 1440L + " days ago");
        }
        Double avgAccuracy = null;
        Integer goodAccuracyPercentage = null;
        if (!allPoints.isEmpty() && !(accuracies = allPoints.stream().map(RawLocationPoint::getAccuracyMeters).filter(Objects::nonNull).toList()).isEmpty()) {
            avgAccuracy = accuracies.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
            long goodAccuracyCount = accuracies.stream().filter(acc -> acc < 50.0).count();
            goodAccuracyPercentage = (int)(goodAccuracyCount * 100L / (long)accuracies.size());
        }
        String avgInterval = null;
        long avgIntervalSeconds = -1L;
        boolean hasFluctuatingFrequency = false;
        if (last24hPoints.size() > 1) {
            avgIntervalSeconds = 86400 / last24hPoints.size();
            avgInterval = avgIntervalSeconds < 60L ? avgIntervalSeconds + " seconds" : (avgIntervalSeconds < 3600L ? avgIntervalSeconds / 60L + " minutes" : avgIntervalSeconds / 3600L + " hours");
        }
        if (last24hPoints.size() > 2) {
            ArrayList<Long> last24hIntervals = new ArrayList<Long>();
            long totalLast24hIntervalSeconds = 0L;
            for (int i = 1; i < last24hPoints.size(); ++i) {
                long intervalSeconds = Duration.between(last24hPoints.get(i - 1).getTimestamp(), last24hPoints.get(i).getTimestamp()).getSeconds();
                last24hIntervals.add(intervalSeconds);
                totalLast24hIntervalSeconds += intervalSeconds;
            }
            if (!last24hIntervals.isEmpty()) {
                long avgLast24hIntervalSeconds = totalLast24hIntervalSeconds / (long)last24hIntervals.size();
                if (last24hIntervals.size() > 2) {
                    double variance = last24hIntervals.stream().mapToDouble(interval -> Math.pow(interval - avgLast24hIntervalSeconds, 2.0)).average().orElse(0.0);
                    double stdDev = Math.sqrt(variance);
                    double coefficientOfVariation = avgLast24hIntervalSeconds > 0L ? stdDev / (double)avgLast24hIntervalSeconds : 0.0;
                    hasFluctuatingFrequency = coefficientOfVariation > 10.0;
                }
            }
        }
        boolean isActivelyTracking = pointsLast24h > 0;
        int recommendedFrequency = 75;
        boolean hasGoodFrequency = avgIntervalSeconds < (long)recommendedFrequency;
        ArrayList<String> recommendations = new ArrayList<String>();
        if (!isActivelyTracking) {
            recommendations.add(this.getMessage("integrations.data.quality.recommendation.no.data", new Object[0]));
        }
        if (avgIntervalSeconds > (long)recommendedFrequency) {
            recommendations.add(this.getMessage("integrations.data.quality.recommendation.low.frequency", new Object[0]));
        }
        if (goodAccuracyPercentage != null && goodAccuracyPercentage < 70) {
            recommendations.add(this.getMessage("integrations.data.quality.recommendation.poor.accuracy", new Object[0]));
        }
        if (avgAccuracy != null && avgAccuracy > 100.0) {
            recommendations.add(this.getMessage("integrations.data.quality.recommendation.very.poor.accuracy", new Object[0]));
        }
        if (hasFluctuatingFrequency) {
            recommendations.add(this.getMessage("integrations.data.quality.recommendation.fluctuating.frequency", new Object[0]));
        }
        return new DataQualityReport(totalPoints, pointsLast24h, pointsLast7d, avgPointsPerDay, latestPointTime, timeSinceLastPoint, avgAccuracy, goodAccuracyPercentage, avgInterval, isActivelyTracking, hasGoodFrequency, hasFluctuatingFrequency, recommendations);
    }

    private String getMessage(String key, Object ... args) {
        return this.messageSource.getMessage(key, args, LocaleContextHolder.getLocale());
    }
}

