/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.logging.LoggingService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Controller
@RequestMapping(value={"/settings/logging"})
public class LoggingController {
    private final LoggingService loggingService;
    private final boolean dataManagementEnabled;

    public LoggingController(LoggingService loggingService, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.loggingService = loggingService;
        this.dataManagementEnabled = dataManagementEnabled;
    }

    @GetMapping
    public String loggingPage(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("activeSection", (Object)"logging");
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("currentBufferSize", (Object)this.loggingService.getCurrentBufferSize());
        model.addAttribute("maxBufferSize", (Object)this.loggingService.getMaxBufferSize());
        model.addAttribute("currentLogLevel", (Object)this.loggingService.getCurrentLogLevel());
        model.addAttribute("configuredLoggers", (Object)this.loggingService.getAllConfiguredLoggers());
        return "settings/logging";
    }

    @GetMapping(value={"/stream"}, produces={"text/event-stream"})
    public SseEmitter streamLogs() {
        return this.loggingService.createLogStream();
    }

    @PostMapping(value={"/update"})
    public String updateLoggingSettings(@RequestParam(value="logger") String logger, @RequestParam(value="level") String level, @RequestParam(value="size") int size, @AuthenticationPrincipal User user, Model model) {
        try {
            String loggerName = logger == null || logger.trim().isEmpty() ? "ROOT" : logger.trim();
            this.loggingService.setLoggerLevel(loggerName, level);
            this.loggingService.setBufferSize(size);
            model.addAttribute("currentBufferSize", (Object)this.loggingService.getCurrentBufferSize());
            model.addAttribute("maxBufferSize", (Object)this.loggingService.getMaxBufferSize());
            model.addAttribute("currentLogLevel", (Object)this.loggingService.getCurrentLogLevel());
            model.addAttribute("configuredLoggers", (Object)this.loggingService.getAllConfiguredLoggers());
            return "settings/logging :: logging-settings-card";
        }
        catch (Exception e) {
            model.addAttribute("error", (Object)("Error updating logging settings: " + e.getMessage()));
            model.addAttribute("currentBufferSize", (Object)this.loggingService.getCurrentBufferSize());
            model.addAttribute("maxBufferSize", (Object)this.loggingService.getMaxBufferSize());
            model.addAttribute("currentLogLevel", (Object)this.loggingService.getCurrentLogLevel());
            model.addAttribute("configuredLoggers", (Object)this.loggingService.getAllConfiguredLoggers());
            return "settings/logging :: logging-settings-card";
        }
    }

    @PostMapping(value={"/remove"})
    public String removeLogger(@RequestParam(value="logger") String logger, @AuthenticationPrincipal User user, Model model) {
        try {
            this.loggingService.removeLogger(logger);
            model.addAttribute("currentBufferSize", (Object)this.loggingService.getCurrentBufferSize());
            model.addAttribute("maxBufferSize", (Object)this.loggingService.getMaxBufferSize());
            model.addAttribute("currentLogLevel", (Object)this.loggingService.getCurrentLogLevel());
            model.addAttribute("configuredLoggers", (Object)this.loggingService.getAllConfiguredLoggers());
            return "settings/logging :: logging-settings-card";
        }
        catch (Exception e) {
            model.addAttribute("error", (Object)("Error removing logger: " + e.getMessage()));
            model.addAttribute("currentBufferSize", (Object)this.loggingService.getCurrentBufferSize());
            model.addAttribute("maxBufferSize", (Object)this.loggingService.getMaxBufferSize());
            model.addAttribute("currentLogLevel", (Object)this.loggingService.getCurrentLogLevel());
            model.addAttribute("configuredLoggers", (Object)this.loggingService.getAllConfiguredLoggers());
            return "settings/logging :: logging-settings-card";
        }
    }
}

