/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.processing.ProcessingPipelineTrigger;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ManageDataController {
    private final boolean dataManagementEnabled;
    private final boolean deleteAllHostnameVerificationEnabled;
    private final TripJdbcService tripJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final ProcessingPipelineTrigger processingPipelineTrigger;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final I18nService i18n;

    public ManageDataController(@Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled, @Value(value="${reitti.data-management.delete-all.hostname-verification.enabled:true}") boolean deleteAllHostnameVerificationEnabled, TripJdbcService tripJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, ProcessingPipelineTrigger processingPipelineTrigger, RawLocationPointJdbcService rawLocationPointJdbcService, UserSettingsJdbcService userSettingsJdbcService, I18nService i18nService) {
        this.dataManagementEnabled = dataManagementEnabled;
        this.deleteAllHostnameVerificationEnabled = deleteAllHostnameVerificationEnabled;
        this.tripJdbcService = tripJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.processingPipelineTrigger = processingPipelineTrigger;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.i18n = i18nService;
    }

    @GetMapping(value={"/settings/manage-data"})
    public String getPage(@AuthenticationPrincipal User user, Model model, HttpServletRequest request) {
        if (!this.dataManagementEnabled) {
            throw new RuntimeException("Data management is not enabled");
        }
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("activeSection", (Object)"manage-data");
        model.addAttribute("dataManagementEnabled", (Object)true);
        model.addAttribute("deleteAllRequiresVerification", (Object)this.deleteAllHostnameVerificationEnabled);
        if (this.deleteAllHostnameVerificationEnabled) {
            model.addAttribute("serverHostname", (Object)request.getServerName());
        }
        return "settings/manage-data";
    }

    @GetMapping(value={"/settings/manage-data-content"})
    public String getManageDataContent(HttpServletRequest request, Model model) {
        if (!this.dataManagementEnabled) {
            throw new RuntimeException("Data management is not enabled");
        }
        model.addAttribute("deleteAllRequiresVerification", (Object)this.deleteAllHostnameVerificationEnabled);
        if (this.deleteAllHostnameVerificationEnabled) {
            model.addAttribute("serverHostname", (Object)request.getServerName());
        }
        return "settings/manage-data :: manage-data-content";
    }

    @PostMapping(value={"/settings/manage-data/process-visits-trips"})
    public String processVisitsTrips(Model model) {
        if (!this.dataManagementEnabled) {
            throw new RuntimeException("Data management is not enabled");
        }
        try {
            this.processingPipelineTrigger.start();
            model.addAttribute("successMessage", (Object)this.i18n.translate("data.process.success"));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18n.translate("data.process.error", new Object[]{e.getMessage()}));
        }
        return "settings/manage-data :: manage-data-content";
    }

    @PostMapping(value={"/settings/manage-data/clear-and-reprocess"})
    public String clearAndReprocess(@AuthenticationPrincipal User user, Model model) {
        if (!this.dataManagementEnabled) {
            throw new RuntimeException("Data management is not enabled");
        }
        try {
            this.clearProcessedDataExceptPlaces(user);
            this.markRawLocationPointsAsUnprocessed(user);
            this.processingPipelineTrigger.start();
            model.addAttribute("successMessage", (Object)this.i18n.translate("data.clear.reprocess.success"));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18n.translate("data.clear.reprocess.error", new Object[]{e.getMessage()}));
        }
        return "settings/manage-data :: manage-data-content";
    }

    @PostMapping(value={"/settings/manage-data/remove-all-data"})
    public String removeAllData(@AuthenticationPrincipal User user, Model model, HttpServletRequest request, @RequestParam(value="hostname", required=false) String hostname) {
        if (!this.dataManagementEnabled) {
            throw new RuntimeException("Data management is not enabled");
        }
        if (this.deleteAllHostnameVerificationEnabled) {
            String expectedHostname = request.getServerName();
            if (hostname == null || !hostname.trim().equals(expectedHostname)) {
                model.addAttribute("errorMessage", (Object)this.i18n.translate("data.remove.all.error.hostname-verification", new Object[]{expectedHostname}));
                model.addAttribute("deleteAllRequiresVerification", (Object)true);
                model.addAttribute("serverHostname", (Object)expectedHostname);
                return "settings/manage-data :: manage-data-content";
            }
        }
        try {
            this.removeAllDataExceptPlaces(user);
            model.addAttribute("successMessage", (Object)this.i18n.translate("data.remove.all.success"));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18n.translate("data.remove.all.error", new Object[]{e.getMessage()}));
        }
        model.addAttribute("deleteAllRequiresVerification", (Object)this.deleteAllHostnameVerificationEnabled);
        if (this.deleteAllHostnameVerificationEnabled) {
            model.addAttribute("serverHostname", (Object)request.getServerName());
        }
        return "settings/manage-data :: manage-data-content";
    }

    private void clearProcessedDataExceptPlaces(User user) {
        this.tripJdbcService.deleteAllForUser(user);
        this.processedVisitJdbcService.deleteAllForUser(user);
    }

    private void markRawLocationPointsAsUnprocessed(User user) {
        this.rawLocationPointJdbcService.markAllAsUnprocessedForUser(user);
    }

    private void removeAllDataExceptPlaces(User user) {
        this.userSettingsJdbcService.deleteNewestData(user);
        this.tripJdbcService.deleteAllForUser(user);
        this.processedVisitJdbcService.deleteAllForUser(user);
        this.rawLocationPointJdbcService.deleteAllForUser(user);
    }
}

