/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.controller.settings.PlacesSettingsController;
import com.dedicatedcode.reitti.dto.PlaceInfo;
import com.dedicatedcode.reitti.event.SignificantPlaceCreatedEvent;
import com.dedicatedcode.reitti.model.AvailableCountry;
import com.dedicatedcode.reitti.model.Page;
import com.dedicatedcode.reitti.model.PageRequest;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.geo.GeoPoint;
import com.dedicatedcode.reitti.model.geo.GeoUtils;
import com.dedicatedcode.reitti.model.geo.SignificantPlace;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.GeocodingResponseJdbcService;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceOverrideJdbcService;
import com.dedicatedcode.reitti.service.DataCleanupService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.PlaceChangeDetectionService;
import com.dedicatedcode.reitti.service.PlaceService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/settings/places"})
public class PlacesSettingsController {
    private static final Logger log = LoggerFactory.getLogger(PlacesSettingsController.class);
    private final PlaceService placeService;
    private final SignificantPlaceJdbcService placeJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final SignificantPlaceOverrideJdbcService significantPlaceOverrideJdbcService;
    private final GeocodingResponseJdbcService geocodingResponseJdbcService;
    private final RabbitTemplate rabbitTemplate;
    private final GeometryFactory geometryFactory;
    private final I18nService i18nService;
    private final PlaceChangeDetectionService placeChangeDetectionService;
    private final DataCleanupService dataCleanupService;
    private final boolean dataManagementEnabled;
    private final ObjectMapper objectMapper;

    public PlacesSettingsController(PlaceService placeService, SignificantPlaceJdbcService placeJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, SignificantPlaceOverrideJdbcService significantPlaceOverrideJdbcService, GeocodingResponseJdbcService geocodingResponseJdbcService, RabbitTemplate rabbitTemplate, GeometryFactory geometryFactory, I18nService i18nService, PlaceChangeDetectionService placeChangeDetectionService, DataCleanupService dataCleanupService, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled, ObjectMapper objectMapper) {
        this.placeService = placeService;
        this.placeJdbcService = placeJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.significantPlaceOverrideJdbcService = significantPlaceOverrideJdbcService;
        this.geocodingResponseJdbcService = geocodingResponseJdbcService;
        this.rabbitTemplate = rabbitTemplate;
        this.geometryFactory = geometryFactory;
        this.i18nService = i18nService;
        this.placeChangeDetectionService = placeChangeDetectionService;
        this.dataCleanupService = dataCleanupService;
        this.dataManagementEnabled = dataManagementEnabled;
        this.objectMapper = objectMapper;
    }

    @GetMapping
    public String getPage(@AuthenticationPrincipal User user, Model model, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="") String search) {
        model.addAttribute("activeSection", (Object)"places");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        this.getPlacesContent(user, page, search, model);
        return "settings/places";
    }

    @GetMapping(value={"/places-content"})
    public String getPlacesContent(@AuthenticationPrincipal User user, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="") String search, Model model) {
        Page placesPage = this.placeService.getPlacesForUser(user, PageRequest.of((int)page, (int)20), search);
        List places = placesPage.getContent().stream().map(PlacesSettingsController::convertToPlaceInfo).collect(Collectors.toList());
        model.addAttribute("currentPage", (Object)placesPage.getNumber());
        model.addAttribute("totalPages", (Object)placesPage.getTotalPages());
        model.addAttribute("places", places);
        model.addAttribute("isEmpty", (Object)places.isEmpty());
        model.addAttribute("placeTypes", (Object)SignificantPlace.PlaceType.values());
        model.addAttribute("search", (Object)search);
        model.addAttribute("returnUrl", (Object)("/settings/places?search=" + search + "&page=" + page));
        return "settings/places :: places-content";
    }

    @PostMapping(value={"/{placeId}/check-update"})
    @ResponseBody
    public CheckUpdateResponse checkUpdate(@PathVariable Long placeId, @RequestParam(required=false) String polygonData, Authentication authentication) {
        User user = (User)authentication.getPrincipal();
        if (!this.placeJdbcService.exists(user, placeId)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        PlaceChangeDetectionService.PlaceChangeAnalysis analysis = this.placeChangeDetectionService.analyzeChanges(user, placeId, polygonData);
        return new CheckUpdateResponse(analysis.isCanProceed(), analysis.getWarnings());
    }

    @PostMapping(value={"/{placeId}/update"})
    public String updatePlace(@PathVariable Long placeId, @RequestParam String name, @RequestParam(required=false) String address, @RequestParam(required=false) String city, @RequestParam(required=false) String countryCode, @RequestParam(required=false) String type, @RequestParam(required=false) String polygonData, @RequestParam(required=false) String returnUrl, Authentication authentication, Model model) {
        User user = (User)authentication.getPrincipal();
        if (this.placeJdbcService.exists(user, placeId)) {
            try {
                SignificantPlace significantPlace = (SignificantPlace)this.placeJdbcService.findById(placeId).orElseThrow();
                SignificantPlace updatedPlace = significantPlace.withName(name);
                if (address != null) {
                    updatedPlace = updatedPlace.withAddress(address.trim().isEmpty() ? null : address.trim());
                }
                if (city != null) {
                    updatedPlace = updatedPlace.withCity(city.trim().isEmpty() ? null : city.trim());
                }
                if (countryCode != null) {
                    updatedPlace = updatedPlace.withCountryCode(countryCode.trim().isEmpty() ? null : countryCode.trim());
                }
                if (type != null && !type.isEmpty()) {
                    try {
                        SignificantPlace.PlaceType placeType = SignificantPlace.PlaceType.valueOf((String)type);
                        updatedPlace = updatedPlace.withType(placeType);
                    }
                    catch (IllegalArgumentException e) {
                        model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.place.update", new Object[]{"Invalid place type"}));
                        return this.editPolygon(placeId, returnUrl, authentication, model);
                    }
                }
                if (polygonData != null && !polygonData.trim().isEmpty()) {
                    try {
                        List polygon = this.parsePolygonData(polygonData);
                        updatedPlace = updatedPlace.withPolygon(polygon);
                        GeoPoint centroid = GeoUtils.calculatePolygonCentroid((List)polygon);
                        updatedPlace = updatedPlace.withLatitudeCentroid(Double.valueOf(centroid.latitude())).withLongitudeCentroid(Double.valueOf(centroid.longitude()));
                    }
                    catch (Exception e) {
                        model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.place.update", new Object[]{"Invalid polygon data: " + e.getMessage()}));
                        return this.editPolygon(placeId, returnUrl, authentication, model);
                    }
                } else {
                    updatedPlace = updatedPlace.withPolygon(null);
                }
                if (!this.placeChangeDetectionService.analyzeChanges(user, placeId, polygonData).isCanProceed()) {
                    this.placeJdbcService.update(updatedPlace);
                    log.info("Significant change detected for place [{}]. Will issue a recalculation of all affected dates", (Object)significantPlace);
                    List placesToRemove = this.placeJdbcService.findPlacesOverlappingWithPolygon(user.getId(), placeId, updatedPlace.getPolygon());
                    ArrayList<SignificantPlace> placesToCheck = new ArrayList<SignificantPlace>(placesToRemove);
                    placesToCheck.add(updatedPlace);
                    List affectedDays = this.processedVisitJdbcService.getAffectedDays(placesToCheck);
                    this.dataCleanupService.cleanupForGeometryChange(user, placesToRemove, affectedDays);
                } else {
                    this.placeJdbcService.update(updatedPlace);
                }
                this.significantPlaceOverrideJdbcService.insertOverride(user, updatedPlace);
                return "redirect:" + returnUrl;
            }
            catch (Exception e) {
                model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.place.update", new Object[]{e.getMessage()}));
                return this.editPolygon(placeId, returnUrl, authentication, model);
            }
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
    }

    @PostMapping(value={"/{placeId}/geocode"})
    public String geocodePlace(@PathVariable Long placeId, @RequestParam(required=false) String returnUrl, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="") String search, Authentication authentication, RedirectAttributes redirectAttributes) {
        User user = (User)authentication.getPrincipal();
        if (this.placeJdbcService.exists(user, placeId)) {
            try {
                SignificantPlace significantPlace = (SignificantPlace)this.placeJdbcService.findById(placeId).orElseThrow();
                SignificantPlace clearedPlace = significantPlace.withGeocoded(false).withAddress(null);
                this.placeJdbcService.update(clearedPlace);
                this.significantPlaceOverrideJdbcService.clear(user, clearedPlace);
                SignificantPlaceCreatedEvent event = new SignificantPlaceCreatedEvent(user.getUsername(), null, significantPlace.getId(), significantPlace.getLatitudeCentroid(), significantPlace.getLongitudeCentroid(), UUID.randomUUID().toString());
                this.rabbitTemplate.convertAndSend("reitti-exchange", "reitti.place.created.v2", (Object)event);
                redirectAttributes.addFlashAttribute("successMessage", (Object)this.i18nService.translate("places.geocode.success", new Object[0]));
            }
            catch (Exception e) {
                redirectAttributes.addFlashAttribute("errorMessage", (Object)this.i18nService.translate("places.geocode.error", new Object[]{e.getMessage()}));
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        String redirectUrl = returnUrl != null ? returnUrl : "/settings/places?page=" + page + "&search=" + search;
        return "redirect:" + redirectUrl;
    }

    @GetMapping(value={"/{placeId}/geocoding-response"})
    public String getGeocodingResponse(@PathVariable Long placeId, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="") String search, @RequestParam(defaultValue="places") String context, Authentication authentication, Model model) {
        User user = (User)authentication.getPrincipal();
        if (!this.placeJdbcService.exists(user, placeId)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            SignificantPlace place = (SignificantPlace)this.placeJdbcService.findById(placeId).orElseThrow();
            PlaceInfo placeInfo = PlacesSettingsController.convertToPlaceInfo((SignificantPlace)place);
            List geocodingResponses = this.geocodingResponseJdbcService.findBySignificantPlace(place);
            model.addAttribute("place", (Object)placeInfo);
            model.addAttribute("currentPage", (Object)page);
            model.addAttribute("search", (Object)search);
            model.addAttribute("context", (Object)context);
            model.addAttribute("geocodingResponses", (Object)geocodingResponses);
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.place.update", new Object[]{e.getMessage()}));
            return this.getPlacesContent(user, page, search, model);
        }
        return "fragments/places :: geocoding-response-content";
    }

    @GetMapping(value={"/{placeId}/edit"})
    public String editPolygon(@PathVariable Long placeId, @RequestParam(required=false) String returnUrl, Authentication authentication, Model model) {
        User user = (User)authentication.getPrincipal();
        if (!this.placeJdbcService.exists(user, placeId)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            SignificantPlace place = (SignificantPlace)this.placeJdbcService.findById(placeId).orElseThrow();
            PlaceInfo placeInfo = PlacesSettingsController.convertToPlaceInfo((SignificantPlace)place);
            model.addAttribute("place", (Object)placeInfo);
            model.addAttribute("placeTypes", (Object)SignificantPlace.PlaceType.values());
            model.addAttribute("returnUrl", (Object)returnUrl);
            Point point = this.geometryFactory.createPoint(new Coordinate(place.getLongitudeCentroid().doubleValue(), place.getLatitudeCentroid().doubleValue()));
            List<PlaceInfo> nearbyPlaces = this.placeJdbcService.findNearbyPlaces(user.getId(), point, 0.019).stream().map(PlacesSettingsController::convertToPlaceInfo).toList();
            model.addAttribute("availableCountries", (Object)AvailableCountry.values());
            model.addAttribute("nearbyPlaces", nearbyPlaces);
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.place.update", new Object[]{e.getMessage()}));
            return "redirect:/settings/places";
        }
        return "settings/edit-place";
    }

    private static PlaceInfo convertToPlaceInfo(SignificantPlace place) {
        return new PlaceInfo(place.getId(), place.getName(), place.getAddress(), place.getCity(), place.getCountryCode(), place.getLatitudeCentroid(), place.getLongitudeCentroid(), place.getType(), place.getPolygon());
    }

    private List<GeoPoint> parsePolygonData(String polygonData) throws Exception {
        JsonNode jsonNode = this.objectMapper.readTree(polygonData);
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        if (jsonNode.isArray()) {
            for (JsonNode pointNode : jsonNode) {
                if (pointNode.has("lat") && pointNode.has("lng")) {
                    double lat = pointNode.get("lat").asDouble();
                    double lng = pointNode.get("lng").asDouble();
                    geoPoints.add(new GeoPoint(lat, lng));
                    continue;
                }
                throw new IllegalArgumentException("Each point must have 'lat' and 'lng' properties");
            }
        } else {
            throw new IllegalArgumentException("Polygon data must be an array of coordinate objects");
        }
        if (geoPoints.size() < 3) {
            throw new IllegalArgumentException("Polygon must have at least 3 points");
        }
        return geoPoints;
    }
}

