/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.dto.ReittiRemoteInfo;
import com.dedicatedcode.reitti.model.integration.ReittiIntegration;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.OptimisticLockException;
import com.dedicatedcode.reitti.repository.ReittiIntegrationJdbcService;
import com.dedicatedcode.reitti.service.RequestFailedException;
import com.dedicatedcode.reitti.service.RequestTemporaryFailedException;
import com.dedicatedcode.reitti.service.integration.ReittiIntegrationService;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/settings/integrations"})
public class ReittiIntegrationSettingsController {
    private final ReittiIntegrationJdbcService jdbcService;
    private final ReittiIntegrationService reittiIntegrationService;

    public ReittiIntegrationSettingsController(ReittiIntegrationJdbcService jdbcService, ReittiIntegrationService reittiIntegrationService) {
        this.jdbcService = jdbcService;
        this.reittiIntegrationService = reittiIntegrationService;
    }

    @GetMapping(value={"/shared-instances-content"})
    public String getSharedInstancesContent(@AuthenticationPrincipal User user, Model model) {
        List integrations = this.jdbcService.findAllByUser(user);
        model.addAttribute("reittiIntegrations", (Object)integrations);
        return "fragments/shared-instances :: shared-instances-content";
    }

    @PostMapping(value={"/reitti-integrations"})
    public String createReittiIntegration(@AuthenticationPrincipal User user, @RequestParam String url, @RequestParam(name="remote_token") String token, @RequestParam(defaultValue="false") boolean enabled, @RequestParam(defaultValue="#3498db") String color, Model model) {
        try {
            this.jdbcService.create(user, ReittiIntegration.create((String)url, (String)token, (boolean)enabled, (String)color));
            model.addAttribute("successMessage", (Object)"Reitti integration saved successfully");
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)("Error saving configuration: " + e.getMessage()));
        }
        return this.getSharedInstancesContent(user, model);
    }

    @PostMapping(value={"/reitti-integrations/{id}/update"})
    public String updateReittiIntegration(@AuthenticationPrincipal User user, @PathVariable Long id, @RequestParam String url, @RequestParam(name="remote_token") String token, @RequestParam(defaultValue="false") boolean enabled, @RequestParam(defaultValue="#3498db") String color, @RequestParam Long version, Model model) {
        try {
            this.jdbcService.findByIdAndUser(id, user).ifPresentOrElse(integration -> {
                try {
                    ReittiIntegration updatedIntegration = new ReittiIntegration(integration.getId(), url, token, enabled, enabled ? ReittiIntegration.Status.ACTIVE : ReittiIntegration.Status.RECOVERABLE, integration.getCreatedAt(), integration.getUpdatedAt(), (LocalDateTime)integration.getLastUsed().orElse(null), version, (String)integration.getLastMessage().orElse(null), color);
                    this.jdbcService.update(updatedIntegration);
                    model.addAttribute("successMessage", (Object)"Reitti integration updated successfully");
                }
                catch (OptimisticLockException e) {
                    model.addAttribute("errorMessage", (Object)"Integration is out of date. Please reload the page and try again.");
                }
                catch (Exception e) {
                    model.addAttribute("errorMessage", (Object)("Error updating configuration: " + e.getMessage()));
                }
            }, () -> model.addAttribute("errorMessage", (Object)"Integration not found!"));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)("Error updating configuration: " + e.getMessage()));
        }
        return this.getSharedInstancesContent(user, model);
    }

    @PostMapping(value={"/reitti-integrations/{id}/toggle"})
    public String toggleReittiIntegration(@AuthenticationPrincipal User user, @PathVariable Long id, Model model) {
        try {
            this.jdbcService.findByIdAndUser(id, user).ifPresentOrElse(integration -> {
                try {
                    ReittiIntegration updated = integration.withEnabled(!integration.isEnabled());
                    updated = !updated.isEnabled() ? updated.withStatus(ReittiIntegration.Status.DISABLED) : updated.withStatus(ReittiIntegration.Status.ACTIVE);
                    this.jdbcService.update(updated);
                    model.addAttribute("successMessage", (Object)"Integration status updated successfully");
                }
                catch (OptimisticLockException e) {
                    model.addAttribute("errorMessage", (Object)"Integration is out of date. Please reload the page and try again.");
                }
                catch (Exception e) {
                    model.addAttribute("errorMessage", (Object)("Error updating integration: " + e.getMessage()));
                }
            }, () -> model.addAttribute("errorMessage", (Object)"Integration not found!"));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)("Error updating integration: " + e.getMessage()));
        }
        return this.getSharedInstancesContent(user, model);
    }

    @PostMapping(value={"/reitti-integrations/{id}/delete"})
    public String deleteReittiIntegration(@AuthenticationPrincipal User user, @PathVariable Long id, Model model) {
        try {
            this.jdbcService.findByIdAndUser(id, user).ifPresent(integration -> {
                try {
                    this.jdbcService.delete(integration);
                }
                catch (OptimisticLockException e) {
                    model.addAttribute("errorMessage", (Object)"Integration is out of date. Please reload the page and try again.");
                }
            });
            model.addAttribute("successMessage", (Object)"Reitti integration deleted successfully");
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)("Error deleting configuration: " + e.getMessage()));
        }
        return this.getSharedInstancesContent(user, model);
    }

    @GetMapping(value={"/reitti-integrations/{id}/info"})
    public String getReittiIntegrationInfo(@AuthenticationPrincipal User user, @PathVariable Long id, Model model) {
        try {
            this.jdbcService.findByIdAndUser(id, user).ifPresentOrElse(integration -> {
                try {
                    model.addAttribute("remoteInfo", (Object)this.reittiIntegrationService.getInfo(integration));
                }
                catch (Exception e) {
                    model.addAttribute("errorMessage", (Object)("Connection failed: " + e.getMessage()));
                }
                catch (RequestFailedException | RequestTemporaryFailedException e) {
                    model.addAttribute("errorMessage", (Object)"Failed to fetch information from remote instance");
                }
            }, () -> model.addAttribute("errorMessage", (Object)"Integration not found"));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)("Error fetching integration info: " + e.getMessage()));
        }
        return "fragments/shared-instances :: reitti-info-content";
    }

    @PostMapping(value={"/reitti-integrations/test"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> testReittiConnection(@RequestParam String url, @RequestParam(name="foreign_token") String token) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            ReittiRemoteInfo info = this.reittiIntegrationService.getInfo(url, token);
            response.put("success", true);
            response.put("message", "Connection successful - Connected to Reitti instance");
            response.put("remoteInfo", info);
        }
        catch (RequestFailedException | RequestTemporaryFailedException e) {
            response.put("success", false);
            response.put("message", "Connection failed: Invalid response from remote instance");
        }
        catch (Exception e) {
            response.put("success", false);
            response.put("message", "Connection failed: " + e.getMessage());
        }
        return ResponseEntity.ok(response);
    }
}

