/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.service.QueueStatsService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/settings"})
public class SettingsController {
    private final QueueStatsService queueStatsService;
    private final boolean dataManagementEnabled;

    public SettingsController(QueueStatsService queueStatsService, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.queueStatsService = queueStatsService;
        this.dataManagementEnabled = dataManagementEnabled;
    }

    @GetMapping
    public String settingsPage() {
        return "redirect:/settings/job-status";
    }

    @GetMapping(value={"/job-status"})
    public String getJobStatus(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("activeSection", (Object)"job-status");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("queueStats", (Object)this.queueStatsService.getQueueStats());
        return "settings/job-status";
    }

    @GetMapping(value={"/queue-stats-content"})
    public String getQueueStatsContent(Model model) {
        model.addAttribute("queueStats", (Object)this.queueStatsService.getQueueStats());
        return "settings/job-status :: queue-stats-content";
    }
}

