/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.dto.ConfigurationForm;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.processing.DetectionParameter;
import com.dedicatedcode.reitti.model.processing.RecalculationState;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.repository.ProcessedVisitJdbcService;
import com.dedicatedcode.reitti.repository.RawLocationPointJdbcService;
import com.dedicatedcode.reitti.repository.SignificantPlaceJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.repository.VisitDetectionParametersJdbcService;
import com.dedicatedcode.reitti.service.VisitDetectionPreviewService;
import com.dedicatedcode.reitti.service.processing.ProcessingPipelineTrigger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.SequencedCollection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/settings/visit-sensitivity"})
public class SettingsVisitSensitivityController {
    private static final Logger log = LoggerFactory.getLogger(SettingsVisitSensitivityController.class);
    private final VisitDetectionParametersJdbcService configurationService;
    private final VisitDetectionPreviewService visitDetectionPreviewService;
    private final ProcessingPipelineTrigger processingPipelineTrigger;
    private final TripJdbcService tripJdbcService;
    private final ProcessedVisitJdbcService processedVisitJdbcService;
    private final MessageSource messageSource;
    private final boolean dataManagementEnabled;
    private final RawLocationPointJdbcService rawLocationPointJdbcService;
    private final SignificantPlaceJdbcService significantPlaceJdbcService;

    public SettingsVisitSensitivityController(VisitDetectionParametersJdbcService configurationService, VisitDetectionPreviewService visitDetectionPreviewService, ProcessingPipelineTrigger processingPipelineTrigger, TripJdbcService tripJdbcService, ProcessedVisitJdbcService processedVisitJdbcService, MessageSource messageSource, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled, RawLocationPointJdbcService rawLocationPointJdbcService, SignificantPlaceJdbcService significantPlaceJdbcService) {
        this.configurationService = configurationService;
        this.visitDetectionPreviewService = visitDetectionPreviewService;
        this.processingPipelineTrigger = processingPipelineTrigger;
        this.tripJdbcService = tripJdbcService;
        this.processedVisitJdbcService = processedVisitJdbcService;
        this.messageSource = messageSource;
        this.dataManagementEnabled = dataManagementEnabled;
        this.rawLocationPointJdbcService = rawLocationPointJdbcService;
        this.significantPlaceJdbcService = significantPlaceJdbcService;
    }

    @GetMapping
    public String visitSensitivitySettings(@AuthenticationPrincipal User user, Model model) {
        List detectionParameters = this.configurationService.findAllConfigurationsForUser(user);
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("configurations", (Object)detectionParameters);
        model.addAttribute("activeSection", (Object)"visit-sensitivity");
        model.addAttribute("recalculationAdvised", (Object)detectionParameters.stream().anyMatch(arg_0 -> this.calculateNeedsConfiguration(arg_0)));
        return "settings/visit-sensitivity";
    }

    @GetMapping(value={"/edit/{id}"})
    public String editConfiguration(@PathVariable Long id, @RequestParam(required=false, name="new-mode") String mode, @RequestParam(required=false, defaultValue="UTC") String timezone, @RequestParam(required=false) Integer sensitivityLevel, @AuthenticationPrincipal User user, Model model) {
        String effectiveMode;
        ZoneId userTimezone = ZoneId.of(timezone);
        DetectionParameter config = (DetectionParameter)this.configurationService.findById(id, user).orElseThrow(() -> new IllegalArgumentException("Configuration not found"));
        ConfigurationForm form = ConfigurationForm.fromConfiguration((DetectionParameter)config, (ZoneId)userTimezone);
        String string = effectiveMode = mode != null ? mode : form.getMode();
        if (sensitivityLevel != null && "advanced".equals(effectiveMode)) {
            form.applySensitivityLevel(sensitivityLevel);
        }
        model.addAttribute("configurationForm", (Object)form);
        model.addAttribute("mode", (Object)effectiveMode);
        model.addAttribute("isDefaultConfig", (Object)(config.getValidSince() == null ? 1 : 0));
        return "fragments/configuration-form :: configuration-form";
    }

    @GetMapping(value={"/new"})
    public String newConfiguration(@RequestParam(defaultValue="simple", name="new-mode") String mode, @RequestParam(required=false, defaultValue="UTC") String timezone, Model model) {
        ConfigurationForm form = new ConfigurationForm();
        form.setValidSince(Instant.now().atZone(ZoneId.of(timezone)).toLocalDate());
        model.addAttribute("configurationForm", (Object)form);
        model.addAttribute("mode", (Object)mode);
        model.addAttribute("isDefaultConfig", (Object)false);
        return "fragments/configuration-form :: configuration-form";
    }

    @PostMapping(value={"/save"})
    public String saveConfiguration(@ModelAttribute ConfigurationForm form, @RequestParam(required=false, defaultValue="UTC") String timezone, @AuthenticationPrincipal User user, Model model) {
        try {
            DetectionParameter config = form.toConfiguration(ZoneId.of(timezone));
            String validationError = this.validateConfiguration(config, user);
            if (validationError != null) {
                model.addAttribute("errorMessage", (Object)validationError);
            } else {
                if (config.getId() == null) {
                    if (this.rawLocationPointJdbcService.containsDataAfter(user, config.getValidSince())) {
                        config = config.withRecalculationState(RecalculationState.NEEDED);
                    }
                    this.configurationService.saveConfiguration(user, config);
                } else {
                    DetectionParameter originalConfig = (DetectionParameter)this.configurationService.findById(config.getId(), user).orElseThrow(() -> new IllegalArgumentException("Configuration not found"));
                    if (form.hasConfigurationChanged(originalConfig)) {
                        config = config.withRecalculationState(RecalculationState.NEEDED);
                    }
                    this.configurationService.updateConfiguration(config);
                }
                model.addAttribute("successMessage", (Object)"Configuration saved successfully. Changes will apply to new incoming data.");
            }
        }
        catch (Exception e) {
            String errorMessage = this.messageSource.getMessage("visit.sensitivity.validation.save.error", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale());
            model.addAttribute("errorMessage", (Object)errorMessage);
        }
        List detectionParameters = this.configurationService.findAllConfigurationsForUser(user);
        model.addAttribute("configurations", (Object)detectionParameters);
        model.addAttribute("activeSection", (Object)"visit-sensitivity");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("recalculationAdvised", (Object)detectionParameters.stream().anyMatch(arg_0 -> this.calculateNeedsConfiguration(arg_0)));
        return "settings/visit-sensitivity";
    }

    private boolean calculateNeedsConfiguration(DetectionParameter config) {
        return config.getRecalculationState() == RecalculationState.NEEDED;
    }

    @DeleteMapping(value={"/{id}"})
    public String deleteConfiguration(@PathVariable Long id, Authentication auth, Model model) {
        User user = (User)auth.getPrincipal();
        List detectionParameters = this.configurationService.findAllConfigurationsForUser(user);
        DetectionParameter config = detectionParameters.stream().filter(c -> c.getId().equals(id)).findFirst().orElseThrow(() -> new IllegalArgumentException("Configuration not found"));
        if (config.getValidSince() == null) {
            throw new IllegalArgumentException("Cannot delete default configuration");
        }
        this.configurationService.delete(id);
        DetectionParameter newLatest = this.configurationService.findCurrent(user, config.getValidSince());
        if (this.rawLocationPointJdbcService.containsData(user, newLatest.getValidSince(), config.getValidSince())) {
            this.configurationService.updateConfiguration(newLatest.withRecalculationState(RecalculationState.NEEDED));
        }
        detectionParameters = this.configurationService.findAllConfigurationsForUser(user);
        model.addAttribute("configurations", (Object)detectionParameters);
        model.addAttribute("successMessage", (Object)"Configuration deleted successfully.");
        model.addAttribute("activeSection", (Object)"visit-sensitivity");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("recalculationAdvised", (Object)detectionParameters.stream().anyMatch(arg_0 -> this.calculateNeedsConfiguration(arg_0)));
        return "settings/visit-sensitivity";
    }

    @PostMapping(value={"/recalculate"})
    public String startRecalculation(@AuthenticationPrincipal User user, Model model) {
        try {
            this.clearTimeRange(user);
            model.addAttribute("successMessage", (Object)this.messageSource.getMessage("visit.sensitivity.recalculation.started", null, LocaleContextHolder.getLocale()));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.messageSource.getMessage("visit.sensitivity.recalculation.error", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale()));
        }
        List detectionParameters = this.configurationService.findAllConfigurationsForUser(user);
        model.addAttribute("configurations", (Object)detectionParameters);
        model.addAttribute("activeSection", (Object)"visit-sensitivity");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("recalculationAdvised", (Object)detectionParameters.stream().anyMatch(arg_0 -> this.calculateNeedsConfiguration(arg_0)));
        return "settings/visit-sensitivity";
    }

    @PostMapping(value={"/dismiss-recalculation"})
    public String dismissRecalculation(@AuthenticationPrincipal User user, Model model) {
        try {
            this.configurationService.findAllConfigurationsForUser(user).forEach(config -> this.configurationService.updateConfiguration(config.withRecalculationState(RecalculationState.DONE)));
            model.addAttribute("successMessage", (Object)this.messageSource.getMessage("visit.sensitivity.recalculation.dismissed", null, LocaleContextHolder.getLocale()));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.messageSource.getMessage("visit.sensitivity.recalculation.error", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale()));
        }
        List detectionParameters = this.configurationService.findAllConfigurationsForUser(user);
        model.addAttribute("configurations", (Object)detectionParameters);
        model.addAttribute("activeSection", (Object)"visit-sensitivity");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("recalculationAdvised", (Object)detectionParameters.stream().anyMatch(arg_0 -> this.calculateNeedsConfiguration(arg_0)));
        return "settings/visit-sensitivity";
    }

    @PostMapping(value={"/preview"})
    public String previewConfiguration(@ModelAttribute ConfigurationForm form, @RequestParam(required=false, defaultValue="UTC") String timezone, @RequestParam(required=false) String previewDate, @AuthenticationPrincipal User user, Model model) {
        DetectionParameter config = form.toConfiguration(ZoneId.of(timezone));
        Instant date = previewDate != null ? ZonedDateTime.of(LocalDate.parse(previewDate).atStartOfDay(), ZoneId.of(timezone)).toInstant() : Instant.now().truncatedTo(ChronoUnit.DAYS);
        String effectivePreviewDate = previewDate != null ? previewDate : Instant.now().atZone(ZoneId.of(timezone)).toLocalDate().toString();
        String previewId = this.visitDetectionPreviewService.startPreview(user, config, date);
        model.addAttribute("previewConfig", (Object)config);
        model.addAttribute("previewId", (Object)previewId);
        model.addAttribute("previewDate", (Object)effectivePreviewDate);
        model.addAttribute("userId", (Object)user.getId());
        return "fragments/configuration-preview :: configuration-preview";
    }

    private void clearTimeRange(User user) {
        List allConfigurationsForUser = this.configurationService.findAllConfigurationsForUser(user);
        SequencedCollection needsRecalculation = allConfigurationsForUser.stream().filter(dp -> dp.getRecalculationState() == RecalculationState.NEEDED).toList().reversed();
        if (needsRecalculation.isEmpty()) {
            throw new IllegalArgumentException("No configuration needs recalculation");
        }
        needsRecalculation.forEach(dp -> this.configurationService.updateConfiguration(dp.withRecalculationState(RecalculationState.RUNNING)));
        CompletableFuture.runAsync(() -> {
            log.debug("Clearing all time range");
            try {
                this.tripJdbcService.deleteAllForUser(user);
                this.processedVisitJdbcService.deleteAllForUser(user);
                this.significantPlaceJdbcService.deleteForUser(user);
                this.rawLocationPointJdbcService.markAllAsUnprocessedForUser(user);
                allConfigurationsForUser.forEach(config -> this.configurationService.updateConfiguration(config.withRecalculationState(RecalculationState.DONE)));
                log.debug("Starting recalculation of all configurations");
                this.processingPipelineTrigger.start(user);
            }
            catch (Exception e) {
                log.error("Error clearing time range", (Throwable)e);
            }
        });
        log.debug("Recalculation of all configurations triggered");
    }

    private String validateConfiguration(DetectionParameter config, User user) {
        List existingConfigs;
        boolean dateExists;
        if (config.getValidSince() == null) {
            return null;
        }
        if (config.getId() == null ? (dateExists = (existingConfigs = this.configurationService.findAllConfigurationsForUser(user)).stream().anyMatch(existing -> existing.getValidSince() != null && existing.getValidSince().equals(config.getValidSince()))) : (dateExists = (existingConfigs = this.configurationService.findAllConfigurationsForUser(user)).stream().anyMatch(existing -> existing.getValidSince() != null && existing.getValidSince().equals(config.getValidSince()) && !existing.getId().equals(config.getId())))) {
            return this.messageSource.getMessage("visit.sensitivity.validation.date.duplicate", null, LocaleContextHolder.getLocale());
        }
        return null;
    }
}

