/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.controller.settings.ShareAccessController;
import com.dedicatedcode.reitti.dto.UserDto;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.security.MagicLinkAccessLevel;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSharing;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSharingJdbcService;
import com.dedicatedcode.reitti.service.AvatarService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.MagicLinkTokenService;
import com.dedicatedcode.reitti.service.RequestHelper;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/settings/share-access"})
public class ShareAccessController {
    private static final List<MagicLinkAccessLevel> AVAILABLE_ACCESS_LEVELS = List.of(MagicLinkAccessLevel.FULL_ACCESS, MagicLinkAccessLevel.ONLY_LIVE, MagicLinkAccessLevel.ONLY_LIVE_WITH_PHOTOS, MagicLinkAccessLevel.ONLY_LAST_LOCATION);
    private final MagicLinkTokenService magicLinkTokenService;
    private final UserJdbcService userJdbcService;
    private final UserSharingJdbcService userSharingJdbcService;
    private final AvatarService avatarService;
    private final boolean dataManagementEnabled;
    private final I18nService i18n;

    public ShareAccessController(MagicLinkTokenService magicLinkTokenService, UserJdbcService userJdbcService, UserSharingJdbcService userSharingJdbcService, AvatarService avatarService, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled, I18nService i18nService) {
        this.magicLinkTokenService = magicLinkTokenService;
        this.userJdbcService = userJdbcService;
        this.userSharingJdbcService = userSharingJdbcService;
        this.avatarService = avatarService;
        this.dataManagementEnabled = dataManagementEnabled;
        this.i18n = i18nService;
    }

    @GetMapping
    public String magicLinksContent(@AuthenticationPrincipal User user, Model model) {
        List tokens = this.magicLinkTokenService.getTokensForUser(user);
        model.addAttribute("tokens", (Object)tokens);
        model.addAttribute("accessLevels", (Object)AVAILABLE_ACCESS_LEVELS);
        model.addAttribute("activeSection", (Object)"sharing");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        List availableUsers = this.loadAvailableUsers(user);
        Set sharedUserIds = this.userSharingJdbcService.getSharedUserIds(user.getId());
        List sharedWithMeUsers = this.loadSharedWithMeUsers(user);
        model.addAttribute("availableUsers", (Object)availableUsers);
        model.addAttribute("sharedUserIds", (Object)sharedUserIds);
        model.addAttribute("sharedWithMeUsers", (Object)sharedWithMeUsers);
        return "settings/share-access";
    }

    @PostMapping(value={"/magic-links"})
    public String createMagicLink(@AuthenticationPrincipal User user, @RequestParam String name, @RequestParam MagicLinkAccessLevel accessLevel, @RequestParam(required=false) String expiryDate, HttpServletRequest request, Model model) {
        try {
            Instant expiryInstant = null;
            if (expiryDate != null && !expiryDate.trim().isEmpty()) {
                try {
                    LocalDate localDate = LocalDate.parse(expiryDate);
                    expiryInstant = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant();
                }
                catch (Exception e) {
                    model.addAttribute("errorMessage", (Object)this.i18n.translate("magic.links.invalid.date"));
                    List tokens = this.magicLinkTokenService.getTokensForUser(user);
                    model.addAttribute("tokens", (Object)tokens);
                    model.addAttribute("accessLevels", (Object)MagicLinkAccessLevel.values());
                    return "settings/share-access :: magic-links-content";
                }
            }
            String rawToken = this.magicLinkTokenService.createMapShareToken(user, name, accessLevel, expiryInstant);
            String baseUrl = RequestHelper.getBaseUrl((HttpServletRequest)request);
            String magicLinkUrl = baseUrl + "/access?mt=" + rawToken;
            model.addAttribute("newTokenName", (Object)name);
            model.addAttribute("magicLinkUrl", (Object)magicLinkUrl);
            model.addAttribute("tokens", (Object)this.magicLinkTokenService.getTokensForUser(user));
            model.addAttribute("accessLevels", (Object)AVAILABLE_ACCESS_LEVELS);
            return "settings/share-access :: magic-links-content";
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18n.translate("magic.links.create.error", new Object[]{e.getMessage()}));
            model.addAttribute("tokens", (Object)this.magicLinkTokenService.getTokensForUser(user));
            model.addAttribute("accessLevels", (Object)AVAILABLE_ACCESS_LEVELS);
            return "settings/share-access :: magic-links-content";
        }
    }

    @PostMapping(value={"/magic-links/{id}/delete"})
    public String deleteMagicLink(@PathVariable long id, @AuthenticationPrincipal User user, Model model) {
        try {
            this.magicLinkTokenService.deleteToken(id);
            model.addAttribute("successMessage", (Object)this.i18n.translate("magic.links.deleted.success"));
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18n.translate("magic.links.delete.error", new Object[]{e.getMessage()}));
        }
        model.addAttribute("tokens", (Object)this.magicLinkTokenService.getTokensForUser(user));
        model.addAttribute("accessLevels", (Object)AVAILABLE_ACCESS_LEVELS);
        return "settings/share-access :: magic-links-content";
    }

    @PostMapping(value={"/users"})
    public String updateUserSharing(@AuthenticationPrincipal User user, @RequestParam(value="sharedUserIds", required=false) List<Long> sharedUserIds, Model model) {
        try {
            if (sharedUserIds == null) {
                sharedUserIds = Collections.emptyList();
            }
            List bySharingUser = this.userSharingJdbcService.findBySharingUser(user.getId());
            List<Long> finalSharedUserIds = sharedUserIds;
            Set toDelete = bySharingUser.stream().filter(s -> !finalSharedUserIds.contains(s.getSharedWithUserId())).collect(Collectors.toSet());
            Set toCreate = sharedUserIds.stream().filter(id -> bySharingUser.stream().noneMatch(s -> s.getSharedWithUserId().equals(id))).map(s -> new UserSharing(null, user.getId(), s, null, this.generateColorForUser(user.getId()), null)).collect(Collectors.toSet());
            this.userSharingJdbcService.delete(toDelete);
            this.userSharingJdbcService.create(user, toCreate);
            model.addAttribute("shareSuccessMessage", (Object)this.i18n.translate("share-with.updated.success"));
        }
        catch (Exception e) {
            model.addAttribute("shareErrorMessage", (Object)this.i18n.translate("share-with.update.error", new Object[]{e.getMessage()}));
        }
        List availableUsers = this.loadAvailableUsers(user);
        Set currentSharedUserIds = this.userSharingJdbcService.getSharedUserIds(user.getId());
        List sharedWithMeUsers = this.loadSharedWithMeUsers(user);
        model.addAttribute("availableUsers", (Object)availableUsers);
        model.addAttribute("sharedUserIds", (Object)currentSharedUserIds);
        model.addAttribute("sharedWithMeUsers", (Object)sharedWithMeUsers);
        return "settings/share-access :: share-with-content";
    }

    private List<UserDto> loadAvailableUsers(User user) {
        return this.userJdbcService.getAllUsers().stream().filter(u -> !u.getId().equals(user.getId())).map(u -> {
            String currentUserAvatarUrl = this.avatarService.getInfo(u.getId()).map(avatarInfo -> String.format("/avatars/%d?ts=%s", u.getId(), avatarInfo.updatedAt())).orElse(String.format("/avatars/%d", u.getId()));
            String currentUserInitials = this.avatarService.generateInitials(u.getDisplayName());
            return new UserDto(u.getId(), u.getUsername(), u.getDisplayName(), currentUserAvatarUrl, currentUserInitials);
        }).toList();
    }

    @PostMapping(value={"/shared-with-me/{id}/dismiss"})
    public String dismissSharedAccess(@PathVariable Long id, @AuthenticationPrincipal User user, Model model) {
        try {
            this.userSharingJdbcService.dismissSharedAccess(id, user.getId());
            model.addAttribute("shareSuccessMessage", (Object)this.i18n.translate("shared-with-me.dismissed.success"));
        }
        catch (Exception e) {
            model.addAttribute("shareErrorMessage", (Object)this.i18n.translate("shared-with-me.dismiss.error", new Object[]{e.getMessage()}));
        }
        List availableUsers = this.loadAvailableUsers(user);
        Set currentSharedUserIds = this.userSharingJdbcService.getSharedUserIds(user.getId());
        List sharedWithMeUsers = this.loadSharedWithMeUsers(user);
        model.addAttribute("availableUsers", (Object)availableUsers);
        model.addAttribute("sharedUserIds", (Object)currentSharedUserIds);
        model.addAttribute("sharedWithMeUsers", (Object)sharedWithMeUsers);
        return "settings/share-access :: share-with-content";
    }

    @PostMapping(value={"/shared-with-me/{id}/color"})
    @ResponseBody
    public String updateSharingColor(@PathVariable Long id, @RequestParam String color, @AuthenticationPrincipal User user) {
        try {
            this.userSharingJdbcService.updateSharingColor(id, user.getId(), color);
            return "success";
        }
        catch (Exception e) {
            return "error";
        }
    }

    private List<UserSharingDto> loadSharedWithMeUsers(User user) {
        return this.userSharingJdbcService.findBySharedWithUser(user.getId()).stream().map(sharing -> {
            User sharingUser = (User)this.userJdbcService.findById(sharing.getSharingUserId()).orElseThrow(() -> new RuntimeException("User not found: " + sharing.getSharingUserId()));
            String avatarUrl = this.avatarService.getInfo(sharingUser.getId()).map(avatarInfo -> String.format("/avatars/%d?ts=%s", sharingUser.getId(), avatarInfo.updatedAt())).orElse(String.format("/avatars/%d", sharingUser.getId()));
            String avatarFallback = this.avatarService.generateInitials(sharingUser.getDisplayName());
            UserDto sharingUserDto = new UserDto(sharingUser.getId(), sharingUser.getUsername(), sharingUser.getDisplayName(), avatarUrl, avatarFallback);
            return new UserSharingDto(sharing.getId(), sharingUserDto, sharing.getColor(), sharing.getCreatedAt());
        }).collect(Collectors.toList());
    }

    private String generateColorForUser(Long userId) {
        String[] colors = new String[]{"#FF6B6B", "#4ECDC4", "#45B7D1", "#96CEB4", "#FFEAA7", "#DDA0DD", "#98D8C8", "#F7DC6F", "#BB8FCE", "#85C1E9", "#F8C471", "#82E0AA", "#F1948A", "#85C1E9", "#D7BDE2"};
        return colors[Math.abs(userId.hashCode()) % colors.length];
    }
}

