/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.event.RecalculateTripEvent;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.UnitSystem;
import com.dedicatedcode.reitti.model.geo.TransportMode;
import com.dedicatedcode.reitti.model.geo.TransportModeConfig;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.TransportModeJdbcService;
import com.dedicatedcode.reitti.repository.TripJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/settings/transportation-modes"})
public class TransportationModesController {
    private final RabbitTemplate rabbitTemplate;
    private final TripJdbcService tripJdbcService;
    private final TransportModeJdbcService transportModeJdbcService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final boolean dataManagementEnabled;

    public TransportationModesController(RabbitTemplate rabbitTemplate, TripJdbcService tripJdbcService, TransportModeJdbcService transportModeJdbcService, UserSettingsJdbcService userSettingsJdbcService, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.rabbitTemplate = rabbitTemplate;
        this.tripJdbcService = tripJdbcService;
        this.transportModeJdbcService = transportModeJdbcService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.dataManagementEnabled = dataManagementEnabled;
    }

    @GetMapping
    public String transportationModes(@AuthenticationPrincipal User user, Model model) {
        UserSettings userSettings = this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId());
        List configs = this.transportModeJdbcService.getTransportModeConfigs(user);
        List availableModes = this.getAvailableModesToAdd(configs);
        model.addAttribute("configs", (Object)configs);
        model.addAttribute("availableModes", (Object)availableModes);
        model.addAttribute("activeSection", (Object)"transportation-modes");
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("unitSystem", (Object)userSettings.getUnitSystem());
        model.addAttribute("isImperial", (Object)(userSettings.getUnitSystem() == UnitSystem.IMPERIAL ? 1 : 0));
        return "settings/transportation-modes";
    }

    @PostMapping(value={"/add"})
    public String addTransportMode(@AuthenticationPrincipal User user, @RequestParam TransportMode mode, @RequestParam(required=false) Double maxSpeed, @RequestParam(required=false) UnitSystem unitSystem, RedirectAttributes redirectAttributes) {
        try {
            List configs = this.transportModeJdbcService.getTransportModeConfigs(user);
            boolean exists = configs.stream().anyMatch(config -> config.mode() == mode);
            if (exists) {
                redirectAttributes.addFlashAttribute("errorMessage", (Object)"transportation.modes.error.already.exists");
                return "redirect:/settings/transportation-modes";
            }
            Double maxKmh = maxSpeed != null && unitSystem == UnitSystem.IMPERIAL ? this.mphToKmh(maxSpeed) : maxSpeed;
            boolean duplicateMaxKmh = configs.stream().anyMatch(config -> Objects.equals(config.maxKmh(), maxKmh));
            if (duplicateMaxKmh) {
                redirectAttributes.addFlashAttribute("errorMessage", (Object)"transportation.modes.error.duplicate.max.kmh");
                return "redirect:/settings/transportation-modes";
            }
            configs.add(new TransportModeConfig(mode, maxKmh));
            this.transportModeJdbcService.setTransportModeConfigs(user, configs);
            redirectAttributes.addFlashAttribute("successMessage", (Object)"transportation.modes.success.added");
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)"transportation.modes.error.add");
        }
        return "redirect:/settings/transportation-modes";
    }

    @PostMapping(value={"/{mode}/update"})
    public String updateTransportMode(@AuthenticationPrincipal User user, @PathVariable TransportMode mode, @RequestParam(required=false) Double maxSpeed, @RequestParam(required=false) UnitSystem unitSystem, RedirectAttributes redirectAttributes) {
        try {
            List configs = this.transportModeJdbcService.getTransportModeConfigs(user);
            Double maxKmh = maxSpeed != null && unitSystem == UnitSystem.IMPERIAL ? this.mphToKmh(maxSpeed) : maxSpeed;
            List updatedConfigs = configs.stream().map(config -> config.mode() == mode ? new TransportModeConfig(mode, maxKmh) : config).collect(Collectors.toList());
            this.transportModeJdbcService.setTransportModeConfigs(user, updatedConfigs);
            redirectAttributes.addFlashAttribute("successMessage", (Object)"transportation.modes.success.updated");
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)"transportation.modes.error.update");
        }
        return "redirect:/settings/transportation-modes";
    }

    @PostMapping(value={"/{mode}/delete"})
    public String deleteTransportMode(@AuthenticationPrincipal User user, @PathVariable TransportMode mode, RedirectAttributes redirectAttributes) {
        try {
            List configs = this.transportModeJdbcService.getTransportModeConfigs(user);
            List filteredConfigs = configs.stream().filter(config -> config.mode() != mode).collect(Collectors.toList());
            this.transportModeJdbcService.setTransportModeConfigs(user, filteredConfigs);
            redirectAttributes.addFlashAttribute("successMessage", (Object)"transportation.modes.success.deleted");
        }
        catch (Exception e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)"transportation.modes.error.delete");
        }
        return "redirect:/settings/transportation-modes";
    }

    @PostMapping(value={"/content"})
    public String getTransportationModesContent(@AuthenticationPrincipal User user, Model model) {
        UserSettings userSettings = this.userSettingsJdbcService.getOrCreateDefaultSettings(user.getId());
        List configs = this.transportModeJdbcService.getTransportModeConfigs(user);
        List availableModes = this.getAvailableModesToAdd(configs);
        model.addAttribute("configs", (Object)configs);
        model.addAttribute("availableModes", (Object)availableModes);
        model.addAttribute("unitSystem", (Object)userSettings.getUnitSystem());
        model.addAttribute("isImperial", (Object)(userSettings.getUnitSystem() == UnitSystem.IMPERIAL ? 1 : 0));
        return "settings/transportation-modes :: transportation-modes-content";
    }

    private List<TransportMode> getAvailableModesToAdd(List<TransportModeConfig> configs) {
        List<TransportMode> usedModes = configs.stream().map(TransportModeConfig::mode).toList();
        return Arrays.stream(TransportMode.values()).filter(mode -> !usedModes.contains(mode)).filter(mode -> mode != TransportMode.UNKNOWN).collect(Collectors.toList());
    }

    private Double mphToKmh(Double mph) {
        return mph * 1.60934;
    }

    private Double kmhToMph(Double kmh) {
        return kmh / 1.60934;
    }

    @PostMapping(value={"/reclassify"})
    public String reclassifyTrips(@AuthenticationPrincipal User user, Model model) {
        try {
            CompletableFuture.runAsync(() -> this.tripJdbcService.findIdsByUser(user).forEach(tripId -> this.rabbitTemplate.convertAndSend("reitti-exchange", "reitti.trip.recalculate.v2", (Object)new RecalculateTripEvent(user.getUsername(), tripId.longValue(), UUID.randomUUID().toString()))));
            model.addAttribute("reclassifyStatus", (Object)"started");
            model.addAttribute("message", (Object)"transportation.modes.reclassify.started");
        }
        catch (Exception e) {
            model.addAttribute("reclassifyStatus", (Object)"error");
            model.addAttribute("message", (Object)"transportation.modes.reclassify.error");
        }
        return "settings/transportation-modes :: reclassify-status";
    }
}

