/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.controller.settings;

import com.dedicatedcode.reitti.model.Language;
import com.dedicatedcode.reitti.model.Role;
import com.dedicatedcode.reitti.model.TimeDisplayMode;
import com.dedicatedcode.reitti.model.UnitSystem;
import com.dedicatedcode.reitti.model.security.User;
import com.dedicatedcode.reitti.model.security.UserSettings;
import com.dedicatedcode.reitti.repository.UserJdbcService;
import com.dedicatedcode.reitti.repository.UserSettingsJdbcService;
import com.dedicatedcode.reitti.service.AvatarService;
import com.dedicatedcode.reitti.service.I18nService;
import com.dedicatedcode.reitti.service.UserService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.LocaleResolver;

@Controller
@RequestMapping(value={"/settings"})
public class UserSettingsController {
    private final UserJdbcService userJdbcService;
    private final UserService userService;
    private final UserSettingsJdbcService userSettingsJdbcService;
    private final LocaleResolver localeResolver;
    private final AvatarService avatarService;
    private final PasswordEncoder passwordEncoder;
    private final boolean localLoginDisabled;
    private final boolean oidcEnabled;
    private final boolean dataManagementEnabled;
    private final I18nService i18nService;
    private static final long MAX_AVATAR_SIZE = 0x200000L;
    private static final String[] ALLOWED_CONTENT_TYPES = new String[]{"image/jpeg", "image/jpg", "image/png", "image/gif", "image/webp"};
    private static final List<String> DEFAULT_AVATARS = Arrays.asList("avatar_man.jpg", "avatar_woman.jpg", "avatar_boy.jpg", "avatar_girl.jpg");
    private static final long MAX_CSS_SIZE = 0x100000L;
    private static final String ALLOWED_CSS_CONTENT_TYPE = "text/css";
    private final Map<String, String> defaultColors = new HashMap();

    public UserSettingsController(UserJdbcService userJdbcService, UserService userService, UserSettingsJdbcService userSettingsJdbcService, I18nService i18nService, LocaleResolver localeResolver, AvatarService avatarService, PasswordEncoder passwordEncoder, @Value(value="${reitti.security.local-login.disable}") boolean localLoginDisabled, @Value(value="${reitti.security.oidc.enabled:false}") boolean oidcEnabled, @Value(value="${reitti.data-management.enabled:false}") boolean dataManagementEnabled) {
        this.userJdbcService = userJdbcService;
        this.userService = userService;
        this.userSettingsJdbcService = userSettingsJdbcService;
        this.i18nService = i18nService;
        this.localeResolver = localeResolver;
        this.avatarService = avatarService;
        this.passwordEncoder = passwordEncoder;
        this.localLoginDisabled = localLoginDisabled;
        this.oidcEnabled = oidcEnabled;
        this.dataManagementEnabled = dataManagementEnabled;
        this.defaultColors.put("#f1ba63", "Default Gold");
        this.defaultColors.put("#4a90e2", "Ocean Blue");
        this.defaultColors.put("#7ed321", "Fresh Green");
        this.defaultColors.put("#f5a623", "Warm Orange");
        this.defaultColors.put("#bd10e0", "Purple");
        this.defaultColors.put("#b8e986", "Light Green");
        this.defaultColors.put("#50e3c2", "Turquoise");
        this.defaultColors.put("#e94b3c", "Red");
        this.defaultColors.put("#9013fe", "Violet");
        this.defaultColors.put("#417505", "Forest Green");
        this.defaultColors.put("#d0021b", "Crimson");
        this.defaultColors.put("#8b572a", "Brow");
    }

    @GetMapping(value={"/users-content"})
    public String getUsersContent(@AuthenticationPrincipal User user, Model model) {
        return this.getUserContent(model, user);
    }

    @GetMapping(value={"/user-management"})
    public String getUserManagementPage(@AuthenticationPrincipal User user, Model model) {
        model.addAttribute("activeSection", (Object)"user-management");
        model.addAttribute("isAdmin", (Object)(user.getRole() == Role.ADMIN ? 1 : 0));
        model.addAttribute("dataManagementEnabled", (Object)this.dataManagementEnabled);
        this.getUsersContent(user, model);
        return "settings/user-management";
    }

    private String getUserContent(Model model, User currentUser) {
        if (Role.ADMIN != currentUser.getRole()) {
            model.addAttribute("userId", (Object)currentUser.getId());
            model.addAttribute("username", (Object)currentUser.getUsername());
            model.addAttribute("displayName", (Object)currentUser.getDisplayName());
            model.addAttribute("selectedRole", (Object)currentUser.getRole());
            model.addAttribute("externallyManaged", (Object)(currentUser.getExternalId() != null && this.oidcEnabled ? 1 : 0));
            model.addAttribute("externalProfile", (Object)currentUser.getProfileUrl());
            model.addAttribute("localLoginDisabled", (Object)this.localLoginDisabled);
            UserSettings userSettings = this.userSettingsJdbcService.findByUserId(currentUser.getId()).orElse(UserSettings.defaultSettings((Long)currentUser.getId()));
            model.addAttribute("availableLanguages", (Object)Language.values());
            model.addAttribute("selectedLanguage", (Object)userSettings.getSelectedLanguage());
            model.addAttribute("selectedUnitSystem", (Object)userSettings.getUnitSystem().name());
            model.addAttribute("preferColoredMap", (Object)userSettings.isPreferColoredMap());
            model.addAttribute("homeLatitude", (Object)userSettings.getHomeLatitude());
            model.addAttribute("homeLongitude", (Object)userSettings.getHomeLongitude());
            model.addAttribute("unitSystems", (Object)UnitSystem.values());
            model.addAttribute("hasAvatar", (Object)this.avatarService.getInfo(currentUser.getId()).isPresent());
            model.addAttribute("hasCustomCss", (Object)StringUtils.hasText((String)userSettings.getCustomCss()));
            model.addAttribute("defaultAvatars", (Object)DEFAULT_AVATARS);
            model.addAttribute("isAdmin", (Object)false);
            model.addAttribute("timeZoneOverride", (Object)userSettings.getTimeZoneOverride());
            model.addAttribute("timeDisplayMode", (Object)userSettings.getTimeDisplayMode().name());
            model.addAttribute("availableTimezones", ZoneId.getAvailableZoneIds());
            model.addAttribute("availableTimeDisplayModes", (Object)TimeDisplayMode.values());
            model.addAttribute("defaultColors", (Object)this.defaultColors);
            model.addAttribute("selectedColor", (Object)userSettings.getColor());
            return "fragments/user-management :: user-form-page";
        }
        List users = this.userJdbcService.getAllUsers();
        model.addAttribute("users", (Object)users);
        model.addAttribute("currentUsername", (Object)currentUser.getUsername());
        model.addAttribute("isAdmin", (Object)true);
        model.addAttribute("addUserAvailable", (Object)(!this.localLoginDisabled ? 1 : 0));
        return "fragments/user-management :: users-list";
    }

    @PostMapping(value={"/users/{userId}/delete"})
    public String deleteUser(@PathVariable Long userId, Authentication authentication, Model model) {
        String currentUsername = authentication.getName();
        User currentUser = (User)this.userJdbcService.findByUsername(currentUsername).orElseThrow(() -> new UsernameNotFoundException("User not found: " + currentUsername));
        if (Role.ADMIN != currentUser.getRole()) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.access.denied"));
            return this.getUserContent(model, currentUser);
        }
        if (currentUser.getId().equals(userId)) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.user.self.delete"));
        } else {
            try {
                User user = (User)this.userJdbcService.findById(userId).orElseThrow();
                this.userService.deleteUser(user);
                model.addAttribute("successMessage", (Object)this.i18nService.translate("message.success.user.deleted"));
            }
            catch (Exception e) {
                model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.user.deletion", new Object[]{e.getMessage()}));
            }
        }
        List users = this.userJdbcService.getAllUsers();
        model.addAttribute("users", (Object)users);
        model.addAttribute("currentUsername", (Object)authentication.getName());
        model.addAttribute("isAdmin", (Object)true);
        model.addAttribute("addUserAvailable", (Object)(!this.localLoginDisabled ? 1 : 0));
        return "fragments/user-management :: users-list";
    }

    @PostMapping(value={"/users"})
    public String createUser(@RequestParam(required=false) String username, @RequestParam(required=false) String displayName, @RequestParam(required=false) String password, @RequestParam(defaultValue="USER") Role role, @RequestParam(name="preferred_language") Language preferredLanguage, @RequestParam(name="unit_system", defaultValue="METRIC") String unitSystem, @RequestParam(defaultValue="false") boolean preferColoredMap, @RequestParam(required=false) Double homeLatitude, @RequestParam(required=false) Double homeLongitude, @RequestParam(name="timezone_override", required=false) String timezoneOverride, @RequestParam(name="time_display_mode", defaultValue="DEFAULT") TimeDisplayMode timeDisplayMode, @RequestParam(required=false) MultipartFile avatar, @RequestParam(required=false) String defaultAvatar, @RequestParam(required=false) MultipartFile customCss, @RequestParam String color, Authentication authentication, Model model) {
        String currentUsername = authentication.getName();
        User currentUser = (User)this.userJdbcService.findByUsername(currentUsername).orElseThrow(() -> new UsernameNotFoundException("User not found: " + currentUsername));
        if (Role.ADMIN != currentUser.getRole()) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.access.denied"));
            return this.getUserContent(model, currentUser);
        }
        try {
            if (StringUtils.hasText((String)username) && StringUtils.hasText((String)displayName) && StringUtils.hasText((String)password)) {
                String cssContent;
                User createdUser = this.userService.createNewUser(username, displayName, password, role, UnitSystem.valueOf((String)unitSystem), preferColoredMap, preferredLanguage, homeLatitude, homeLongitude, timezoneOverride, timeDisplayMode, color);
                if (avatar != null && !avatar.isEmpty()) {
                    this.handleAvatarUpload(avatar, createdUser.getId(), model);
                } else if (StringUtils.hasText((String)defaultAvatar)) {
                    this.handleDefaultAvatarSelection(defaultAvatar, createdUser.getId(), model);
                }
                if (customCss != null && !customCss.isEmpty() && (cssContent = this.handleCssUpload(customCss, model)) != null) {
                    UserSettings existingSettings = this.userSettingsJdbcService.findByUserId(createdUser.getId()).orElse(UserSettings.defaultSettings((Long)createdUser.getId()));
                    UserSettings updatedSettings = new UserSettings(existingSettings.getUserId(), existingSettings.isPreferColoredMap(), existingSettings.getSelectedLanguage(), existingSettings.getUnitSystem(), existingSettings.getHomeLatitude(), existingSettings.getHomeLongitude(), existingSettings.getTimeZoneOverride(), existingSettings.getTimeDisplayMode(), cssContent, existingSettings.getLatestData(), color, existingSettings.getVersion());
                    this.userSettingsJdbcService.save(updatedSettings);
                }
                model.addAttribute("successMessage", (Object)this.i18nService.translate("message.success.user.created"));
            } else {
                model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.user.creation", new Object[]{"All fields must be filled"}));
            }
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.user.creation", new Object[]{e.getMessage()}));
        }
        List users = this.userJdbcService.getAllUsers();
        model.addAttribute("users", (Object)users);
        model.addAttribute("currentUsername", (Object)authentication.getName());
        model.addAttribute("isAdmin", (Object)true);
        model.addAttribute("addUserAvailable", (Object)(!this.localLoginDisabled ? 1 : 0));
        return "fragments/user-management :: users-list";
    }

    @PostMapping(value={"/users/update"})
    public String updateUser(@RequestParam Long userId, @RequestParam(required=false) String username, @RequestParam(required=false) String displayName, @RequestParam(required=false) String password, @RequestParam(defaultValue="USER") Role role, @RequestParam Language preferred_language, @RequestParam(defaultValue="METRIC") String unit_system, @RequestParam(defaultValue="false") boolean preferColoredMap, @RequestParam(required=false) Double homeLatitude, @RequestParam(required=false) Double homeLongitude, @RequestParam(required=false) MultipartFile avatar, @RequestParam(name="timezone_override", required=false) String timezoneOverride, @RequestParam(name="time_display_mode", defaultValue="DEFAULT") TimeDisplayMode timeDisplayMode, @RequestParam(required=false) String defaultAvatar, @RequestParam(required=false) String removeAvatar, @RequestParam(required=false) MultipartFile customCss, @RequestParam(required=false) String removeCss, @RequestParam String color, Authentication authentication, HttpServletRequest request, HttpServletResponse response, Model model) {
        String currentUsername = authentication.getName();
        User authenticatedUser = (User)this.userJdbcService.findByUsername(currentUsername).orElseThrow(() -> new UsernameNotFoundException("User not found: " + currentUsername));
        User userToUpdate = (User)this.userJdbcService.findById(userId).orElseThrow(() -> new UsernameNotFoundException("User not found: " + userId));
        boolean isCurrentUser = userToUpdate.getUsername().equals(currentUsername);
        if (!isCurrentUser && Role.ADMIN != authenticatedUser.getRole()) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.access.denied"));
            return this.getUserContent(model, authenticatedUser);
        }
        try {
            String uploadedCss;
            User existingUser = (User)this.userJdbcService.findById(userId).orElseThrow();
            String encodedPassword = existingUser.getPassword();
            if (password != null && !password.trim().isEmpty()) {
                encodedPassword = this.passwordEncoder.encode((CharSequence)password);
            }
            if (username == null || username.trim().isEmpty()) {
                username = existingUser.getUsername();
            }
            if (displayName == null || displayName.trim().isEmpty()) {
                displayName = existingUser.getDisplayName();
            }
            User updatedUser = new User(existingUser.getId(), username, encodedPassword, displayName, existingUser.getProfileUrl(), existingUser.getExternalId(), role, existingUser.getVersion());
            this.userJdbcService.updateUser(updatedUser);
            UserSettings existingSettings = this.userSettingsJdbcService.findByUserId(userId).orElse(UserSettings.defaultSettings((Long)userId));
            String cssContent = existingSettings.getCustomCss();
            if ("true".equals(removeCss)) {
                cssContent = null;
            } else if (customCss != null && !customCss.isEmpty() && (uploadedCss = this.handleCssUpload(customCss, model)) != null) {
                cssContent = uploadedCss;
            }
            UnitSystem unitSystem = UnitSystem.valueOf((String)unit_system);
            UserSettings updatedSettings = new UserSettings(userId, preferColoredMap, preferred_language, unitSystem, homeLatitude, homeLongitude, StringUtils.hasText((String)timezoneOverride) ? ZoneId.of(timezoneOverride) : null, timeDisplayMode, cssContent, existingSettings.getLatestData(), color, existingSettings.getVersion());
            this.userSettingsJdbcService.save(updatedSettings);
            if ("true".equals(removeAvatar)) {
                this.avatarService.deleteAvatar(userId);
            } else if (avatar != null && !avatar.isEmpty()) {
                this.handleAvatarUpload(avatar, userId, model);
            } else if (StringUtils.hasText((String)defaultAvatar)) {
                this.handleDefaultAvatarSelection(defaultAvatar, userId, model);
            }
            if (isCurrentUser) {
                this.localeResolver.setLocale(request, response, preferred_language.getLocale());
            }
            model.addAttribute("successMessage", (Object)this.i18nService.translate("message.success.user.updated"));
            if (isCurrentUser && !currentUsername.equals(username)) {
                model.addAttribute("requireRelogin", (Object)true);
                model.addAttribute("newUsername", (Object)username);
            }
        }
        catch (Exception e) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.user.update", new Object[]{e.getMessage()}));
        }
        if (Role.ADMIN == authenticatedUser.getRole()) {
            List users = this.userJdbcService.getAllUsers();
            model.addAttribute("users", (Object)users);
            model.addAttribute("currentUsername", (Object)(isCurrentUser ? username : currentUsername));
            model.addAttribute("isAdmin", (Object)true);
            model.addAttribute("addUserAvailable", (Object)(!this.localLoginDisabled ? 1 : 0));
            return "fragments/user-management :: users-list";
        }
        return this.getUserContent(model, userToUpdate);
    }

    @GetMapping(value={"/user-form"})
    public String getUserForm(@RequestParam(required=false) Long userId, @RequestParam(required=false) String username, @RequestParam(required=false) String displayName, @RequestParam(required=false) String role, Authentication authentication, Model model) {
        UserSettings userSettings;
        String currentUsername = authentication.getName();
        User currentUser = (User)this.userJdbcService.findByUsername(currentUsername).orElseThrow(() -> new UsernameNotFoundException("User not found: " + currentUsername));
        if (userId != null && !userId.equals(currentUser.getId()) && Role.ADMIN != currentUser.getRole()) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.access.denied"));
            return this.getUserContent(model, currentUser);
        }
        if (userId == null && Role.ADMIN != currentUser.getRole()) {
            model.addAttribute("errorMessage", (Object)this.i18nService.translate("message.error.access.denied"));
            return this.getUserContent(model, currentUser);
        }
        if (userId != null) {
            model.addAttribute("userId", (Object)userId);
            User user = this.userJdbcService.findById(userId).orElse(null);
            model.addAttribute("username", (Object)username);
            model.addAttribute("displayName", (Object)displayName);
            model.addAttribute("selectedRole", (Object)role);
            model.addAttribute("externallyManaged", (Object)(user != null && user.getExternalId() != null && this.oidcEnabled ? 1 : 0));
            model.addAttribute("externalProfile", (Object)(user != null ? user.getProfileUrl() : null));
            model.addAttribute("localLoginDisabled", (Object)this.localLoginDisabled);
            userSettings = this.userSettingsJdbcService.findByUserId(userId).orElse(UserSettings.defaultSettings((Long)userId));
            model.addAttribute("selectedLanguage", (Object)userSettings.getSelectedLanguage());
            model.addAttribute("selectedUnitSystem", (Object)userSettings.getUnitSystem().name());
            model.addAttribute("preferColoredMap", (Object)userSettings.isPreferColoredMap());
            model.addAttribute("homeLatitude", (Object)userSettings.getHomeLatitude());
            model.addAttribute("homeLongitude", (Object)userSettings.getHomeLongitude());
            model.addAttribute("timeZoneOverride", (Object)userSettings.getTimeZoneOverride());
            model.addAttribute("timeDisplayMode", (Object)userSettings.getTimeDisplayMode().name());
            model.addAttribute("selectedColor", (Object)userSettings.getColor());
        } else {
            model.addAttribute("selectedLanguage", (Object)Language.EN);
            model.addAttribute("selectedUnitSystem", (Object)"METRIC");
            model.addAttribute("preferColoredMap", (Object)false);
            model.addAttribute("selectedRole", (Object)"USER");
            model.addAttribute("homeLatitude", null);
            model.addAttribute("homeLongitude", null);
            model.addAttribute("externallyManaged", (Object)false);
            model.addAttribute("externalProfile", null);
            model.addAttribute("localLoginDisabled", (Object)this.localLoginDisabled);
        }
        model.addAttribute("unitSystems", (Object)UnitSystem.values());
        model.addAttribute("availableLanguages", (Object)Language.values());
        model.addAttribute("availableTimezones", ZoneId.getAvailableZoneIds().stream().sorted());
        model.addAttribute("availableTimeDisplayModes", (Object)TimeDisplayMode.values());
        model.addAttribute("defaultColors", (Object)this.defaultColors);
        if (userId != null) {
            boolean hasAvatar = this.avatarService.getInfo(userId).isPresent();
            model.addAttribute("hasAvatar", (Object)hasAvatar);
            userSettings = this.userSettingsJdbcService.findByUserId(userId).orElse(null);
            boolean hasCustomCss = userSettings != null && StringUtils.hasText((String)userSettings.getCustomCss());
            model.addAttribute("hasCustomCss", (Object)hasCustomCss);
        }
        model.addAttribute("defaultAvatars", (Object)DEFAULT_AVATARS);
        model.addAttribute("isAdmin", (Object)(Role.ADMIN == currentUser.getRole() ? 1 : 0));
        return "fragments/user-management :: user-form-page";
    }

    private void handleAvatarUpload(MultipartFile avatar, Long userId, Model model) {
        if (avatar != null && !avatar.isEmpty()) {
            try {
                if (avatar.getSize() > 0x200000L) {
                    model.addAttribute("avatarError", (Object)this.i18nService.translate("users.avatar.error.to-large"));
                    return;
                }
                String contentType = avatar.getContentType();
                if (contentType == null || !this.isAllowedContentType(contentType)) {
                    model.addAttribute("avatarError", (Object)this.i18nService.translate("users.avatar.error.invalid-file-type"));
                    return;
                }
                byte[] imageData = avatar.getBytes();
                this.avatarService.updateAvatar(userId, contentType, imageData);
            }
            catch (IOException e) {
                model.addAttribute("avatarError", (Object)this.i18nService.translate("users.avatar.error.generic", new Object[]{e.getMessage()}));
            }
        }
    }

    private boolean isAllowedContentType(String contentType) {
        for (String allowed : ALLOWED_CONTENT_TYPES) {
            if (!allowed.equals(contentType)) continue;
            return true;
        }
        return false;
    }

    private void handleDefaultAvatarSelection(String defaultAvatar, Long userId, Model model) {
        try {
            if (!DEFAULT_AVATARS.contains(defaultAvatar)) {
                model.addAttribute("avatarError", (Object)"Invalid default avatar selection.");
                return;
            }
            ClassPathResource resource = new ClassPathResource("static/img/avatars/default/" + defaultAvatar);
            if (!resource.exists()) {
                model.addAttribute("avatarError", (Object)"Default avatar file not found.");
                return;
            }
            byte[] imageData = resource.getInputStream().readAllBytes();
            String mimeType = "image/jpeg";
            this.avatarService.updateAvatar(userId, mimeType, imageData);
        }
        catch (IOException e) {
            model.addAttribute("avatarError", (Object)("Error processing default avatar: " + e.getMessage()));
        }
    }

    private String handleCssUpload(MultipartFile cssFile, Model model) {
        if (cssFile != null && !cssFile.isEmpty()) {
            try {
                if (cssFile.getSize() > 0x100000L) {
                    model.addAttribute("cssError", (Object)this.i18nService.translate("users.custom.css.error.to-large"));
                    return null;
                }
                String contentType = cssFile.getContentType();
                if (!ALLOWED_CSS_CONTENT_TYPE.equals(contentType)) {
                    model.addAttribute("cssError", (Object)this.i18nService.translate("users.custom.css.error.invalid-file-type"));
                    return null;
                }
                String originalFilename = cssFile.getOriginalFilename();
                if (originalFilename == null || !originalFilename.toLowerCase().endsWith(".css")) {
                    model.addAttribute("cssError", (Object)this.i18nService.translate("users.custom.css.error.invalid-file-type"));
                    return null;
                }
                return new String(cssFile.getBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                model.addAttribute("cssError", (Object)this.i18nService.translate("users.custom.css.error.generic", new Object[]{e.getMessage()}));
                return null;
            }
        }
        return null;
    }
}

