/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.dto;

import com.dedicatedcode.reitti.model.processing.DetectionParameter;
import com.dedicatedcode.reitti.model.processing.RecalculationState;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.springframework.format.annotation.DateTimeFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigurationForm {
    private Long id;
    private String mode = "simple";
    private Integer sensitivityLevel = 3;
    private Long minimumStayTimeInSeconds;
    private Long maxMergeTimeBetweenSameStayPoints;
    private Long searchDurationInHours;
    private Long maxMergeTimeBetweenSameVisits;
    private Long minDistanceBetweenVisits;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate validSince;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Integer getSensitivityLevel() {
        return this.sensitivityLevel;
    }

    public void setSensitivityLevel(Integer sensitivityLevel) {
        this.sensitivityLevel = sensitivityLevel;
    }

    public Long getMinimumStayTimeInSeconds() {
        return this.minimumStayTimeInSeconds;
    }

    public void setMinimumStayTimeInSeconds(Long minimumStayTimeInSeconds) {
        this.minimumStayTimeInSeconds = minimumStayTimeInSeconds;
    }

    public Long getMaxMergeTimeBetweenSameStayPoints() {
        return this.maxMergeTimeBetweenSameStayPoints;
    }

    public void setMaxMergeTimeBetweenSameStayPoints(Long maxMergeTimeBetweenSameStayPoints) {
        this.maxMergeTimeBetweenSameStayPoints = maxMergeTimeBetweenSameStayPoints;
    }

    public Long getSearchDurationInHours() {
        return this.searchDurationInHours;
    }

    public void setSearchDurationInHours(Long searchDurationInHours) {
        this.searchDurationInHours = searchDurationInHours;
    }

    public Long getMaxMergeTimeBetweenSameVisits() {
        return this.maxMergeTimeBetweenSameVisits;
    }

    public void setMaxMergeTimeBetweenSameVisits(Long maxMergeTimeBetweenSameVisits) {
        this.maxMergeTimeBetweenSameVisits = maxMergeTimeBetweenSameVisits;
    }

    public Long getMinDistanceBetweenVisits() {
        return this.minDistanceBetweenVisits;
    }

    public void setMinDistanceBetweenVisits(Long minDistanceBetweenVisits) {
        this.minDistanceBetweenVisits = minDistanceBetweenVisits;
    }

    public LocalDate getValidSince() {
        return this.validSince;
    }

    public void setValidSince(LocalDate validSince) {
        this.validSince = validSince;
    }

    public static ConfigurationForm fromConfiguration(DetectionParameter config, ZoneId zoneId) {
        ConfigurationForm form = new ConfigurationForm();
        form.setId(config.getId());
        form.setMinimumStayTimeInSeconds(Long.valueOf(config.getVisitDetection().getMinimumStayTimeInSeconds()));
        form.setMaxMergeTimeBetweenSameStayPoints(Long.valueOf(config.getVisitDetection().getMaxMergeTimeBetweenSameStayPoints()));
        form.setSearchDurationInHours(Long.valueOf(config.getVisitMerging().getSearchDurationInHours()));
        form.setMaxMergeTimeBetweenSameVisits(Long.valueOf(config.getVisitMerging().getMaxMergeTimeBetweenSameVisits()));
        form.setMinDistanceBetweenVisits(Long.valueOf(config.getVisitMerging().getMinDistanceBetweenVisits()));
        Integer matchingSensitivityLevel = ConfigurationForm.findMatchingSensitivityLevel((DetectionParameter)config);
        if (matchingSensitivityLevel != null) {
            form.setSensitivityLevel(matchingSensitivityLevel);
            form.setMode("simple");
        } else {
            form.setSensitivityLevel(Integer.valueOf(3));
            form.setMode("advanced");
        }
        if (config.getValidSince() != null) {
            form.setValidSince(LocalDate.ofInstant(config.getValidSince(), zoneId));
        }
        return form;
    }

    private static Integer findMatchingSensitivityLevel(DetectionParameter config) {
        for (int level = 1; level <= 5; ++level) {
            DetectionParameter.VisitMerging expectedMerging;
            DetectionParameter.VisitDetection expectedDetection = ConfigurationForm.mapSensitivityToVisitDetection((int)level);
            if (!ConfigurationForm.configurationMatches((DetectionParameter)config, (DetectionParameter.VisitDetection)expectedDetection, (DetectionParameter.VisitMerging)(expectedMerging = ConfigurationForm.mapSensitivityToVisitMerging((int)level)))) continue;
            return level;
        }
        return null;
    }

    private static boolean configurationMatches(DetectionParameter config, DetectionParameter.VisitDetection expectedDetection, DetectionParameter.VisitMerging expectedMerging) {
        DetectionParameter.VisitDetection actualDetection = config.getVisitDetection();
        DetectionParameter.VisitMerging actualMerging = config.getVisitMerging();
        return actualDetection.getMinimumStayTimeInSeconds() == expectedDetection.getMinimumStayTimeInSeconds() && actualDetection.getMaxMergeTimeBetweenSameStayPoints() == expectedDetection.getMaxMergeTimeBetweenSameStayPoints() && actualMerging.getSearchDurationInHours() == expectedMerging.getSearchDurationInHours() && actualMerging.getMaxMergeTimeBetweenSameVisits() == expectedMerging.getMaxMergeTimeBetweenSameVisits() && actualMerging.getMinDistanceBetweenVisits() == expectedMerging.getMinDistanceBetweenVisits();
    }

    private static DetectionParameter.VisitDetection mapSensitivityToVisitDetection(int level) {
        return switch (level) {
            case 1 -> new DetectionParameter.VisitDetection(600L, 600L);
            case 2 -> new DetectionParameter.VisitDetection(450L, 450L);
            case 3 -> new DetectionParameter.VisitDetection(300L, 300L);
            case 4 -> new DetectionParameter.VisitDetection(225L, 225L);
            case 5 -> new DetectionParameter.VisitDetection(150L, 150L);
            default -> throw new IllegalArgumentException("Unhandled level [" + level + "] detected!");
        };
    }

    private static DetectionParameter.VisitMerging mapSensitivityToVisitMerging(int level) {
        return switch (level) {
            case 1 -> new DetectionParameter.VisitMerging(48L, 600L, 250L);
            case 2 -> new DetectionParameter.VisitMerging(48L, 450L, 200L);
            case 3 -> new DetectionParameter.VisitMerging(48L, 300L, 150L);
            case 4 -> new DetectionParameter.VisitMerging(48L, 225L, 100L);
            case 5 -> new DetectionParameter.VisitMerging(48L, 150L, 50L);
            default -> throw new IllegalArgumentException("Unhandled level [" + level + "] detected!");
        };
    }

    public void applySensitivityLevel(Integer level) {
        if (level == null || level < 1 || level > 5) {
            return;
        }
        DetectionParameter.VisitDetection visitDetection = ConfigurationForm.mapSensitivityToVisitDetection((int)level);
        DetectionParameter.VisitMerging visitMerging = ConfigurationForm.mapSensitivityToVisitMerging((int)level);
        this.minimumStayTimeInSeconds = visitDetection.getMinimumStayTimeInSeconds();
        this.maxMergeTimeBetweenSameStayPoints = visitDetection.getMaxMergeTimeBetweenSameStayPoints();
        this.searchDurationInHours = visitMerging.getSearchDurationInHours();
        this.maxMergeTimeBetweenSameVisits = visitMerging.getMaxMergeTimeBetweenSameVisits();
        this.minDistanceBetweenVisits = visitMerging.getMinDistanceBetweenVisits();
        this.sensitivityLevel = level;
    }

    public boolean hasConfigurationChanged(DetectionParameter original) {
        if (original == null) {
            return true;
        }
        DetectionParameter current = this.toConfiguration(ZoneId.systemDefault());
        DetectionParameter.VisitDetection originalDetection = original.getVisitDetection();
        DetectionParameter.VisitDetection currentDetection = current.getVisitDetection();
        if (originalDetection.getMinimumStayTimeInSeconds() != currentDetection.getMinimumStayTimeInSeconds() || originalDetection.getMaxMergeTimeBetweenSameStayPoints() != currentDetection.getMaxMergeTimeBetweenSameStayPoints()) {
            return true;
        }
        DetectionParameter.VisitMerging originalMerging = original.getVisitMerging();
        DetectionParameter.VisitMerging currentMerging = current.getVisitMerging();
        return originalMerging.getSearchDurationInHours() != currentMerging.getSearchDurationInHours() || originalMerging.getMaxMergeTimeBetweenSameVisits() != currentMerging.getMaxMergeTimeBetweenSameVisits() || originalMerging.getMinDistanceBetweenVisits() != currentMerging.getMinDistanceBetweenVisits();
    }

    public DetectionParameter toConfiguration(ZoneId timezone) {
        DetectionParameter.VisitMerging visitMerging;
        DetectionParameter.VisitDetection visitDetection;
        if ("simple".equals(this.mode)) {
            visitDetection = ConfigurationForm.mapSensitivityToVisitDetection((int)this.sensitivityLevel);
            visitMerging = ConfigurationForm.mapSensitivityToVisitMerging((int)this.sensitivityLevel);
        } else {
            visitDetection = new DetectionParameter.VisitDetection(this.minimumStayTimeInSeconds.longValue(), this.maxMergeTimeBetweenSameStayPoints.longValue());
            visitMerging = new DetectionParameter.VisitMerging(this.searchDurationInHours.longValue(), this.maxMergeTimeBetweenSameVisits.longValue(), this.minDistanceBetweenVisits.longValue());
        }
        DetectionParameter.LocationDensity locationDensity = new DetectionParameter.LocationDensity(50.0, 1440L);
        Instant validSinceInstant = this.validSince != null ? ZonedDateTime.of(this.validSince.atStartOfDay(), timezone).toInstant() : null;
        return new DetectionParameter(this.getId(), visitDetection, visitMerging, locationDensity, validSinceInstant, RecalculationState.NEEDED);
    }
}

