/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.dto;

import com.dedicatedcode.reitti.dto.LocationPoint;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;

public class OwntracksLocationRequest {
    @JsonProperty(value="_type")
    private String type;
    @JsonProperty(value="t")
    private String t;
    @JsonProperty(value="acc")
    private Double accuracy;
    @JsonProperty(value="alt")
    private Double altitude;
    @JsonProperty(value="batt")
    private Double battery;
    @JsonProperty(value="bs")
    private Boolean batteryStatus;
    @JsonProperty(value="lat")
    private Double latitude;
    @JsonProperty(value="lon")
    private Double longitude;
    @JsonProperty(value="tst")
    private Long timestamp;
    @JsonProperty(value="vel")
    private Double velocity;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getT() {
        return this.t;
    }

    public void setT(String t) {
        this.t = t;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public Double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(Double altitude) {
        this.altitude = altitude;
    }

    public Double getBattery() {
        return this.battery;
    }

    public void setBattery(Double battery) {
        this.battery = battery;
    }

    public Boolean getBatteryStatus() {
        return this.batteryStatus;
    }

    public void setBatteryStatus(Boolean batteryStatus) {
        this.batteryStatus = batteryStatus;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Double velocity) {
        this.velocity = velocity;
    }

    public boolean isLocationUpdate() {
        return "location".equals(this.type);
    }

    public LocationPoint toLocationPoint() {
        LocationPoint point = new LocationPoint();
        point.setLatitude(this.latitude);
        point.setLongitude(this.longitude);
        if (this.timestamp != null) {
            String isoTimestamp = Instant.ofEpochSecond(this.timestamp).toString();
            point.setTimestamp(isoTimestamp);
        }
        point.setElevationMeters(this.altitude);
        if (this.accuracy != null) {
            point.setAccuracyMeters(this.accuracy);
        }
        return point;
    }
}

