/*
 * Decompiled with CFR 0.152.
 */
package com.dedicatedcode.reitti.model;

import com.dedicatedcode.reitti.model.PageRequest;
import java.util.List;

public class Page<T> {
    private final List<T> content;
    private final PageRequest pageable;
    private final long totalElements;

    public Page(List<T> content, PageRequest pageable, long totalElements) {
        this.content = content;
        this.pageable = pageable;
        this.totalElements = totalElements;
    }

    public List<T> getContent() {
        return this.content;
    }

    public PageRequest getPageable() {
        return this.pageable;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public int getTotalPages() {
        return (int)Math.ceil((double)this.totalElements / (double)this.pageable.getPageSize());
    }

    public boolean hasNext() {
        return this.pageable.getPageNumber() + 1 < this.getTotalPages();
    }

    public boolean hasPrevious() {
        return this.pageable.getPageNumber() > 0;
    }

    public boolean isFirst() {
        return this.pageable.getPageNumber() == 0;
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public int getNumber() {
        return this.pageable.getPageNumber();
    }

    public int getSize() {
        return this.pageable.getPageSize();
    }

    public int getNumberOfElements() {
        return this.content.size();
    }
}

